/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.type;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import org.ballerinalang.diagramutil.connector.models.connector.Type;
import org.ballerinalang.diagramutil.connector.models.connector.types.RecordType;
import org.ballerinalang.diagramutil.connector.models.connector.types.UnionType;

public class TypeSymbolAnalyzerFromTypeModel {
    public static Type analyze(Symbol typeSymbol, String expr, SemanticModel semanticModel) {
        ExpressionNode expressionNode = NodeParser.parseExpression((String)expr);
        Type type = Type.fromSemanticSymbol((Symbol)typeSymbol, (SemanticModel)semanticModel);
        if (expressionNode instanceof MappingConstructorExpressionNode) {
            MappingConstructorExpressionNode mapping = (MappingConstructorExpressionNode)expressionNode;
            if (type instanceof RecordType) {
                RecordType recordType = (RecordType)type;
                TypeSymbolAnalyzerFromTypeModel.updateTypeConfig(recordType, mapping);
            } else if (type instanceof UnionType) {
                UnionType unionType = (UnionType)type;
                TypeSymbolAnalyzerFromTypeModel.updateUnionTypeConfig(unionType, mapping);
            }
        } else {
            throw new IllegalArgumentException("Invalid expression");
        }
        return type;
    }

    private static void updateUnionTypeConfig(UnionType unionType, MappingConstructorExpressionNode mappingConstructor) {
        ArrayList<Type> selectedTypes = new ArrayList<Type>();
        for (Type type : unionType.members) {
            if (type instanceof RecordType) {
                RecordType recordType = (RecordType)type;
                TypeSymbolAnalyzerFromTypeModel.updateTypeConfig(recordType, mappingConstructor);
            }
            if (!type.selected) continue;
            selectedTypes.add(type);
        }
        if (selectedTypes.size() == 1) {
            unionType.selected = true;
        } else {
            for (Type type : selectedTypes) {
                TypeSymbolAnalyzerFromTypeModel.reset(type);
            }
        }
    }

    private static void updateTypeConfig(RecordType recordType, MappingConstructorExpressionNode mappingConstructor) {
        HashMap fieldMap = new HashMap();
        HashMap requiredFields = new HashMap();
        recordType.fields.forEach(f -> {
            fieldMap.put(f.name, f);
            if (!f.optional && !f.defaultable) {
                requiredFields.put(f.name, f.name);
            }
        });
        boolean matched = true;
        for (MappingFieldNode fieldNode : mappingConstructor.fields()) {
            if (!(fieldNode instanceof SpecificFieldNode)) {
                matched = false;
                break;
            }
            SpecificFieldNode specificFieldNode = (SpecificFieldNode)fieldNode;
            String fieldName = specificFieldNode.fieldName().toSourceCode().trim();
            Type matchingType = (Type)fieldMap.get(fieldName);
            if (Objects.isNull(matchingType)) {
                matched = false;
                break;
            }
            if (specificFieldNode.valueExpr().isPresent()) {
                ExpressionNode expr = (ExpressionNode)specificFieldNode.valueExpr().get();
                if (expr instanceof MappingConstructorExpressionNode) {
                    MappingConstructorExpressionNode mapping = (MappingConstructorExpressionNode)expr;
                    if (matchingType instanceof RecordType) {
                        RecordType rt = (RecordType)matchingType;
                        TypeSymbolAnalyzerFromTypeModel.updateTypeConfig(rt, mapping);
                    } else if (matchingType instanceof UnionType) {
                        UnionType ut = (UnionType)matchingType;
                        TypeSymbolAnalyzerFromTypeModel.updateUnionTypeConfig(ut, mapping);
                    }
                } else {
                    matchingType.value = expr.toSourceCode();
                    matchingType.selected = true;
                }
                requiredFields.remove(fieldName);
                continue;
            }
            matchingType.value = fieldName;
            matchingType.selected = true;
            requiredFields.remove(fieldName);
        }
        if (!requiredFields.values().isEmpty() || !matched) {
            TypeSymbolAnalyzerFromTypeModel.reset((Type)recordType);
        } else {
            recordType.selected = true;
        }
    }

    private static void reset(Type type) {
        type.selected = false;
        type.value = "";
        if (type instanceof RecordType) {
            RecordType rt = (RecordType)type;
            for (Type field : rt.fields) {
                TypeSymbolAnalyzerFromTypeModel.reset(field);
            }
        }
    }
}

