/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.utils;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.modelgenerator.commons.PackageUtil;
import io.ballerina.projects.Document;
import io.ballerina.projects.Package;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.commons.eventsync.exceptions.EventSyncException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.eclipse.lsp4j.FileChangeType;
import org.eclipse.lsp4j.FileEvent;

public class FileSystemUtils {
    private static final List<Path> CREATED_FILES = new ArrayList<Path>();

    public static Document getDocument(WorkspaceManager workspaceManager, Path filePath) {
        Document document;
        try {
            document = (Document)workspaceManager.document(filePath).orElseThrow();
        }
        catch (Throwable e) {
            try {
                Files.createFile(filePath, new FileAttribute[0]);
                CREATED_FILES.add(filePath);
                FileEvent fileEvent = new FileEvent(filePath.toUri().toString(), FileChangeType.Created);
                workspaceManager.didChangeWatched(filePath, fileEvent);
                document = (Document)workspaceManager.document(filePath).orElseThrow();
            }
            catch (IOException | WorkspaceDocumentException fileCreationException) {
                throw new RuntimeException("Error occurred while creating the file: " + String.valueOf(filePath), fileCreationException);
            }
        }
        return document;
    }

    public static SemanticModel getSemanticModel(WorkspaceManager workspaceManager, Path filePath) {
        Optional optionalSemanticModel = workspaceManager.semanticModel(filePath);
        if (optionalSemanticModel.isPresent()) {
            return (SemanticModel)optionalSemanticModel.get();
        }
        Project project = (Project)workspaceManager.project(filePath).orElseThrow();
        Package currentPackage = project.currentPackage();
        return PackageUtil.getCompilation((Package)currentPackage).getSemanticModel(currentPackage.getDefaultModule().moduleId());
    }

    public static void createFileIfNotExists(WorkspaceManager workspaceManager, Path filePath) {
        try {
            workspaceManager.loadProject(filePath);
        }
        catch (EventSyncException | WorkspaceDocumentException e) {
            throw new RuntimeException(e);
        }
        catch (ProjectException e) {
            try {
                Files.createFile(filePath, new FileAttribute[0]);
                CREATED_FILES.add(filePath);
                FileEvent fileEvent = new FileEvent(filePath.toUri().toString(), FileChangeType.Created);
                workspaceManager.didChangeWatched(filePath, fileEvent);
            }
            catch (IOException | WorkspaceDocumentException fileCreationException) {
                throw new RuntimeException("Error occurred while creating the file: " + String.valueOf(filePath), fileCreationException);
            }
        }
    }

    public static void deleteCreatedFiles() {
        CREATED_FILES.forEach(path -> {
            try {
                Files.deleteIfExists(path);
            }
            catch (IOException e) {
                throw new RuntimeException("Error occurred while deleting the file: " + String.valueOf(path), e);
            }
        });
    }
}

