/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.utils;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.symbols.AbsResourcePathAttachPoint;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.Documentable;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.EnumSymbol;
import io.ballerina.compiler.api.symbols.ErrorTypeSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.FutureTypeSymbol;
import io.ballerina.compiler.api.symbols.IntersectionTypeSymbol;
import io.ballerina.compiler.api.symbols.LiteralAttachPoint;
import io.ballerina.compiler.api.symbols.MapTypeSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ObjectFieldSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.ResourceMethodSymbol;
import io.ballerina.compiler.api.symbols.ServiceAttachPoint;
import io.ballerina.compiler.api.symbols.ServiceAttachPointKind;
import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.api.symbols.StreamTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TableTypeSymbol;
import io.ballerina.compiler.api.symbols.TupleTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeDescTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.api.values.ConstantValue;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.RecordFieldWithDefaultValueNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.flowmodelgenerator.core.model.Function;
import io.ballerina.flowmodelgenerator.core.model.Member;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.TypeData;
import io.ballerina.flowmodelgenerator.core.utils.TypeDefinitionNodeVisitor;
import io.ballerina.flowmodelgenerator.core.utils.TypeUtils;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.modelgenerator.commons.ModuleInfo;
import io.ballerina.projects.Document;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TypeTransformer {
    private final Module module;
    private final ModuleInfo moduleInfo;
    private Map<String, RecordTypeDescriptorNode> recordTypeDescNodes;
    public static final String BUILT_IN_ERROR = "error";
    public static final String BUILT_IN_ANYDATA = "anydata";

    public TypeTransformer(Module module) {
        this.module = module;
        this.moduleInfo = ModuleInfo.from((ModuleDescriptor)module.descriptor());
    }

    public Object transform(ServiceDeclarationSymbol serviceDeclarationSymbol) {
        TypeData.TypeDataBuilder typeDataBuilder = new TypeData.TypeDataBuilder();
        String attachPoint = serviceDeclarationSymbol.attachPoint().map(this::getAttachPoint).orElse("");
        List<String> qualifiers = serviceDeclarationSymbol.qualifiers().stream().map(Qualifier::getValue).toList();
        ((TypeData.TypeDataBuilder)((TypeData.TypeDataBuilder)typeDataBuilder.name(attachPoint).editable().metadata().label(attachPoint).description(this.getDocumentString((Documentable)serviceDeclarationSymbol)).stepOut()).codedata().node(NodeKind.SERVICE_DECLARATION).lineRange(((Location)serviceDeclarationSymbol.getLocation().get()).lineRange()).stepOut()).properties().name(attachPoint, false, false, false).qualifiers(qualifiers, true, true, true).isArray("false", true, true, true).arraySize("", false, false, false);
        ArrayList<Member> fieldMembers = new ArrayList<Member>();
        serviceDeclarationSymbol.fieldDescriptors().forEach((name, symbol) -> fieldMembers.add(this.transformObjectFieldAsMember((String)name, (ObjectFieldSymbol)symbol)));
        typeDataBuilder.members(fieldMembers);
        List<Function> methods = this.transformMethodSymbols(serviceDeclarationSymbol.methods());
        typeDataBuilder.functions(methods);
        return typeDataBuilder.build();
    }

    public Object transform(ClassSymbol classSymbol) {
        TypeData.TypeDataBuilder typeDataBuilder = new TypeData.TypeDataBuilder();
        String typeName = this.getTypeName((Symbol)classSymbol);
        List qualifiers = classSymbol.qualifiers();
        String networkQualifier = qualifiers.contains(Qualifier.SERVICE) ? "service" : (qualifiers.contains(Qualifier.CLIENT) ? "client" : "");
        ((TypeData.TypeDataBuilder)((TypeData.TypeDataBuilder)typeDataBuilder.name(typeName).editable().metadata().label(typeName).description(this.getDocumentString((Documentable)classSymbol)).stepOut()).codedata().node(NodeKind.CLASS).lineRange(((Location)classSymbol.getLocation().get()).lineRange()).stepOut()).properties().name(typeName, false, false, false).qualifiers(qualifiers.stream().map(Qualifier::getValue).toList(), true, true, true).isArray("false", true, true, true).arraySize("", false, false, false).isPublic(qualifiers.contains(Qualifier.PUBLIC), true, true, false).isDistinct(qualifiers.contains(Qualifier.DISTINCT), true, true, false).isIsolated(qualifiers.contains(Qualifier.ISOLATED), true, true, false).isReadOnly(qualifiers.contains(Qualifier.READONLY), true, true, false).networkQualifier(networkQualifier, true, true, false);
        ArrayList<String> includes = new ArrayList<String>();
        classSymbol.typeInclusions().forEach(typeInclusion -> includes.add(CommonUtils.getTypeSignature((TypeSymbol)typeInclusion, (ModuleInfo)this.moduleInfo)));
        typeDataBuilder.includes(includes);
        ArrayList<Member> fieldMembers = new ArrayList<Member>();
        classSymbol.fieldDescriptors().forEach((name, symbol) -> fieldMembers.add(this.transformObjectFieldAsMember((String)name, (ObjectFieldSymbol)symbol)));
        typeDataBuilder.members(fieldMembers);
        List<Function> methods = this.transformMethodSymbols(classSymbol.methods());
        typeDataBuilder.functions(methods);
        return typeDataBuilder.build();
    }

    public Object transform(ObjectTypeSymbol objectTypeSymbol, TypeData.TypeDataBuilder typeDataBuilder) {
        typeDataBuilder.codedata().node(NodeKind.OBJECT);
        List qualifiers = objectTypeSymbol.qualifiers();
        String networkQualifier = qualifiers.contains(Qualifier.SERVICE) ? "service" : (qualifiers.contains(Qualifier.CLIENT) ? "client" : "");
        typeDataBuilder.properties().isIsolated(qualifiers.contains(Qualifier.ISOLATED), true, true, false).networkQualifier(networkQualifier, true, true, false);
        ArrayList<String> includes = new ArrayList<String>();
        objectTypeSymbol.typeInclusions().forEach(typeInclusion -> includes.add(CommonUtils.getTypeSignature((TypeSymbol)typeInclusion, (ModuleInfo)this.moduleInfo)));
        typeDataBuilder.includes(includes);
        ArrayList<Member> fieldMembers = new ArrayList<Member>();
        objectTypeSymbol.fieldDescriptors().forEach((name, symbol) -> fieldMembers.add(this.transformObjectFieldAsMember((String)name, (ObjectFieldSymbol)symbol)));
        typeDataBuilder.members(fieldMembers);
        List<Function> functions = this.transformMethodSymbols(objectTypeSymbol.methods());
        typeDataBuilder.functions(functions);
        return typeDataBuilder.build();
    }

    public Object transform(TypeDefinitionSymbol typeDef) {
        TypeData.TypeDataBuilder typeDataBuilder = new TypeData.TypeDataBuilder();
        String typeName = this.getTypeName((Symbol)typeDef);
        ((TypeData.TypeDataBuilder)((TypeData.TypeDataBuilder)typeDataBuilder.name(typeName).editable().metadata().label(typeName).stepOut()).codedata().lineRange(((Location)typeDef.getLocation().get()).lineRange()).stepOut()).properties().name(typeName, false, false, false).isPublic(typeDef.qualifiers().contains(Qualifier.PUBLIC), true, true, false);
        if (typeDef.documentation().isPresent()) {
            String doc = this.getDocumentString((Documentable)typeDef);
            ((TypeData.TypeDataBuilder)typeDataBuilder.metadata().description(doc).stepOut()).properties().description(doc, false, true, false);
        }
        return this.transform(typeDef.typeDescriptor(), typeDataBuilder);
    }

    public Object transform(EnumSymbol enumSymbol) {
        TypeData.TypeDataBuilder typeDataBuilder = new TypeData.TypeDataBuilder();
        String typeName = this.getTypeName((Symbol)enumSymbol);
        ((TypeData.TypeDataBuilder)((TypeData.TypeDataBuilder)typeDataBuilder.name(typeName).editable().metadata().label(typeName).stepOut()).codedata().node(NodeKind.ENUM).lineRange(((Location)enumSymbol.getLocation().get()).lineRange()).stepOut()).properties().name(typeName, false, false, false).isArray("false", true, true, true).arraySize("", false, false, false);
        if (enumSymbol.documentation().isPresent()) {
            String doc = this.getDocumentString((Documentable)enumSymbol);
            ((TypeData.TypeDataBuilder)typeDataBuilder.metadata().description(doc).stepOut()).properties().description(doc, false, true, false);
        }
        ArrayList<Member> members = new ArrayList<Member>();
        Member.MemberBuilder memberBuilder = new Member.MemberBuilder();
        enumSymbol.members().reversed().forEach(enumMember -> {
            String name = (String)enumMember.getName().get();
            ConstantValue constValue = (ConstantValue)enumMember.constValue();
            String constValueAsString = "\"" + String.valueOf(constValue.value()) + "\"";
            memberBuilder.name(name).kind(Member.MemberKind.NAME).type(constValueAsString).refs(List.of());
            if (!constValue.value().equals(name)) {
                memberBuilder.defaultValue(constValueAsString);
            }
            Member member = memberBuilder.build();
            members.add(member);
        });
        typeDataBuilder.members(members);
        return typeDataBuilder.build();
    }

    public Object transform(RecordTypeSymbol recordTypeSymbol, TypeData.TypeDataBuilder typeDataBuilder) {
        ((TypeData.TypeDataBuilder)typeDataBuilder.codedata().node(NodeKind.RECORD).stepOut()).properties().isArray("false", true, true, true).arraySize("", true, true, true);
        ArrayList<String> includes = new ArrayList<String>();
        recordTypeSymbol.typeInclusions().forEach(typeInclusion -> includes.add(CommonUtils.getTypeSignature((TypeSymbol)typeInclusion, (ModuleInfo)this.moduleInfo)));
        typeDataBuilder.includes(includes);
        Member.MemberBuilder memberBuilder = new Member.MemberBuilder();
        Optional restTypeSymbol = recordTypeSymbol.restTypeDescriptor();
        if (restTypeSymbol.isPresent()) {
            TypeData.TypeDataBuilder restTypeDataBuilder = new TypeData.TypeDataBuilder();
            Object transformedRestType = this.transform((TypeSymbol)restTypeSymbol.get(), restTypeDataBuilder);
            if (transformedRestType.equals(BUILT_IN_ANYDATA)) {
                typeDataBuilder.allowAdditionalFields(true);
            }
            Member restMember = memberBuilder.kind(Member.MemberKind.FIELD).type(transformedRestType).refs(this.getTypeRefs(transformedRestType, (TypeSymbol)restTypeSymbol.get())).build();
            typeDataBuilder.restMember(restMember);
        }
        ArrayList<Member> fieldMembers = new ArrayList<Member>();
        recordTypeSymbol.fieldDescriptors().forEach((fieldName, fieldSymbol) -> {
            TypeData.TypeDataBuilder memberTypeDataBuilder = new TypeData.TypeDataBuilder();
            Object transformedFieldType = this.transform(fieldSymbol.typeDescriptor(), memberTypeDataBuilder);
            Member member = memberBuilder.name((String)fieldName).kind(Member.MemberKind.FIELD).type(transformedFieldType).optional(fieldSymbol.isOptional()).refs(this.getTypeRefs(transformedFieldType, fieldSymbol.typeDescriptor())).docs(this.getDocumentString((Documentable)fieldSymbol)).defaultValue(this.getDefaultValueOfField(typeDataBuilder.name(), (String)fieldName).orElse(null)).build();
            fieldMembers.add(member);
        });
        typeDataBuilder.members(fieldMembers);
        return typeDataBuilder.build();
    }

    public Object transform(UnionTypeSymbol unionTypeSymbol, TypeData.TypeDataBuilder typeDataBuilder) {
        ((TypeData.TypeDataBuilder)typeDataBuilder.codedata().node(NodeKind.UNION).stepOut()).properties().isArray("false", true, true, true).arraySize("", false, false, false);
        Member.MemberBuilder memberBuilder = new Member.MemberBuilder();
        ArrayList<Member> memberTypes = new ArrayList<Member>();
        unionTypeSymbol.userSpecifiedMemberTypes().forEach(memberTypeSymbol -> {
            String name = CommonUtils.getTypeSignature((TypeSymbol)memberTypeSymbol, (ModuleInfo)this.moduleInfo);
            Member member = this.transformTypeAsMember(name, (TypeSymbol)memberTypeSymbol, memberBuilder);
            memberTypes.add(member);
        });
        typeDataBuilder.members(memberTypes);
        return typeDataBuilder.build();
    }

    public Object transform(IntersectionTypeSymbol intersectionTypeSymbol, TypeData.TypeDataBuilder typeDataBuilder) {
        ((TypeData.TypeDataBuilder)typeDataBuilder.codedata().node(NodeKind.INTERSECTION).stepOut()).properties().isArray("false", true, true, true).arraySize("", false, false, false);
        Member.MemberBuilder memberBuilder = new Member.MemberBuilder();
        ArrayList<Member> memberTypes = new ArrayList<Member>();
        intersectionTypeSymbol.memberTypeDescriptors().forEach(memberTypeSymbol -> {
            String name = CommonUtils.getTypeSignature((TypeSymbol)memberTypeSymbol, (ModuleInfo)this.moduleInfo);
            Member member = this.transformTypeAsMember(name, (TypeSymbol)memberTypeSymbol, memberBuilder);
            memberTypes.add(member);
        });
        typeDataBuilder.members(memberTypes);
        return typeDataBuilder.build();
    }

    public Object transform(TableTypeSymbol tableTypeSymbol, TypeData.TypeDataBuilder typeDataBuilder) {
        ((TypeData.TypeDataBuilder)typeDataBuilder.codedata().node(NodeKind.TABLE).stepOut()).properties().isArray("false", true, true, true).arraySize("", false, false, false);
        Member.MemberBuilder memberBuilder = new Member.MemberBuilder();
        ArrayList<Member> memberTypes = new ArrayList<Member>();
        TypeSymbol rowTypeSymbol = tableTypeSymbol.rowTypeParameter();
        Object transformedRowType = this.transform(rowTypeSymbol, new TypeData.TypeDataBuilder());
        Member rowTypeMember = memberBuilder.name("rowType").kind(Member.MemberKind.TYPE).type(transformedRowType).refs(this.getTypeRefs(transformedRowType, rowTypeSymbol)).build();
        memberTypes.add(rowTypeMember);
        tableTypeSymbol.keyConstraintTypeParameter().ifPresent(typeSymbol -> {
            Object transformedKeyConstraintType = this.transform((TypeSymbol)typeSymbol, new TypeData.TypeDataBuilder());
            Member keyConstraintTypeMember = memberBuilder.name("keyConstraintType").kind(Member.MemberKind.TYPE).type(transformedKeyConstraintType).refs(this.getTypeRefs(transformedRowType, (TypeSymbol)typeSymbol)).build();
            memberTypes.add(keyConstraintTypeMember);
        });
        typeDataBuilder.members(memberTypes);
        return typeDataBuilder.build();
    }

    public Object transform(ArrayTypeSymbol arrayTypeSymbol, TypeData.TypeDataBuilder typeDataBuilder) {
        typeDataBuilder.properties().isArray("true", true, true, true).arraySize(arrayTypeSymbol.size().isPresent() ? ((Integer)arrayTypeSymbol.size().get()).toString() : "", true, true, true);
        return this.transformTypesWithConstraintType((TypeSymbol)arrayTypeSymbol, NodeKind.ARRAY, typeDataBuilder);
    }

    public Object transform(MapTypeSymbol mapTypeSymbol, TypeData.TypeDataBuilder typeDataBuilder) {
        return this.transformTypesWithConstraintType((TypeSymbol)mapTypeSymbol, NodeKind.MAP, typeDataBuilder);
    }

    public Object transform(StreamTypeSymbol streamTypeSymbol, TypeData.TypeDataBuilder typeDataBuilder) {
        return this.transformTypesWithConstraintType((TypeSymbol)streamTypeSymbol, NodeKind.STREAM, typeDataBuilder);
    }

    public Object transform(FutureTypeSymbol futureTypeSymbol, TypeData.TypeDataBuilder typeDataBuilder) {
        return this.transformTypesWithConstraintType((TypeSymbol)futureTypeSymbol, NodeKind.FUTURE, typeDataBuilder);
    }

    public Object transform(TypeDescTypeSymbol typeDescTypeSymbol, TypeData.TypeDataBuilder typeDataBuilder) {
        return this.transformTypesWithConstraintType((TypeSymbol)typeDescTypeSymbol, NodeKind.TYPEDESC, typeDataBuilder);
    }

    public Object transform(ErrorTypeSymbol errorTypeSymbol, TypeData.TypeDataBuilder typeDataBuilder) {
        if (errorTypeSymbol.signature().equals(BUILT_IN_ERROR)) {
            return BUILT_IN_ERROR;
        }
        return this.transformTypesWithConstraintType((TypeSymbol)errorTypeSymbol, NodeKind.ERROR, typeDataBuilder);
    }

    public Object transform(TupleTypeSymbol tupleTypeSymbol, TypeData.TypeDataBuilder typeBuilder) {
        ((TypeData.TypeDataBuilder)typeBuilder.codedata().node(NodeKind.TUPLE).stepOut()).properties().isArray("false", true, true, true).arraySize("", false, false, false);
        Member.MemberBuilder memberBuilder = new Member.MemberBuilder();
        ArrayList<Member> memberTypes = new ArrayList<Member>();
        tupleTypeSymbol.memberTypeDescriptors().forEach(memberTypeSymbol -> {
            String name = CommonUtils.getTypeSignature((TypeSymbol)memberTypeSymbol, (ModuleInfo)this.moduleInfo);
            Member member = this.transformTypeAsMember(name, (TypeSymbol)memberTypeSymbol, memberBuilder);
            memberTypes.add(member);
        });
        typeBuilder.members(memberTypes);
        return typeBuilder.build();
    }

    public Object transform(TypeSymbol typeSymbol, TypeData.TypeDataBuilder typeDataBuilder) {
        return switch (typeSymbol.typeKind()) {
            case TypeDescKind.RECORD -> this.transform((RecordTypeSymbol)typeSymbol, typeDataBuilder);
            case TypeDescKind.ARRAY -> this.transform((ArrayTypeSymbol)typeSymbol, typeDataBuilder);
            case TypeDescKind.MAP -> this.transform((MapTypeSymbol)typeSymbol, typeDataBuilder);
            case TypeDescKind.STREAM -> this.transform((StreamTypeSymbol)typeSymbol, typeDataBuilder);
            case TypeDescKind.FUTURE -> this.transform((FutureTypeSymbol)typeSymbol, typeDataBuilder);
            case TypeDescKind.TYPEDESC -> this.transform((TypeDescTypeSymbol)typeSymbol, typeDataBuilder);
            case TypeDescKind.ERROR -> this.transform((ErrorTypeSymbol)typeSymbol, typeDataBuilder);
            case TypeDescKind.UNION -> this.transform((UnionTypeSymbol)typeSymbol, typeDataBuilder);
            case TypeDescKind.INTERSECTION -> this.transform((IntersectionTypeSymbol)typeSymbol, typeDataBuilder);
            case TypeDescKind.OBJECT -> this.transform((ObjectTypeSymbol)typeSymbol, typeDataBuilder);
            case TypeDescKind.TABLE -> this.transform((TableTypeSymbol)typeSymbol, typeDataBuilder);
            case TypeDescKind.TUPLE -> this.transform((TupleTypeSymbol)typeSymbol, typeDataBuilder);
            default -> CommonUtils.getTypeSignature((TypeSymbol)typeSymbol, (ModuleInfo)this.moduleInfo);
        };
    }

    private Map<String, RecordTypeDescriptorNode> getRecordTypeDescNodes() {
        if (this.recordTypeDescNodes != null) {
            return this.recordTypeDescNodes;
        }
        TypeDefinitionNodeVisitor typeDefNodeVisitor = new TypeDefinitionNodeVisitor();
        this.module.documentIds().forEach(documentId -> {
            Document document = this.module.document(documentId);
            SyntaxTree syntaxTree = document.syntaxTree();
            syntaxTree.rootNode().accept((NodeVisitor)typeDefNodeVisitor);
        });
        this.recordTypeDescNodes = typeDefNodeVisitor.getRecordTypeDescNodes();
        return this.recordTypeDescNodes;
    }

    private Optional<String> getDefaultValueOfField(String typeName, String fieldName) {
        RecordTypeDescriptorNode recordTypeDescriptorNode = this.getRecordTypeDescNodes().get(typeName);
        if (recordTypeDescriptorNode == null) {
            return Optional.empty();
        }
        return recordTypeDescriptorNode.fields().stream().filter(field -> field.kind() == SyntaxKind.RECORD_FIELD_WITH_DEFAULT_VALUE && ((RecordFieldWithDefaultValueNode)field).fieldName().text().equals(fieldName)).findFirst().map(node -> ((RecordFieldWithDefaultValueNode)node).expression().toString());
    }

    private String getDocumentString(Documentable documentable) {
        if (documentable.documentation().isPresent()) {
            return ((Documentation)documentable.documentation().get()).description().orElse("");
        }
        return null;
    }

    private Object transformTypesWithConstraintType(TypeSymbol typeSymbol, NodeKind nodeKind, TypeData.TypeDataBuilder typeDataBuilder) {
        TypeSymbol memberTypeDesc;
        typeDataBuilder.codedata().node(nodeKind);
        if (nodeKind != NodeKind.ARRAY) {
            typeDataBuilder.properties().isArray("false", true, true, true).arraySize("", false, false, false);
        }
        Member.MemberBuilder memberBuilder = new Member.MemberBuilder();
        switch (typeSymbol.typeKind()) {
            case ARRAY: {
                TypeSymbol typeSymbol2 = ((ArrayTypeSymbol)typeSymbol).memberTypeDescriptor();
                break;
            }
            case MAP: {
                TypeSymbol typeSymbol2 = ((MapTypeSymbol)typeSymbol).typeParam();
                break;
            }
            case FUTURE: {
                TypeSymbol typeSymbol2 = ((FutureTypeSymbol)typeSymbol).typeParameter().orElse(null);
                break;
            }
            case STREAM: {
                TypeSymbol typeSymbol2 = ((StreamTypeSymbol)typeSymbol).typeParameter();
                break;
            }
            case TYPEDESC: {
                TypeSymbol typeSymbol2 = ((TypeDescTypeSymbol)typeSymbol).typeParameter().orElse(null);
                break;
            }
            case ERROR: {
                TypeSymbol typeSymbol2 = ((ErrorTypeSymbol)typeSymbol).detailTypeDescriptor();
                break;
            }
            default: {
                TypeSymbol typeSymbol2 = memberTypeDesc = null;
            }
        }
        if (memberTypeDesc == null) {
            return typeDataBuilder.build();
        }
        String memberTypeName = CommonUtils.getTypeSignature((TypeSymbol)memberTypeDesc, (ModuleInfo)this.moduleInfo);
        Member memberType = this.transformTypeAsMember(memberTypeName, memberTypeDesc, memberBuilder);
        typeDataBuilder.members(List.of(memberType));
        return typeDataBuilder.build();
    }

    private List<Function> transformMethodSymbols(Map<String, ? extends MethodSymbol> methods) {
        return methods.values().stream().map(this::transformFunction).toList();
    }

    private Function transformFunction(FunctionSymbol functionSymbol) {
        Function.FunctionBuilder functionBuilder = new Function.FunctionBuilder();
        Member.MemberBuilder memberBuilder = new Member.MemberBuilder();
        List functionQuals = functionSymbol.qualifiers();
        functionBuilder.kind(Function.FunctionKind.FUNCTION);
        ArrayList<String> qualifiers = new ArrayList<String>();
        functionQuals.forEach(q -> {
            qualifiers.add(q.name());
            if (q.equals((Object)Qualifier.REMOTE)) {
                functionBuilder.kind(Function.FunctionKind.REMOTE);
            } else if (q.equals((Object)Qualifier.RESOURCE)) {
                functionBuilder.kind(Function.FunctionKind.RESOURCE);
            }
        });
        functionBuilder.qualifiers(qualifiers);
        functionBuilder.docs(this.getDocumentString((Documentable)functionSymbol)).name(functionSymbol.getName().orElse("")).properties().isPrivate(functionQuals.contains(Qualifier.PRIVATE), true, true, false).isPublic(functionQuals.contains(Qualifier.PUBLIC), true, true, false).isIsolated(functionQuals.contains(Qualifier.ISOLATED), true, true, false);
        FunctionTypeSymbol functionTypeSymbol = functionSymbol.typeDescriptor();
        functionTypeSymbol.returnTypeDescriptor().ifPresent(returnType -> {
            Object transformed = this.transform((TypeSymbol)returnType, new TypeData.TypeDataBuilder());
            functionBuilder.returnType(transformed).refs(this.getTypeRefs(transformed, (TypeSymbol)returnType));
        });
        functionTypeSymbol.params().ifPresent(params -> {
            List<Member> parameters = params.stream().map(param -> {
                Object transformedParamType = this.transform(param.typeDescriptor(), new TypeData.TypeDataBuilder());
                return memberBuilder.name(param.getName().orElse(null)).kind(Member.MemberKind.FIELD).type(transformedParamType).refs(this.getTypeRefs(transformedParamType, param.typeDescriptor())).build();
            }).toList();
            functionBuilder.parameters(parameters);
        });
        functionTypeSymbol.restParam().ifPresent(restParam -> {
            Object transformedRestParamType = this.transform(restParam.typeDescriptor(), new TypeData.TypeDataBuilder());
            Member restParameter = memberBuilder.name((String)restParam.getName().get()).kind(Member.MemberKind.FIELD).type(transformedRestParamType).refs(this.getTypeRefs(transformedRestParamType, restParam.typeDescriptor())).build();
            functionBuilder.restParameter(restParameter);
        });
        if (functionSymbol.kind().equals((Object)SymbolKind.RESOURCE_METHOD)) {
            functionBuilder.name(((ResourceMethodSymbol)functionSymbol).resourcePath().signature()).accessor(functionSymbol.getName().orElse(""));
        }
        return functionBuilder.build();
    }

    private Member transformObjectFieldAsMember(String fieldName, ObjectFieldSymbol fieldSymbol) {
        TypeData.TypeDataBuilder attributeTypeDataBuilder = new TypeData.TypeDataBuilder();
        Object transformedAttributeType = this.transform(fieldSymbol.typeDescriptor(), attributeTypeDataBuilder);
        return new Member.MemberBuilder().name(fieldName).kind(Member.MemberKind.FIELD).type(transformedAttributeType).refs(this.getTypeRefs(transformedAttributeType, fieldSymbol.typeDescriptor())).docs(this.getDocumentString((Documentable)fieldSymbol)).build();
    }

    private Member transformTypeAsMember(String typeName, TypeSymbol memberTypeDesc, Member.MemberBuilder memberBuilder) {
        TypeData.TypeDataBuilder memberTypeDataBuilder = new TypeData.TypeDataBuilder();
        Object transformedMemberType = this.transform(memberTypeDesc, memberTypeDataBuilder);
        return memberBuilder.name(typeName).kind(Member.MemberKind.TYPE).type(transformedMemberType).refs(this.getTypeRefs(transformedMemberType, memberTypeDesc)).build();
    }

    private String getAttachPoint(ServiceAttachPoint attachPoint) {
        return switch (attachPoint.kind()) {
            default -> throw new MatchException(null, null);
            case ServiceAttachPointKind.ABSOLUTE_RESOURCE_PATH -> "/" + String.join((CharSequence)"/", ((AbsResourcePathAttachPoint)attachPoint).segments());
            case ServiceAttachPointKind.STRING_LITERAL -> ((LiteralAttachPoint)attachPoint).literal();
        };
    }

    private String getTypeName(Symbol symbol) {
        String typeName;
        if (CommonUtils.isWithinPackage((Symbol)symbol, (ModuleInfo)this.moduleInfo)) {
            typeName = (String)symbol.getName().get();
        } else {
            ModuleID recTypeModuleId = ((ModuleSymbol)symbol.getModule().get()).id();
            typeName = String.format("%s/%s:%s", recTypeModuleId.orgName(), recTypeModuleId.packageName(), symbol.getName().get());
        }
        return typeName;
    }

    private List<String> getTypeRefs(Object type, TypeSymbol typeDescriptor) {
        return type instanceof String ? TypeUtils.getTypeRefIds(typeDescriptor, this.moduleInfo) : List.of();
    }
}

