/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.validator;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.openapi.validator.NodeValidator;
import io.ballerina.openapi.validator.TypeValidatorUtils;
import io.ballerina.openapi.validator.ValidatorContext;
import io.ballerina.openapi.validator.ValidatorUtils;
import io.ballerina.openapi.validator.error.CompilationError;
import io.ballerina.tools.diagnostics.Location;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class RequestBodyValidator
extends NodeValidator {
    private final RequestBody oasRequestBody;
    private final RequiredParameterNode body;
    private Location location;

    public RequestBodyValidator(ValidatorContext validatorContext, RequestBody oasRequestBody, RequiredParameterNode body) {
        super(validatorContext);
        this.body = body;
        this.oasRequestBody = oasRequestBody;
    }

    @Override
    public void validateBallerinaToOpenAPI() {
        if (this.body != null && this.oasRequestBody == null) {
            ValidatorUtils.reportDiagnostic(this.validatorContext.getContext(), CompilationError.UNDEFINED_REQUEST_BODY, (Location)this.body.location(), this.validatorContext.getSeverity(), this.validatorContext.getMethod(), ValidatorUtils.getNormalizedPath(this.validatorContext.getPath()));
            return;
        }
        this.location = this.validatorContext.getLocation();
        if (this.oasRequestBody != null && this.body != null) {
            boolean isMediaTypeExist = false;
            this.location = this.body.location();
            SemanticModel semanticModel = this.validatorContext.getContext().semanticModel();
            List<String> mediaTypes = ValidatorUtils.extractAnnotationFieldDetails("http:Payload", "mediaType", (NodeList<AnnotationNode>)this.body.annotations(), semanticModel);
            Content content = this.oasRequestBody.getContent();
            if (mediaTypes.isEmpty() && content != null) {
                Node typeNode = this.body.typeName();
                SyntaxKind kind = typeNode.kind();
                String mediaType = ValidatorUtils.getMediaType(kind);
                ArrayList<String> oasMediaTypes = new ArrayList<String>();
                for (Map.Entry oasMedia : content.entrySet()) {
                    oasMediaTypes.add((String)oasMedia.getKey());
                    if (!Objects.equals(oasMedia.getKey(), mediaType)) continue;
                    isMediaTypeExist = true;
                    if (((MediaType)oasMedia.getValue()).getSchema() == null) {
                        return;
                    }
                    Schema schema = ((MediaType)oasMedia.getValue()).getSchema();
                    if (schema == null || schema.get$ref() == null && !(schema instanceof ObjectSchema) && !(schema instanceof ArraySchema)) {
                        return;
                    }
                    Optional<Object> oasName = Optional.empty();
                    if (schema.get$ref() != null) {
                        oasName = ValidatorUtils.extractReferenceType(schema.get$ref());
                    }
                    if (this.body.paramName().isEmpty() && oasName.isEmpty()) {
                        return;
                    }
                    Optional symbol = semanticModel.symbol((Node)this.body);
                    if (symbol.isEmpty()) {
                        return;
                    }
                    String balRecordName = this.body.typeName().toString().trim();
                    TypeSymbol typeSymbol = ((ParameterSymbol)symbol.get()).typeDescriptor();
                    if (typeSymbol instanceof TypeReferenceTypeSymbol) {
                        this.validateRecordTypePayload(mediaType, schema, oasName.orElse(null), balRecordName, typeSymbol);
                        continue;
                    }
                    if (typeSymbol instanceof ArrayTypeSymbol) {
                        ArrayTypeSymbol arrayType = (ArrayTypeSymbol)typeSymbol;
                        this.validateArrayTypePayload(this.body, mediaType, oasMediaTypes, schema, arrayType);
                        return;
                    }
                    return;
                }
                if (!isMediaTypeExist) {
                    ValidatorUtils.reportDiagnostic(this.validatorContext.getContext(), CompilationError.UNDEFINED_REQUEST_MEDIA_TYPE, (Location)this.body.location(), this.validatorContext.getSeverity(), mediaType, this.validatorContext.getMethod(), ValidatorUtils.getNormalizedPath(this.validatorContext.getPath()));
                }
            }
        }
    }

    private void validateArrayTypePayload(RequiredParameterNode requestBodyNode, String mediaType, List<String> oasMediaTypes, Schema<?> schema, ArrayTypeSymbol arrayType) {
        if (arrayType.memberTypeDescriptor() instanceof TypeReferenceTypeSymbol) {
            String balRecordName = requestBodyNode.typeName().toString().trim().replaceAll("\\[", "").replaceAll("\\]", "");
            if (!(schema instanceof ArraySchema)) {
                ValidatorUtils.reportDiagnostic(this.validatorContext.getContext(), CompilationError.TYPEMISMATCH_REQUEST_BODY_PAYLOAD, (Location)requestBodyNode.location(), this.validatorContext.getSeverity(), mediaType, oasMediaTypes.toString(), ((Token)requestBodyNode.paramName().get()).toString().trim(), this.validatorContext.getMethod(), ValidatorUtils.getNormalizedPath(this.validatorContext.getPath()));
            } else {
                ArraySchema arraySchema = (ArraySchema)schema;
                if (arraySchema.getItems().get$ref() != null) {
                    String oasSchemaName = ValidatorUtils.extractReferenceType(arraySchema.getItems().get$ref()).get();
                    schema = this.validatorContext.getOpenAPI().getComponents().getSchemas().get(oasSchemaName);
                    TypeValidatorUtils.validateRecordType(schema, arrayType.memberTypeDescriptor(), balRecordName, this.validatorContext.getContext(), this.validatorContext.getOpenAPI(), oasSchemaName, this.validatorContext.getSeverity());
                }
            }
        }
    }

    private void validateRecordTypePayload(String mediaType, Schema<?> schema, String oasName, String balRecordName, TypeSymbol typeSymbol) {
        if (schema instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)schema;
            Optional<String> itemType = ValidatorUtils.extractReferenceType(arraySchema.getItems().get$ref());
            Object item = "array";
            if (itemType.isPresent()) {
                item = itemType.get() + "[]";
            }
            ValidatorUtils.reportDiagnostic(this.validatorContext.getContext(), CompilationError.TYPEMISMATCH_REQUEST_BODY_PAYLOAD, this.location, this.validatorContext.getSeverity(), mediaType, item, balRecordName, this.validatorContext.getMethod(), ValidatorUtils.getNormalizedPath(this.validatorContext.getPath()));
        } else if (schema instanceof ObjectSchema || schema.get$ref() != null) {
            if (balRecordName.equals(oasName)) {
                OpenAPI openAPI = this.validatorContext.getOpenAPI();
                schema = openAPI.getComponents().getSchemas().get(oasName);
                TypeValidatorUtils.validateRecordType(schema, typeSymbol, balRecordName, this.validatorContext.getContext(), openAPI, oasName, this.validatorContext.getSeverity());
            } else {
                ValidatorUtils.reportDiagnostic(this.validatorContext.getContext(), CompilationError.TYPEMISMATCH_REQUEST_BODY_PAYLOAD, this.location, this.validatorContext.getSeverity(), mediaType, oasName, balRecordName, this.validatorContext.getMethod(), ValidatorUtils.getNormalizedPath(this.validatorContext.getPath()));
            }
        }
    }

    @Override
    public void validateOpenAPIToBallerina() {
        if (this.oasRequestBody == null) {
            return;
        }
        Content content = this.oasRequestBody.getContent();
        if (this.body == null) {
            ValidatorUtils.reportDiagnostic(this.validatorContext.getContext(), CompilationError.MISSING_REQUEST_BODY, this.location, this.validatorContext.getSeverity(), this.validatorContext.getMethod(), this.validatorContext.getPath());
            return;
        }
        if (content != null) {
            ArrayList<String> missingPayload = new ArrayList<String>();
            for (Map.Entry mediaTypeEntry : content.entrySet()) {
                SyntaxKind kind = this.body.typeName().kind();
                String mediaType = ValidatorUtils.getMediaType(kind);
                if (((String)mediaTypeEntry.getKey()).equals(mediaType)) {
                    MediaType value = (MediaType)mediaTypeEntry.getValue();
                    Schema schema = value.getSchema();
                    String balPayloadType = ((Token)this.body.paramName().get()).toString();
                    Optional symbol = this.validatorContext.getContext().semanticModel().symbol((Node)this.body);
                    if (symbol.isEmpty()) {
                        return;
                    }
                    TypeSymbol typeSymbol = ((ParameterSymbol)symbol.get()).typeDescriptor();
                    if (schema != null && schema.get$ref() != null) {
                        String ref = schema.get$ref();
                        Optional<String> schemaName = ValidatorUtils.extractReferenceType(ref);
                        if (schemaName.isEmpty()) {
                            return;
                        }
                        Map<String, Schema> schemas = this.validatorContext.getOpenAPI().getComponents().getSchemas();
                        if (!schemas.containsKey(schemaName.get())) continue;
                        Schema payloadSchema = schemas.get(schemaName.get());
                        if (typeSymbol instanceof TypeReferenceTypeSymbol) {
                            balPayloadType = this.body.typeName().toString().trim();
                        }
                        if (!(payloadSchema instanceof ObjectSchema)) continue;
                        TypeValidatorUtils.validateObjectSchema((ObjectSchema)payloadSchema, typeSymbol, this.validatorContext.getContext(), balPayloadType, this.location, this.validatorContext.getSeverity());
                        continue;
                    }
                    if (schema instanceof ComposedSchema) {
                        return;
                    }
                    if (!(schema instanceof ArraySchema)) continue;
                    ArraySchema arraySchema = (ArraySchema)schema;
                    this.validateArraySchema(typeSymbol, arraySchema);
                    return;
                }
                missingPayload.add((String)mediaTypeEntry.getKey());
            }
            if (content.entrySet().size() != 1) {
                ValidatorUtils.reportDiagnostic(this.validatorContext.getContext(), CompilationError.MISSING_REQUEST_MEDIA_TYPE, (Location)this.body.location(), this.validatorContext.getSeverity(), ((Object)missingPayload).toString(), this.validatorContext.getMethod(), this.validatorContext.getPath());
            }
        }
    }

    private void validateArraySchema(TypeSymbol typeSymbol, ArraySchema arraySchema) {
        if (arraySchema.getItems().get$ref() != null) {
            ArrayTypeSymbol arrayType;
            String oasSchemaName = ValidatorUtils.extractReferenceType(arraySchema.getItems().get$ref()).get();
            Schema schema = this.validatorContext.getOpenAPI().getComponents().getSchemas().get(oasSchemaName);
            if (typeSymbol instanceof ArrayTypeSymbol && (arrayType = (ArrayTypeSymbol)typeSymbol).memberTypeDescriptor() instanceof TypeReferenceTypeSymbol && schema instanceof ObjectSchema) {
                String balPayloadType = this.body.typeName().toString().trim().replaceAll("\\[", "").replaceAll("]", "");
                TypeValidatorUtils.validateObjectSchema((ObjectSchema)schema, arrayType.memberTypeDescriptor(), this.validatorContext.getContext(), balPayloadType, this.location, this.validatorContext.getSeverity());
            }
        }
    }
}

