/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.validator;

import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.OptionalTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.UnionTypeDescriptorNode;
import io.ballerina.openapi.validator.Constants;
import io.ballerina.openapi.validator.NodeValidator;
import io.ballerina.openapi.validator.TypeValidatorUtils;
import io.ballerina.openapi.validator.ValidatorContext;
import io.ballerina.openapi.validator.ValidatorUtils;
import io.ballerina.openapi.validator.error.CompilationError;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ReturnTypeValidator
extends NodeValidator {
    private final Map<String, Node> balStatusCodes = new HashMap<String, Node>();
    private final Map<String, List<String>> balMediaTypes = new HashMap<String, List<String>>();
    private TypeDescriptorNode returnNode;
    private final ApiResponses responses;

    public ReturnTypeValidator(ValidatorContext validatorContext, TypeDescriptorNode returnNode, ApiResponses responses) {
        super(validatorContext);
        this.returnNode = returnNode;
        this.responses = responses;
    }

    @Override
    public void validateBallerinaToOpenAPI() {
        boolean isOptional = false;
        if (this.returnNode == null) {
            this.balStatusCodes.put("202", null);
        } else {
            SyntaxKind kind = this.returnNode.kind();
            if (this.returnNode instanceof QualifiedNameReferenceNode) {
                QualifiedNameReferenceNode qNode = (QualifiedNameReferenceNode)this.returnNode;
                this.validateQualifiedType(qNode);
            } else if (this.returnNode instanceof UnionTypeDescriptorNode) {
                UnionTypeDescriptorNode uNode = (UnionTypeDescriptorNode)this.returnNode;
                this.validateUnionType(uNode, this.responses);
            } else if (this.returnNode instanceof SimpleNameReferenceNode) {
                SimpleNameReferenceNode simpleRefNode = (SimpleNameReferenceNode)this.returnNode;
                this.validateSimpleNameReference(simpleRefNode, this.responses);
            } else if (kind == SyntaxKind.ERROR_TYPE_DESC) {
                this.balStatusCodes.put("500", null);
            } else if (this.returnNode instanceof OptionalTypeDescriptorNode) {
                isOptional = true;
                OptionalTypeDescriptorNode optionalNode = (OptionalTypeDescriptorNode)this.returnNode;
                this.returnNode = (TypeDescriptorNode)optionalNode.typeDescriptor();
                this.validateBallerinaToOpenAPI();
            } else if (this.returnNode instanceof BuiltinSimpleNameReferenceNode) {
                this.balStatusCodes.put("200", (Node)this.returnNode);
                if (this.responses.containsKey("200")) {
                    String mediaType = ValidatorUtils.getMediaType(kind);
                    this.fillMediaTypes("200", mediaType);
                }
            }
        }
        if (!isOptional) {
            Set<String> ballerinaCodes = this.balStatusCodes.keySet();
            Set oasKeys = this.responses.keySet();
            ArrayList<String> undefineCode = new ArrayList<String>(ballerinaCodes);
            undefineCode.removeAll(oasKeys);
            if (undefineCode.size() > 0) {
                ValidatorUtils.reportDiagnostic(this.validatorContext.getContext(), CompilationError.UNDEFINED_RETURN_CODE, this.validatorContext.getLocation(), this.validatorContext.getSeverity(), ((Object)undefineCode).toString(), this.validatorContext.getMethod(), this.validatorContext.getPath());
            }
            this.balMediaTypes.forEach((key, value) -> {
                if (this.responses.containsKey(key)) {
                    ApiResponse apiResponse = (ApiResponse)this.responses.get(key);
                    if (apiResponse.getContent() != null) {
                        Set oasMediaTypes = apiResponse.getContent().keySet();
                        ArrayList undefinedMediaTypes = new ArrayList(value);
                        undefinedMediaTypes.removeAll(oasMediaTypes);
                        if (undefinedMediaTypes.size() > 0) {
                            ValidatorUtils.reportDiagnostic(this.validatorContext, CompilationError.UNDEFINED_RETURN_MEDIA_TYPE, ((Object)undefinedMediaTypes).toString(), key, this.validatorContext.getMethod(), this.validatorContext.getPath());
                        }
                    } else {
                        ValidatorUtils.reportDiagnostic(this.validatorContext, CompilationError.UNDEFINED_RETURN_MEDIA_TYPE, value.toString(), key, this.validatorContext.getMethod(), this.validatorContext.getPath());
                    }
                }
            });
        }
    }

    private void validateSimpleNameReference(SimpleNameReferenceNode simpleRefNode, ApiResponses responses) {
        TypeReferenceTypeSymbol refType;
        TypeSymbol type;
        Optional symbol = this.validatorContext.getContext().semanticModel().symbol((Node)simpleRefNode);
        if (symbol.isEmpty()) {
            return;
        }
        if (symbol.get() instanceof TypeReferenceTypeSymbol && (type = (refType = (TypeReferenceTypeSymbol)symbol.get()).typeDescriptor()) instanceof RecordTypeSymbol) {
            HashMap oasSchemas;
            RecordTypeSymbol typeSymbol = (RecordTypeSymbol)type;
            List typeInclusions = typeSymbol.typeInclusions();
            boolean isHttp = false;
            Components components = this.validatorContext.getOpenAPI().getComponents();
            HashMap hashMap = oasSchemas = Objects.nonNull(components) ? components.getSchemas() : new HashMap();
            if (!typeInclusions.isEmpty()) {
                for (TypeSymbol typeInSymbol : typeInclusions) {
                    if (!"http".equals(((ModuleSymbol)typeInSymbol.getModule().orElseThrow()).getName().orElseThrow())) continue;
                    isHttp = true;
                    Optional<String> code = this.generateApiResponseCode(((String)typeInSymbol.getName().orElseThrow()).trim());
                    if (code.isEmpty()) {
                        return;
                    }
                    this.balStatusCodes.put(code.get(), (Node)simpleRefNode);
                    if (!responses.containsKey(code.get())) continue;
                    ApiResponse apiResponse = (ApiResponse)responses.get(code.get());
                    Map fields = typeSymbol.fieldDescriptors();
                    TypeSymbol bodyFieldType = ((RecordFieldSymbol)fields.get("body")).typeDescriptor();
                    TypeDescKind bodyKind = bodyFieldType.typeKind();
                    String mediaType = ValidatorUtils.getMediaType(bodyKind);
                    this.fillMediaTypes(code.get(), mediaType);
                    Content content = apiResponse.getContent();
                    if (content == null) continue;
                    MediaType oasMtype = (MediaType)content.get(mediaType);
                    if (!content.containsKey(mediaType)) {
                        return;
                    }
                    if (oasMtype.getSchema() == null || oasMtype.getSchema().get$ref() == null || bodyKind != TypeDescKind.TYPE_REFERENCE) continue;
                    Optional<String> schemaName = ValidatorUtils.extractReferenceType(oasMtype.getSchema().get$ref());
                    if (schemaName.isEmpty()) {
                        return;
                    }
                    TypeValidatorUtils.validateRecordType((Schema)oasSchemas.get(schemaName.get()), bodyFieldType, (String)((TypeReferenceTypeSymbol)bodyFieldType).definition().getName().get(), this.validatorContext.getContext(), this.validatorContext.getOpenAPI(), schemaName.get(), this.validatorContext.getSeverity());
                }
            }
            if (!isHttp && responses.containsKey("200")) {
                ApiResponse apiResponse = (ApiResponse)responses.get("200");
                Content content = apiResponse.getContent();
                MediaType oasMType = (MediaType)content.get("application/json");
                this.balStatusCodes.put("200", (Node)simpleRefNode);
                this.fillMediaTypes("200", "application/json");
                if (oasMType != null && oasMType.getSchema() != null && oasMType.getSchema().get$ref() != null) {
                    Optional<String> schemaName = ValidatorUtils.extractReferenceType(oasMType.getSchema().get$ref());
                    if (schemaName.isEmpty()) {
                        return;
                    }
                    TypeValidatorUtils.validateRecordType((Schema)oasSchemas.get(schemaName.get()), (TypeSymbol)typeSymbol, refType.definition().getName().orElse(null), this.validatorContext.getContext(), this.validatorContext.getOpenAPI(), schemaName.orElse(null), this.validatorContext.getSeverity());
                }
            }
        }
    }

    private void validateUnionType(UnionTypeDescriptorNode uNode, ApiResponses responses) {
        ArrayList<TypeDescriptorNode> unionNodes = new ArrayList<TypeDescriptorNode>();
        while (uNode != null) {
            unionNodes.add(uNode.rightTypeDesc());
            if (uNode.leftTypeDesc().kind() == SyntaxKind.UNION_TYPE_DESC) {
                uNode = (UnionTypeDescriptorNode)uNode.leftTypeDesc();
                continue;
            }
            unionNodes.add(uNode.leftTypeDesc());
            uNode = null;
        }
        for (Node node : unionNodes) {
            if (node.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
                QualifiedNameReferenceNode traversRNode = (QualifiedNameReferenceNode)node;
                this.validateQualifiedType(traversRNode);
                continue;
            }
            if (node.kind() == SyntaxKind.SIMPLE_NAME_REFERENCE) {
                SimpleNameReferenceNode simpleRefNode = (SimpleNameReferenceNode)node;
                this.validateSimpleNameReference(simpleRefNode, responses);
                continue;
            }
            if (node.kind() == SyntaxKind.ERROR_TYPE_DESC) {
                this.balStatusCodes.put("500", null);
                continue;
            }
            if (!(node instanceof BuiltinSimpleNameReferenceNode)) continue;
            this.balStatusCodes.put("200", node);
            if (!responses.containsKey("200")) continue;
            String mediaType = ValidatorUtils.getMediaType(node.kind());
            this.fillMediaTypes("200", mediaType);
        }
    }

    private void fillMediaTypes(String code, String mediaType) {
        List<String> mediaTypes = this.balMediaTypes.containsKey(code) ? this.balMediaTypes.get(code) : new ArrayList<String>();
        mediaTypes.add(mediaType);
        this.balMediaTypes.put(code, mediaTypes);
    }

    private void validateQualifiedType(QualifiedNameReferenceNode qNode) {
        Optional<String> statusCode = this.generateApiResponseCode(qNode.identifier().toString().trim());
        if (statusCode.isPresent()) {
            String balCode = statusCode.get();
            this.balStatusCodes.put(balCode, (Node)qNode);
        }
    }

    private Optional<String> generateApiResponseCode(String identifier) {
        if (Constants.HTTP_CODES.containsKey(identifier)) {
            return Optional.of(Constants.HTTP_CODES.get(identifier));
        }
        return Optional.empty();
    }

    @Override
    public void validateOpenAPIToBallerina() {
        Set<String> ballerinaCodes = this.balStatusCodes.keySet();
        Set oasKeys = this.responses.keySet();
        ArrayList missingCode = new ArrayList(oasKeys);
        missingCode.removeAll(ballerinaCodes);
        if (missingCode.size() > 0) {
            ValidatorUtils.reportDiagnostic(this.validatorContext, CompilationError.MISSING_STATUS_CODE, ((Object)missingCode).toString(), this.validatorContext.getMethod(), this.validatorContext.getPath());
        }
        this.responses.forEach((key, value) -> {
            if (!this.balStatusCodes.containsKey(key)) {
                return;
            }
            Content content = value.getContent();
            if (content == null) {
                return;
            }
            Set oasMediaTypes = content.keySet();
            List<String> ballerinaMediaTypes = this.balMediaTypes.get(key);
            ArrayList missingMediaTypes = new ArrayList(oasMediaTypes);
            if (ballerinaMediaTypes == null) {
                ValidatorUtils.reportDiagnostic(this.validatorContext, CompilationError.MISSING_RESPONSE_MEDIA_TYPE, oasMediaTypes.toString(), key, this.validatorContext.getMethod(), this.validatorContext.getPath());
                return;
            }
            missingMediaTypes.removeAll(ballerinaMediaTypes);
            if (missingMediaTypes.size() > 0) {
                ValidatorUtils.reportDiagnostic(this.validatorContext, CompilationError.MISSING_RESPONSE_MEDIA_TYPE, ((Object)missingMediaTypes).toString(), key, this.validatorContext.getMethod(), this.validatorContext.getPath());
            }
            content.forEach((mediaType, schema) -> {
                if (ballerinaMediaTypes.contains(mediaType)) {
                    SyntaxKind kind;
                    Node node = this.balStatusCodes.get(key);
                    if (node == null) {
                        return;
                    }
                    if (schema.getSchema() == null) {
                        return;
                    }
                    ObjectSchema objectSchema = null;
                    if (schema.getSchema().get$ref() != null) {
                        Optional<String> schemaName = ValidatorUtils.extractReferenceType(schema.getSchema().get$ref());
                        if (schemaName.isEmpty()) {
                            return;
                        }
                        Schema valueSchema = this.validatorContext.getOpenAPI().getComponents().getSchemas().get(schemaName.get());
                        if (valueSchema instanceof ObjectSchema) {
                            objectSchema = (ObjectSchema)valueSchema;
                        }
                    }
                    if (schema.getSchema() instanceof ObjectSchema) {
                        objectSchema = (ObjectSchema)schema.getSchema();
                    }
                    if ((kind = node.kind()) != SyntaxKind.QUALIFIED_NAME_REFERENCE && kind == SyntaxKind.SIMPLE_NAME_REFERENCE) {
                        SimpleNameReferenceNode simpleRefNode = (SimpleNameReferenceNode)node;
                        this.validateObjectSchema(objectSchema, simpleRefNode);
                    }
                }
            });
        });
    }

    private void validateObjectSchema(ObjectSchema objectSchema, SimpleNameReferenceNode simpleRefNode) {
        TypeReferenceTypeSymbol refType;
        TypeSymbol type;
        Optional symbol = this.validatorContext.getContext().semanticModel().symbol((Node)simpleRefNode);
        if (symbol.isEmpty()) {
            return;
        }
        if (symbol.get() instanceof TypeReferenceTypeSymbol && (type = (refType = (TypeReferenceTypeSymbol)symbol.get()).typeDescriptor()) instanceof RecordTypeSymbol) {
            RecordTypeSymbol typeSymbol = (RecordTypeSymbol)type;
            List typeInclusions = typeSymbol.typeInclusions();
            boolean isHttp = false;
            if (!typeInclusions.isEmpty()) {
                for (TypeSymbol typeInSymbol : typeInclusions) {
                    if (!"http".equals(((ModuleSymbol)typeInSymbol.getModule().orElseThrow()).getName().orElseThrow())) continue;
                    isHttp = true;
                    Map fields = typeSymbol.fieldDescriptors();
                    TypeSymbol bodyFieldType = ((RecordFieldSymbol)fields.get("body")).typeDescriptor();
                    if (!(bodyFieldType instanceof TypeReferenceTypeSymbol)) continue;
                    TypeValidatorUtils.validateObjectSchema(objectSchema, bodyFieldType, this.validatorContext.getContext(), ((TypeReferenceTypeSymbol)bodyFieldType).definition().getName().orElse("Anonymous Record"), this.validatorContext.getLocation(), this.validatorContext.getSeverity());
                }
                if (!isHttp) {
                    TypeValidatorUtils.validateObjectSchema(objectSchema, (TypeSymbol)typeSymbol, this.validatorContext.getContext(), ((TypeReferenceTypeSymbol)typeSymbol).definition().getName().orElse("Anonymous Record"), this.validatorContext.getLocation(), this.validatorContext.getSeverity());
                }
            } else {
                TypeValidatorUtils.validateObjectSchema(objectSchema, (TypeSymbol)typeSymbol, this.validatorContext.getContext(), refType.definition().getName().orElse("Anonymous Record"), this.validatorContext.getLocation(), this.validatorContext.getSeverity());
            }
        }
    }
}

