/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.validator;

import io.ballerina.openapi.validator.PreValidator;
import io.ballerina.openapi.validator.ServiceValidator;
import io.ballerina.openapi.validator.ValidatorUtils;
import io.ballerina.openapi.validator.error.CompilationError;
import io.ballerina.openapi.validator.model.Filter;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;

public class ServiceAnalysisTask
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    private final ServiceValidator serviceValidator;
    private final PreValidator preValidator = new PreValidator();

    public ServiceAnalysisTask() {
        this.serviceValidator = new ServiceValidator();
    }

    public void perform(SyntaxNodeAnalysisContext syntaxContext) {
        boolean excludeOperationEnable;
        this.preValidator.initialize(syntaxContext);
        this.preValidator.validate();
        if (this.preValidator.getOpenAPI() == null) {
            return;
        }
        Filter filter = this.preValidator.getFilter();
        boolean tagEnabled = filter.getTag() != null;
        boolean operationEnabled = filter.getOperation() != null;
        boolean excludeTagsEnabled = filter.getExcludeTag() != null;
        boolean bl = excludeOperationEnable = filter.getExcludeOperation() != null;
        if (tagEnabled && operationEnabled && excludeOperationEnable && excludeTagsEnabled) {
            ValidatorUtils.reportDiagnostic(syntaxContext, CompilationError.FOUR_ANNOTATION_FIELDS, (Location)syntaxContext.node().location(), DiagnosticSeverity.ERROR, new Object[0]);
            return;
        }
        if (tagEnabled && excludeTagsEnabled) {
            ValidatorUtils.reportDiagnostic(syntaxContext, CompilationError.BOTH_TAGS_AND_EXCLUDE_TAGS_ENABLES, (Location)syntaxContext.node().location(), DiagnosticSeverity.ERROR, new Object[0]);
            return;
        }
        if (operationEnabled && excludeOperationEnable) {
            ValidatorUtils.reportDiagnostic(syntaxContext, CompilationError.BOTH_OPERATIONS_AND_EXCLUDE_OPERATIONS_ENABLES, (Location)syntaxContext.node().location(), DiagnosticSeverity.ERROR, new Object[0]);
            return;
        }
        this.serviceValidator.initialize(syntaxContext, this.preValidator.getOpenAPI(), filter);
        this.serviceValidator.validate();
    }
}

