/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.validator.example;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ObjectTypeDescriptorNode;
import io.ballerina.openapi.validator.example.ParameterExampleAnalyzer;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import java.util.Optional;

public class ContractParamExampleAnalyzer
extends ParameterExampleAnalyzer {
    @Override
    public void perform(SyntaxNodeAnalysisContext context) {
        if (this.diagnosticContainsErrors(context)) {
            return;
        }
        Node node = context.node();
        SemanticModel semanticModel = context.semanticModel();
        Optional<ObjectTypeSymbol> serviceContractObjType = ContractParamExampleAnalyzer.getServiceContractObjType(semanticModel, node);
        if (serviceContractObjType.isEmpty()) {
            return;
        }
        serviceContractObjType.get().methods().values().forEach(method -> this.validateAnnotationOnResources(context, (MethodSymbol)method, false, semanticModel));
    }

    private static Optional<ObjectTypeSymbol> getServiceContractObjType(SemanticModel semanticModel, Node node) {
        Object t;
        Object t2;
        if (!(node instanceof ObjectTypeDescriptorNode)) {
            return Optional.empty();
        }
        ObjectTypeDescriptorNode objectTypeNode = (ObjectTypeDescriptorNode)node;
        Optional serviceObjSymbol = semanticModel.symbol((Node)objectTypeNode.parent());
        if (serviceObjSymbol.isEmpty() || !((t2 = serviceObjSymbol.get()) instanceof TypeDefinitionSymbol)) {
            return Optional.empty();
        }
        TypeDefinitionSymbol serviceObjTypeDef = (TypeDefinitionSymbol)t2;
        Optional serviceContractType = semanticModel.types().getTypeByName("ballerina", "http", "", "ServiceContract");
        if (serviceContractType.isEmpty() || !((t = serviceContractType.get()) instanceof TypeDefinitionSymbol)) {
            return Optional.empty();
        }
        TypeDefinitionSymbol serviceContractTypeDef = (TypeDefinitionSymbol)t;
        TypeSymbol serviceType = serviceObjTypeDef.typeDescriptor();
        if (serviceType.subtypeOf(serviceContractTypeDef.typeDescriptor()) && serviceType instanceof ObjectTypeSymbol) {
            ObjectTypeSymbol serviceObjType = (ObjectTypeSymbol)serviceType;
            return Optional.of(serviceObjType);
        }
        return Optional.empty();
    }
}

