/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.validator.example;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.AnnotationAttachmentSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ResourceMethodSymbol;
import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.resourcepath.PathRestParam;
import io.ballerina.compiler.api.symbols.resourcepath.PathSegmentList;
import io.ballerina.compiler.api.symbols.resourcepath.ResourcePath;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.openapi.validator.example.AbstractExampleAnalyzer;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import java.util.List;
import java.util.Optional;

public class ParameterExampleAnalyzer
extends AbstractExampleAnalyzer {
    public void perform(SyntaxNodeAnalysisContext context) {
        Object t;
        if (this.diagnosticContainsErrors(context)) {
            return;
        }
        Node node = context.node();
        SemanticModel semanticModel = context.semanticModel();
        Optional symbol = semanticModel.symbol(node);
        if (symbol.isEmpty() || !((t = symbol.get()) instanceof ServiceDeclarationSymbol)) {
            return;
        }
        ServiceDeclarationSymbol serviceDeclaration = (ServiceDeclarationSymbol)t;
        boolean fromServiceContract = ParameterExampleAnalyzer.fromServiceContract(semanticModel, serviceDeclaration);
        serviceDeclaration.methods().values().forEach(method -> this.validateAnnotationOnResources(context, (MethodSymbol)method, fromServiceContract, semanticModel));
    }

    protected void validateAnnotationOnResources(SyntaxNodeAnalysisContext context, MethodSymbol method, boolean fromServiceContract, SemanticModel semanticModel) {
        if (method instanceof ResourceMethodSymbol) {
            ResourceMethodSymbol resourceMethodSymbol = (ResourceMethodSymbol)method;
            if (fromServiceContract) {
                this.invalidatePathParamExample(context, resourceMethodSymbol, semanticModel);
                this.invalidateSignatureParamExample(context, resourceMethodSymbol, semanticModel);
            } else {
                this.validateSignatureParams(context, resourceMethodSymbol, semanticModel);
                this.validatePathParams(context, resourceMethodSymbol, semanticModel);
            }
        }
    }

    private void validatePathParams(SyntaxNodeAnalysisContext context, ResourceMethodSymbol resourceMethodSymbol, SemanticModel semanticModel) {
        ResourcePath path = resourceMethodSymbol.resourcePath();
        if (path instanceof PathRestParam) {
            PathRestParam pathRestParam2 = (PathRestParam)path;
            this.validateRestParameterAnnotations(context, pathRestParam2.parameter().annotAttachments(), semanticModel);
        } else if (path instanceof PathSegmentList) {
            PathSegmentList pathSegmentList = (PathSegmentList)path;
            pathSegmentList.pathParameters().forEach(pathParameter -> this.validateParameterAnnotations(context, pathParameter.typeDescriptor(), pathParameter.annotAttachments(), semanticModel));
            pathSegmentList.pathRestParameter().ifPresent(pathRestParam -> this.validateRestParameterAnnotations(context, pathRestParam.annotAttachments(), semanticModel));
        }
    }

    private void invalidatePathParamExample(SyntaxNodeAnalysisContext context, ResourceMethodSymbol methodSymbol, SemanticModel semanticModel) {
        ResourcePath path = methodSymbol.resourcePath();
        if (path instanceof PathRestParam) {
            PathRestParam pathRestParam2 = (PathRestParam)path;
            this.invalidateBothExampleAnnotations(context, semanticModel, pathRestParam2.parameter().annotAttachments());
        } else if (path instanceof PathSegmentList) {
            PathSegmentList pathSegmentList = (PathSegmentList)path;
            pathSegmentList.pathParameters().forEach(pathParameter -> this.invalidateBothExampleAnnotations(context, semanticModel, pathParameter.annotAttachments()));
            pathSegmentList.pathRestParameter().ifPresent(pathRestParam -> this.invalidateBothExampleAnnotations(context, semanticModel, pathRestParam.annotAttachments()));
        }
    }

    private void validateSignatureParams(SyntaxNodeAnalysisContext context, ResourceMethodSymbol resourceMethodSymbol, SemanticModel semanticModel) {
        Optional params = resourceMethodSymbol.typeDescriptor().params();
        params.ifPresent(parameterSymbols -> parameterSymbols.forEach(parameterSymbol -> this.validateParameterAnnotations(context, parameterSymbol.typeDescriptor(), parameterSymbol.annotAttachments(), semanticModel)));
    }

    private void invalidateSignatureParamExample(SyntaxNodeAnalysisContext context, ResourceMethodSymbol methodSymbol, SemanticModel semanticModel) {
        Optional params = methodSymbol.typeDescriptor().params();
        params.ifPresent(parameterSymbols -> parameterSymbols.forEach(parameterSymbol -> this.invalidateBothExampleAnnotations(context, semanticModel, parameterSymbol.annotAttachments())));
    }

    private void validateParameterAnnotations(SyntaxNodeAnalysisContext context, TypeSymbol typeSymbol, List<AnnotationAttachmentSymbol> annotations, SemanticModel semanticModel) {
        this.validateExampleAnnotationUsage(context, typeSymbol, annotations, semanticModel);
        this.validateExamplesAnnotationUsage(context, typeSymbol, annotations, semanticModel);
        this.validateBothExampleAnnotations(context, annotations, semanticModel);
    }

    public static boolean fromServiceContract(SemanticModel semanticModel, ServiceDeclarationSymbol service) {
        Object t;
        Object t2;
        Optional serviceTypeSymbol = service.typeDescriptor();
        if (serviceTypeSymbol.isEmpty() || !((t2 = serviceTypeSymbol.get()) instanceof TypeReferenceTypeSymbol)) {
            return false;
        }
        TypeReferenceTypeSymbol serviceTypeRef = (TypeReferenceTypeSymbol)t2;
        Optional serviceContractType = semanticModel.types().getTypeByName("ballerina", "http", "", "ServiceContract");
        if (serviceContractType.isEmpty() || !((t = serviceContractType.get()) instanceof TypeDefinitionSymbol)) {
            return false;
        }
        TypeDefinitionSymbol serviceContractTypeDef = (TypeDefinitionSymbol)t;
        return serviceTypeRef.subtypeOf(serviceContractTypeDef.typeDescriptor());
    }
}

