/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.floatingpoint;

import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.utils.ErrorUtils;
import io.ballerina.runtime.internal.utils.FloatUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;

public final class ToFixedString {
    private ToFixedString() {
    }

    public static BString toFixedString(double x, Object fractionDigits) {
        BString res = FloatUtils.getBStringIfInfiniteOrNaN((double)x);
        if (res != null) {
            return res;
        }
        if (fractionDigits == null) {
            return StringUtils.fromString((String)BigDecimal.valueOf(x).toPlainString());
        }
        long noOfFractionDigits = (Long)fractionDigits;
        if (noOfFractionDigits < 0L) {
            throw ErrorUtils.createInvalidFractionDigitsError();
        }
        if (FloatUtils.checkFractionDigitsWithinRange((long)noOfFractionDigits)) {
            return StringUtils.fromString((String)BigDecimal.valueOf(x).toPlainString());
        }
        int fracDigits = (int)noOfFractionDigits;
        BigDecimal numberBigDecimal = new BigDecimal(x);
        numberBigDecimal = numberBigDecimal.setScale(fracDigits, RoundingMode.HALF_EVEN);
        return StringUtils.fromString((String)numberBigDecimal.toPlainString());
    }
}

