/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.graphqlmodelgenerator.core;

import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.graphqlmodelgenerator.core.model.DefaultIntrospectionType;
import io.ballerina.graphqlmodelgenerator.core.model.EnumComponent;
import io.ballerina.graphqlmodelgenerator.core.model.EnumField;
import io.ballerina.graphqlmodelgenerator.core.model.HierarchicalResourceComponent;
import io.ballerina.graphqlmodelgenerator.core.model.Interaction;
import io.ballerina.graphqlmodelgenerator.core.model.InterfaceComponent;
import io.ballerina.graphqlmodelgenerator.core.model.Param;
import io.ballerina.graphqlmodelgenerator.core.model.RecordComponent;
import io.ballerina.graphqlmodelgenerator.core.model.RecordField;
import io.ballerina.graphqlmodelgenerator.core.model.ResourceFunction;
import io.ballerina.graphqlmodelgenerator.core.model.ServiceClassComponent;
import io.ballerina.graphqlmodelgenerator.core.model.ServiceClassField;
import io.ballerina.graphqlmodelgenerator.core.model.UnionComponent;
import io.ballerina.graphqlmodelgenerator.core.utils.ModelGenerationUtils;
import io.ballerina.stdlib.graphql.commons.types.ObjectKind;
import io.ballerina.stdlib.graphql.commons.types.Position;
import io.ballerina.stdlib.graphql.commons.types.Schema;
import io.ballerina.stdlib.graphql.commons.types.Type;
import io.ballerina.stdlib.graphql.commons.types.TypeKind;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InteractedComponentModelGenerator {
    private final Schema schemaObj;
    private final SyntaxTree syntaxTree;
    private final Map<String, RecordComponent> records;
    private final Map<String, ServiceClassComponent> serviceClasses;
    private final Map<String, EnumComponent> enums;
    private final Map<String, UnionComponent> unions;
    private final Map<String, InterfaceComponent> interfaces;
    private final Map<String, HierarchicalResourceComponent> hierarchicalResources;

    public InteractedComponentModelGenerator(Schema schema, SyntaxTree syntaxTree) {
        this.schemaObj = schema;
        this.syntaxTree = syntaxTree;
        this.records = new HashMap<String, RecordComponent>();
        this.serviceClasses = new HashMap<String, ServiceClassComponent>();
        this.enums = new HashMap<String, EnumComponent>();
        this.unions = new HashMap<String, UnionComponent>();
        this.interfaces = new HashMap<String, InterfaceComponent>();
        this.hierarchicalResources = new HashMap<String, HierarchicalResourceComponent>();
    }

    public Map<String, RecordComponent> getRecords() {
        return this.records;
    }

    public Map<String, ServiceClassComponent> getServiceClasses() {
        return this.serviceClasses;
    }

    public Map<String, EnumComponent> getEnums() {
        return this.enums;
    }

    public Map<String, UnionComponent> getUnions() {
        return this.unions;
    }

    public Map<String, InterfaceComponent> getInterfaces() {
        return this.interfaces;
    }

    public Map<String, HierarchicalResourceComponent> getHierarchicalResources() {
        return this.hierarchicalResources;
    }

    public void generate() {
        for (Map.Entry entry : this.schemaObj.getTypes().entrySet()) {
            if (((Type)entry.getValue()).getKind() != TypeKind.OBJECT && ((Type)entry.getValue()).getKind() != TypeKind.INPUT_OBJECT && ((Type)entry.getValue()).getKind() != TypeKind.ENUM && ((Type)entry.getValue()).getKind() != TypeKind.UNION && ((Type)entry.getValue()).getKind() != TypeKind.INTERFACE || DefaultIntrospectionType.isReservedType((String)entry.getKey())) continue;
            if (((Type)entry.getValue()).getObjectKind() == ObjectKind.RECORD || ((Type)entry.getValue()).getKind() == TypeKind.INPUT_OBJECT) {
                this.records.put(((Type)entry.getValue()).getName(), this.generateRecordComponent((Type)entry.getValue()));
                continue;
            }
            if (((Type)entry.getValue()).getKind() == TypeKind.OBJECT && ((Type)entry.getValue()).getObjectKind() == ObjectKind.CLASS) {
                this.serviceClasses.put(((Type)entry.getValue()).getName(), this.generateServiceClassComponent((Type)entry.getValue()));
                continue;
            }
            if (((Type)entry.getValue()).getKind() == TypeKind.ENUM) {
                this.enums.put(((Type)entry.getValue()).getName(), this.generateEnumComponent((Type)entry.getValue()));
                continue;
            }
            if (((Type)entry.getValue()).getKind() == TypeKind.UNION && !((Type)entry.getValue()).getName().isBlank()) {
                this.unions.put(((Type)entry.getValue()).getName(), this.generateUnionComponent((Type)entry.getValue()));
                continue;
            }
            if (((Type)entry.getValue()).getKind() == TypeKind.INTERFACE) {
                this.interfaces.put(((Type)entry.getValue()).getName(), this.generateInterfaceComponent((Type)entry.getValue()));
                continue;
            }
            if (((Type)entry.getValue()).getKind() != TypeKind.OBJECT) continue;
            this.hierarchicalResources.put(((Type)entry.getValue()).getName(), this.generateHierarchicalResourceComponent((Type)entry.getValue()));
        }
    }

    private HierarchicalResourceComponent generateHierarchicalResourceComponent(Type objType) {
        ArrayList<ResourceFunction> resourceFunctions = new ArrayList<ResourceFunction>();
        objType.getFields().forEach(field -> {
            String typeDesc = ModelGenerationUtils.getFormattedFieldType(field.getType());
            List<Interaction> interactionList = ModelGenerationUtils.getInteractionList(field);
            ArrayList<Param> params = new ArrayList<Param>();
            field.getArgs().forEach(inputValue -> {
                String inputObj;
                Param param = new Param(ModelGenerationUtils.createArgType(inputValue), inputValue.getName(), inputValue.getDescription(), inputValue.getDefaultValue());
                params.add(param);
                Type paramType = ModelGenerationUtils.getType(inputValue.getType());
                if (paramType.getKind().equals((Object)TypeKind.INPUT_OBJECT) && (inputObj = ModelGenerationUtils.getFieldType(paramType)) != null) {
                    interactionList.add(new Interaction(inputObj, ModelGenerationUtils.getPathOfFieldType(paramType)));
                }
            });
            Position position = ModelGenerationUtils.findNodeRange(field.getPosition(), this.syntaxTree);
            ResourceFunction resourceFunction = new ResourceFunction(field.getName(), false, typeDesc, position, field.getDescription(), field.isDeprecated(), field.getDeprecationReason(), params, interactionList);
            resourceFunctions.add(resourceFunction);
        });
        return new HierarchicalResourceComponent(objType.getName(), resourceFunctions);
    }

    private InterfaceComponent generateInterfaceComponent(Type objType) {
        ArrayList<Interaction> possibleTypes = new ArrayList<Interaction>();
        objType.getPossibleTypes().forEach(type -> possibleTypes.add(new Interaction(type.getName(), type.getPosition().getFilePath())));
        ArrayList<ResourceFunction> resourceFunctions = new ArrayList<ResourceFunction>();
        objType.getFields().forEach(field -> {
            String typeDesc = ModelGenerationUtils.getFormattedFieldType(field.getType());
            List<Interaction> interactionList = ModelGenerationUtils.getInteractionList(field);
            ArrayList<Param> params = new ArrayList<Param>();
            field.getArgs().forEach(inputValue -> {
                String inputObj;
                Param param = new Param(ModelGenerationUtils.createArgType(inputValue), inputValue.getName(), inputValue.getDescription(), inputValue.getDefaultValue());
                params.add(param);
                Type paramType = ModelGenerationUtils.getType(inputValue.getType());
                if (paramType.getKind().equals((Object)TypeKind.INPUT_OBJECT) && (inputObj = ModelGenerationUtils.getFieldType(paramType)) != null) {
                    interactionList.add(new Interaction(inputObj, ModelGenerationUtils.getPathOfFieldType(paramType)));
                }
            });
            ResourceFunction resourceFunction = new ResourceFunction(field.getName(), false, typeDesc, null, field.getDescription(), field.isDeprecated(), field.getDeprecationReason(), params, interactionList);
            resourceFunctions.add(resourceFunction);
        });
        return new InterfaceComponent(objType.getName(), objType.getPosition(), objType.getDescription(), possibleTypes, resourceFunctions);
    }

    private ServiceClassComponent generateServiceClassComponent(Type objType) {
        ArrayList<ServiceClassField> functions = new ArrayList<ServiceClassField>();
        objType.getFields().forEach(field -> {
            String typeDesc = ModelGenerationUtils.getFormattedFieldType(field.getType());
            List<Interaction> interactionList = ModelGenerationUtils.getInteractionList(field);
            ArrayList<Param> params = new ArrayList<Param>();
            field.getArgs().forEach(inputValue -> {
                String inputObj;
                Param param = new Param(ModelGenerationUtils.createArgType(inputValue), inputValue.getName(), inputValue.getDescription(), inputValue.getDefaultValue());
                params.add(param);
                Type paramType = ModelGenerationUtils.getType(inputValue.getType());
                if (paramType.getKind().equals((Object)TypeKind.INPUT_OBJECT) && (inputObj = ModelGenerationUtils.getFieldType(paramType)) != null) {
                    interactionList.add(new Interaction(inputObj, ModelGenerationUtils.getPathOfFieldType(paramType)));
                }
            });
            ServiceClassField classField = new ServiceClassField(field.getName(), typeDesc, field.getDescription(), field.isDeprecated(), field.getDeprecationReason(), params, interactionList);
            functions.add(classField);
        });
        return new ServiceClassComponent(objType.getName(), objType.getPosition(), objType.getDescription(), functions);
    }

    private RecordComponent generateRecordComponent(Type objType) {
        ArrayList<RecordField> recordFields = new ArrayList<RecordField>();
        if (objType.getKind() == TypeKind.OBJECT) {
            objType.getFields().forEach(field -> {
                String typeDesc = ModelGenerationUtils.getFormattedFieldType(field.getType());
                List<Interaction> interactionList = ModelGenerationUtils.getInteractionList(field);
                RecordField recordField = new RecordField(field.getName(), typeDesc, null, field.getDescription(), field.isDeprecated(), field.getDeprecationReason(), interactionList);
                recordFields.add(recordField);
            });
        }
        if (objType.getKind() == TypeKind.INPUT_OBJECT) {
            objType.getInputFields().forEach(field -> {
                String typeDesc = ModelGenerationUtils.getFormattedFieldType(field.getType());
                List<Interaction> interactionList = ModelGenerationUtils.getInteractionList(field);
                RecordField recordField = new RecordField(field.getName(), typeDesc, field.getDefaultValue(), field.getDescription(), false, null, interactionList);
                recordFields.add(recordField);
            });
        }
        return new RecordComponent(objType.getName(), objType.getPosition(), objType.getDescription(), recordFields, objType.getKind() == TypeKind.INPUT_OBJECT);
    }

    private EnumComponent generateEnumComponent(Type objType) {
        ArrayList<EnumField> enumFields = new ArrayList<EnumField>();
        objType.getEnumValues().forEach(enumValue -> enumFields.add(new EnumField(enumValue.getName(), enumValue.getDescription(), enumValue.isDeprecated(), enumValue.getDeprecationReason())));
        return new EnumComponent(objType.getName(), objType.getPosition(), objType.getDescription(), enumFields);
    }

    private UnionComponent generateUnionComponent(Type objType) {
        ArrayList<Interaction> possibleTypes = new ArrayList<Interaction>();
        objType.getPossibleTypes().forEach(type -> possibleTypes.add(new Interaction(type.getName(), type.getPosition().getFilePath())));
        return new UnionComponent(objType.getName(), objType.getPosition(), objType.getDescription(), possibleTypes);
    }
}

