/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.client;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.openapi.core.generators.client.FunctionReturnTypeGeneratorImp;
import io.ballerina.openapi.core.generators.client.FunctionSignatureGenerator;
import io.ballerina.openapi.core.generators.client.diagnostic.ClientDiagnostic;
import io.ballerina.openapi.core.generators.client.diagnostic.ClientDiagnosticImp;
import io.ballerina.openapi.core.generators.client.diagnostic.DiagnosticMessages;
import io.ballerina.openapi.core.generators.client.parameter.HeadersParameterGenerator;
import io.ballerina.openapi.core.generators.client.parameter.QueriesParameterGenerator;
import io.ballerina.openapi.core.generators.client.parameter.RequestBodyGenerator;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.exception.BallerinaOpenApiException;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractFunctionSignatureGenerator
implements FunctionSignatureGenerator {
    OpenAPI openAPI;
    Operation operation;
    List<ClientDiagnostic> diagnostics = new ArrayList<ClientDiagnostic>();
    FunctionReturnTypeGeneratorImp functionReturnTypeGenerator;
    private final String httpMethod;
    private final String path;
    private String headersParamName = "headers";
    private boolean hasDefaultHeader = false;
    private boolean hasHeadersParam = false;
    private boolean hasQueriesParam = false;

    protected AbstractFunctionSignatureGenerator(Operation operation, OpenAPI openAPI, String httpMethod, String path) {
        this.operation = operation;
        this.openAPI = openAPI;
        this.httpMethod = httpMethod;
        this.path = path;
        this.functionReturnTypeGenerator = new FunctionReturnTypeGeneratorImp(operation, openAPI, httpMethod);
    }

    @Override
    public Optional<FunctionSignatureNode> generateFunctionSignature() {
        List parameters = this.operation.getParameters();
        FunctionSignatureGenerator.ParametersInfo parametersInfo = this.getParametersInfo(parameters);
        if (Objects.isNull(parametersInfo)) {
            return Optional.empty();
        }
        List<Node> paramList = AbstractFunctionSignatureGenerator.getParameterNodes(parametersInfo);
        SeparatedNodeList parameterNodes = AbstractNodeFactory.createSeparatedNodeList(paramList);
        FunctionReturnTypeGeneratorImp functionReturnType = this.getFunctionReturnTypeGenerator();
        Optional<ReturnTypeDescriptorNode> returnType = functionReturnType.getReturnType();
        this.diagnostics.addAll(functionReturnType.getDiagnostics());
        return returnType.map(returnTypeDescriptorNode -> NodeFactory.createFunctionSignatureNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), (SeparatedNodeList)parameterNodes, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN), (ReturnTypeDescriptorNode)returnTypeDescriptorNode));
    }

    private static List<Node> getParameterNodes(FunctionSignatureGenerator.ParametersInfo parametersInfo) {
        List<Node> defaultableParams = parametersInfo.defaultableParams();
        List<Node> params = parametersInfo.requiredParams();
        List<Node> includedParam = parametersInfo.includedParam();
        if (!defaultableParams.isEmpty()) {
            params.addAll(defaultableParams);
        }
        if (!includedParam.isEmpty()) {
            params.addAll(includedParam);
        }
        if (!params.isEmpty()) {
            params.remove(params.size() - 1);
        }
        return params;
    }

    protected FunctionSignatureGenerator.ParametersInfo getParametersInfo(List<Parameter> parameters) {
        return this.getParametersInfo(parameters, new ArrayList<Node>());
    }

    protected FunctionSignatureGenerator.ParametersInfo getParametersInfo(List<Parameter> parameters, List<Node> requiredParams) {
        ArrayList<Node> defaultableParams = new ArrayList<Node>();
        ArrayList<Node> includedParam = new ArrayList<Node>();
        Token comma = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN);
        List<Parameter> headerParameters = new ArrayList<Parameter>();
        ArrayList<Parameter> queryParameters = new ArrayList<Parameter>();
        ArrayList<Parameter> pathParameters = new ArrayList<Parameter>();
        if (Objects.nonNull(this.operation.getRequestBody())) {
            RequestBodyGenerator requestBodyGenerator = new RequestBodyGenerator(this.operation.getRequestBody(), this.openAPI);
            Optional<ParameterNode> requestBody = requestBodyGenerator.generateParameterNode();
            if (requestBody.isEmpty()) {
                this.diagnostics.addAll(requestBodyGenerator.getDiagnostics());
                return null;
            }
            headerParameters = requestBodyGenerator.getHeaderSchemas();
            requiredParams.add((Node)requestBody.get());
            requiredParams.add((Node)comma);
        }
        if (Objects.nonNull(parameters)) {
            Optional<ParameterNode> headers;
            this.populateHeaderAndQueryParameters(parameters, queryParameters, headerParameters, pathParameters);
            ArrayList<Parameter> nonHeaderParameters = new ArrayList<Parameter>(queryParameters);
            nonHeaderParameters.addAll(pathParameters);
            HeadersParameterGenerator headersParameterGenerator = new HeadersParameterGenerator(headerParameters, this.openAPI, this.operation, this.httpMethod, this.path, nonHeaderParameters);
            if (headerParameters.isEmpty()) {
                this.hasDefaultHeader = true;
                headers = HeadersParameterGenerator.getDefaultParameterNode(nonHeaderParameters);
            } else {
                headers = headersParameterGenerator.generateParameterNode();
            }
            this.diagnostics.addAll(headersParameterGenerator.getDiagnostics());
            if (headersParameterGenerator.hasErrors()) {
                return null;
            }
            if (headers.isPresent()) {
                this.headersParamName = HeadersParameterGenerator.getHeadersParamName(headers.get());
                this.hasHeadersParam = true;
                ParameterNode parameterNode = headers.get();
                if (parameterNode instanceof RequiredParameterNode) {
                    RequiredParameterNode headerNode = (RequiredParameterNode)parameterNode;
                    requiredParams.add((Node)headerNode);
                    requiredParams.add((Node)comma);
                } else {
                    defaultableParams.add((Node)headers.get());
                    defaultableParams.add((Node)comma);
                }
            } else if (!headerParameters.isEmpty()) {
                return null;
            }
            QueriesParameterGenerator queriesParameterGenerator = new QueriesParameterGenerator(queryParameters, this.openAPI, this.operation, this.httpMethod, this.path);
            Optional<ParameterNode> queries = queriesParameterGenerator.generateParameterNode();
            this.diagnostics.addAll(queriesParameterGenerator.getDiagnostics());
            if (queriesParameterGenerator.hasErrors()) {
                return null;
            }
            if (queries.isPresent()) {
                this.hasQueriesParam = true;
                includedParam.add((Node)queries.get());
                includedParam.add((Node)comma);
            } else if (!queryParameters.isEmpty()) {
                return null;
            }
        } else {
            ParameterNode defaultHeaderParam = HeadersParameterGenerator.getDefaultParameterNode().orElse(null);
            if (Objects.nonNull(defaultHeaderParam)) {
                this.headersParamName = HeadersParameterGenerator.getHeadersParamName(defaultHeaderParam);
                this.hasDefaultHeader = true;
                this.hasHeadersParam = true;
                defaultableParams.add((Node)defaultHeaderParam);
                defaultableParams.add((Node)comma);
            }
        }
        return new FunctionSignatureGenerator.ParametersInfo(requiredParams, defaultableParams, includedParam);
    }

    private void populateHeaderAndQueryParameters(List<Parameter> parameters, List<Parameter> queryParameters, List<Parameter> headerParameters, List<Parameter> pathParameters) {
        for (Parameter parameter : parameters) {
            String in;
            if (Objects.nonNull(parameter.get$ref())) {
                String paramType = null;
                try {
                    paramType = GeneratorUtils.extractReferenceType(parameter.get$ref());
                }
                catch (BallerinaOpenApiException e) {
                    ClientDiagnosticImp clientDiagnostic = new ClientDiagnosticImp(DiagnosticMessages.OAS_CLIENT_100, parameter.get$ref());
                    this.diagnostics.add(clientDiagnostic);
                }
                parameter = (Parameter)this.openAPI.getComponents().getParameters().get(paramType);
            }
            switch (in = parameter.getIn()) {
                case "query": {
                    queryParameters.add(parameter);
                    break;
                }
                case "header": {
                    headerParameters.add(parameter);
                    break;
                }
                case "path": {
                    pathParameters.add(parameter);
                    break;
                }
            }
        }
    }

    protected FunctionReturnTypeGeneratorImp getFunctionReturnTypeGenerator() {
        return this.functionReturnTypeGenerator;
    }

    @Override
    public List<ClientDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    public boolean hasDefaultHeaders() {
        return this.hasDefaultHeader;
    }

    public boolean hasHeaders() {
        return this.hasHeadersParam;
    }

    public boolean hasQueries() {
        return this.hasQueriesParam;
    }

    @Override
    public boolean hasDefaultStatusCodeBinding() {
        return this.functionReturnTypeGenerator.hasDefaultStatusCodeBinding();
    }

    @Override
    public List<String> getNonDefaultStatusCodes() {
        return this.functionReturnTypeGenerator.getNonDefaultStatusCodes();
    }

    public String getHeadersParamName() {
        return this.headersParamName;
    }
}

