/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.client;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.BinaryExpressionNode;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionStatementNode;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.IfElseStatementNode;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ReturnStatementNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TemplateExpressionNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.openapi.core.generators.client.AuthConfigGeneratorImp;
import io.ballerina.openapi.core.generators.client.BallerinaUtilGenerator;
import io.ballerina.openapi.core.generators.client.FunctionBodyGenerator;
import io.ballerina.openapi.core.generators.client.MimeFactory;
import io.ballerina.openapi.core.generators.client.diagnostic.ClientDiagnostic;
import io.ballerina.openapi.core.generators.client.mime.MimeType;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.exception.BallerinaOpenApiException;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FunctionBodyGeneratorImp
implements FunctionBodyGenerator {
    public static final String MAP_ANYDATA = "map<anydata> ";
    public static final String MAP_STRING_STRING_ARRAY = "map<string|string[]> ";
    public static final String GET_MAP_FOR_HEADERS = " = http:getHeaderMap(";
    private final List<ImportDeclarationNode> imports;
    private final String path;
    protected final Map.Entry<PathItem.HttpMethod, Operation> operation;
    private final OpenAPI openAPI;
    private final BallerinaUtilGenerator ballerinaUtilGenerator;
    private final AuthConfigGeneratorImp ballerinaAuthConfigGeneratorImp;
    private String headersParamName;
    private final boolean hasHeaders;
    private final boolean hasQueries;
    private boolean hasDefaultHeaders;

    public List<ImportDeclarationNode> getImports() {
        return this.imports;
    }

    public FunctionBodyGeneratorImp(String path, Map.Entry<PathItem.HttpMethod, Operation> operation, OpenAPI openAPI, AuthConfigGeneratorImp ballerinaAuthConfigGeneratorImp, BallerinaUtilGenerator ballerinaUtilGenerator, List<ImportDeclarationNode> imports, boolean hasHeaders, boolean hasDefaultHeaders, boolean hasQueries, String headersParamName) {
        this.path = path;
        this.operation = operation;
        this.openAPI = openAPI;
        this.ballerinaUtilGenerator = ballerinaUtilGenerator;
        this.ballerinaAuthConfigGeneratorImp = ballerinaAuthConfigGeneratorImp;
        this.imports = imports;
        this.hasHeaders = hasHeaders;
        this.hasQueries = hasQueries;
        this.hasDefaultHeaders = hasDefaultHeaders;
        this.headersParamName = headersParamName;
    }

    @Override
    public Optional<FunctionBodyNode> getFunctionBodyNode() {
        NodeList annotationNodes = AbstractNodeFactory.createEmptyNodeList();
        ArrayList<StatementNode> statementsList = new ArrayList<StatementNode>();
        VariableDeclarationNode pathInt = this.getPathStatement(this.path, (NodeList<AnnotationNode>)annotationNodes);
        statementsList.add((StatementNode)pathInt);
        try {
            this.handleParameterSchemaInOperation(this.operation, statementsList);
            String method = this.operation.getKey().name().trim().toLowerCase(Locale.ENGLISH);
            if (this.operation.getValue().getRequestBody() != null) {
                RequestBody requestBody = this.operation.getValue().getRequestBody();
                this.handleRequestBodyInOperation(statementsList, method, requestBody);
            } else {
                this.createCommonFunctionBodyStatements(statementsList, method);
            }
            NodeList statements = AbstractNodeFactory.createNodeList(statementsList);
            return Optional.of(NodeFactory.createFunctionBodyBlockNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), null, (NodeList)statements, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN), null));
        }
        catch (BallerinaOpenApiException e) {
            return Optional.empty();
        }
    }

    private void handleParameterSchemaInOperation(Map.Entry<PathItem.HttpMethod, Operation> operation, List<StatementNode> statementsList) throws BallerinaOpenApiException {
        ArrayList<AuthConfigGeneratorImp.ApiKeyNamePair> queryApiKeyNameList = new ArrayList<AuthConfigGeneratorImp.ApiKeyNamePair>();
        ArrayList<AuthConfigGeneratorImp.ApiKeyNamePair> headerApiKeyNameList = new ArrayList<AuthConfigGeneratorImp.ApiKeyNamePair>();
        Set<String> securitySchemesAvailable = this.getSecurityRequirementForOperation(operation.getValue());
        if (!securitySchemesAvailable.isEmpty()) {
            Map<String, AuthConfigGeneratorImp.ApiKeyNamePair> queryApiKeyMap = this.ballerinaAuthConfigGeneratorImp.getQueryApiKeyNameMap();
            Map<String, AuthConfigGeneratorImp.ApiKeyNamePair> headerApiKeyMap = this.ballerinaAuthConfigGeneratorImp.getHeaderApiKeyNameMap();
            for (String schemaName : securitySchemesAvailable) {
                if (queryApiKeyMap.containsKey(schemaName)) {
                    queryApiKeyNameList.add(queryApiKeyMap.get(schemaName));
                    continue;
                }
                if (!headerApiKeyMap.containsKey(schemaName)) continue;
                headerApiKeyNameList.add(headerApiKeyMap.get(schemaName));
            }
        }
        ArrayList<Parameter> queryParameters = new ArrayList<Parameter>();
        if (operation.getValue().getParameters() != null) {
            List parameters = operation.getValue().getParameters();
            for (Parameter parameter : parameters) {
                if (parameter.get$ref() != null) {
                    String[] splits = parameter.get$ref().split("/");
                    parameter = (Parameter)this.openAPI.getComponents().getParameters().get(splits[splits.length - 1]);
                }
                if (!parameter.getIn().trim().equals("query")) continue;
                queryParameters.add(parameter);
            }
        }
        this.handleQueryParamsAndHeaders(queryParameters, statementsList, queryApiKeyNameList, headerApiKeyNameList);
    }

    public void handleQueryParamsAndHeaders(List<Parameter> queryParameters, List<StatementNode> statementsList, List<AuthConfigGeneratorImp.ApiKeyNamePair> queryApiKeyNameList, List<AuthConfigGeneratorImp.ApiKeyNamePair> headerApiKeyNameList) throws BallerinaOpenApiException {
        boolean combinationOfApiKeyAndHTTPOAuth;
        boolean bl = combinationOfApiKeyAndHTTPOAuth = this.ballerinaAuthConfigGeneratorImp.isHttpOROAuth() && this.ballerinaAuthConfigGeneratorImp.isApiKey();
        if (combinationOfApiKeyAndHTTPOAuth) {
            this.addUpdatedPathAndHeaders(statementsList, queryApiKeyNameList, queryParameters, headerApiKeyNameList);
        } else {
            Object defaultValue;
            if (this.hasQueries || !queryApiKeyNameList.isEmpty()) {
                if (!queryApiKeyNameList.isEmpty()) {
                    defaultValue = "{}";
                    if (this.hasQueries) {
                        defaultValue = "{...queries}";
                    }
                    ExpressionStatementNode queryMapCreation = GeneratorUtils.getSimpleExpressionStatementNode("map<anydata> queryParam = " + (String)defaultValue);
                    statementsList.add((StatementNode)queryMapCreation);
                    this.addApiKeysToMap("queryParam", queryApiKeyNameList, statementsList);
                }
                this.getUpdatedPathHandlingQueryParamEncoding(statementsList, queryParameters, queryApiKeyNameList.isEmpty() ? "queries" : "queryParam");
                this.ballerinaUtilGenerator.setQueryParamsFound(true);
            }
            if (this.hasHeaders || !headerApiKeyNameList.isEmpty()) {
                if (!headerApiKeyNameList.isEmpty()) {
                    defaultValue = "{}";
                    if (this.hasHeaders) {
                        defaultValue = "{..." + this.headersParamName + "}";
                    }
                    this.hasDefaultHeaders = false;
                    ExpressionStatementNode headerMapCreation = GeneratorUtils.getSimpleExpressionStatementNode("map<anydata> headerValues = " + (String)defaultValue);
                    statementsList.add((StatementNode)headerMapCreation);
                    this.addApiKeysToMap("headerValues", headerApiKeyNameList, statementsList);
                    statementsList.add((StatementNode)GeneratorUtils.getSimpleExpressionStatementNode("map<string|string[]> httpHeaders = http:getHeaderMap(headerValues)"));
                } else if (!this.hasDefaultHeaders) {
                    statementsList.add((StatementNode)GeneratorUtils.getSimpleExpressionStatementNode("map<string|string[]> httpHeaders = http:getHeaderMap(" + this.headersParamName + ")"));
                }
            }
        }
    }

    private void addUpdatedPathAndHeaders(List<StatementNode> statementsList, List<AuthConfigGeneratorImp.ApiKeyNamePair> queryApiKeyNameList, List<Parameter> queryParameters, List<AuthConfigGeneratorImp.ApiKeyNamePair> headerApiKeyNameList) throws BallerinaOpenApiException {
        Object defaultValue;
        ArrayList<StatementNode> ifBodyStatementsList = new ArrayList<StatementNode>();
        String headerVarName = "headerValues";
        if (this.hasHeaders || !headerApiKeyNameList.isEmpty()) {
            if (headerApiKeyNameList.isEmpty()) {
                if (!this.hasDefaultHeaders) {
                    headerVarName = this.headersParamName;
                }
            } else {
                this.hasDefaultHeaders = false;
                defaultValue = "{}";
                if (this.hasHeaders) {
                    defaultValue = "{..." + this.headersParamName + "}";
                }
                ExpressionStatementNode headerMapCreation = GeneratorUtils.getSimpleExpressionStatementNode("map<anydata> headerValues = " + (String)defaultValue);
                statementsList.add((StatementNode)headerMapCreation);
                this.addApiKeysToMap("headerValues", headerApiKeyNameList, ifBodyStatementsList);
            }
        }
        if (!queryApiKeyNameList.isEmpty()) {
            defaultValue = "{}";
            if (this.hasQueries) {
                defaultValue = "{...queries}";
            }
            ExpressionStatementNode queryParamMapCreation = GeneratorUtils.getSimpleExpressionStatementNode("map<anydata> queryParam = " + (String)defaultValue);
            statementsList.add((StatementNode)queryParamMapCreation);
            if (!queryApiKeyNameList.isEmpty()) {
                this.addApiKeysToMap("queryParam", queryApiKeyNameList, ifBodyStatementsList);
            }
        }
        this.generateIfBlockToAddApiKeysToMaps(statementsList, ifBodyStatementsList);
        if (this.hasQueries || !queryApiKeyNameList.isEmpty()) {
            this.getUpdatedPathHandlingQueryParamEncoding(statementsList, queryParameters, queryApiKeyNameList.isEmpty() ? "queries" : "queryParam");
            this.ballerinaUtilGenerator.setQueryParamsFound(true);
        }
        if (!(!this.hasHeaders && headerApiKeyNameList.isEmpty() || this.hasDefaultHeaders)) {
            statementsList.add((StatementNode)GeneratorUtils.getSimpleExpressionStatementNode("map<string|string[]> httpHeaders = http:getHeaderMap(" + headerVarName + ")"));
        }
    }

    private void addApiKeysToMap(String mapName, List<AuthConfigGeneratorImp.ApiKeyNamePair> apiKeyNames, List<StatementNode> statementNodeList) {
        if (!apiKeyNames.isEmpty()) {
            for (AuthConfigGeneratorImp.ApiKeyNamePair apiKeyNamePair : apiKeyNames) {
                IdentifierToken fieldName = AbstractNodeFactory.createIdentifierToken((String)(mapName + "[\"" + apiKeyNamePair.actualName().trim() + "\"]"));
                Token equal = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN);
                Object apiKeyConfigToken = "apiKeyConfig";
                if (this.ballerinaAuthConfigGeneratorImp.isHttpOROAuth() && this.ballerinaAuthConfigGeneratorImp.isApiKey()) {
                    apiKeyConfigToken = (String)apiKeyConfigToken + SyntaxKind.QUESTION_MARK_TOKEN.stringValue();
                }
                FieldAccessExpressionNode fieldExpr = NodeFactory.createFieldAccessExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"self")), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.DOT_TOKEN), (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)apiKeyConfigToken)));
                SimpleNameReferenceNode valueExpr = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)GeneratorUtils.escapeIdentifier(apiKeyNamePair.displayName())));
                FieldAccessExpressionNode apiKeyExpr = NodeFactory.createFieldAccessExpressionNode((ExpressionNode)fieldExpr, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.DOT_TOKEN), (NameReferenceNode)valueExpr);
                statementNodeList.add((StatementNode)NodeFactory.createAssignmentStatementNode((Node)fieldName, (Token)equal, (ExpressionNode)apiKeyExpr, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN)));
            }
        }
    }

    private void getUpdatedPathHandlingQueryParamEncoding(List<StatementNode> statementsList, List<Parameter> queryParameters, String queryVarName) throws BallerinaOpenApiException {
        VariableDeclarationNode queryParamEncodingMap = this.getQueryParameterEncodingMap(queryParameters);
        if (queryParamEncodingMap != null) {
            statementsList.add((StatementNode)queryParamEncodingMap);
            ExpressionStatementNode updatedPath = GeneratorUtils.getSimpleExpressionStatementNode("resourcePath = resourcePath + check getPathForQueryParam(" + queryVarName + ", queryParamEncoding)");
            statementsList.add((StatementNode)updatedPath);
        } else {
            ExpressionStatementNode updatedPath = GeneratorUtils.getSimpleExpressionStatementNode("resourcePath = resourcePath + check getPathForQueryParam(" + queryVarName + ")");
            statementsList.add((StatementNode)updatedPath);
        }
    }

    private void generateIfBlockToAddApiKeysToMaps(List<StatementNode> statementsList, List<StatementNode> ifBodyStatementsList) {
        if (!ifBodyStatementsList.isEmpty()) {
            NodeList ifBodyStatementsNodeList = AbstractNodeFactory.createNodeList(ifBodyStatementsList);
            BlockStatementNode ifBody = NodeFactory.createBlockStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (NodeList)ifBodyStatementsNodeList, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
            BinaryExpressionNode condition = NodeFactory.createBinaryExpressionNode(null, (Node)AbstractNodeFactory.createIdentifierToken((String)("self" + SyntaxKind.DOT_TOKEN.stringValue() + "apiKeyConfig")), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.IS_KEYWORD), (Node)AbstractNodeFactory.createIdentifierToken((String)"ApiKeysConfig"));
            IfElseStatementNode ifBlock = NodeFactory.createIfElseStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.IF_KEYWORD), (ExpressionNode)condition, (BlockStatementNode)ifBody, null);
            statementsList.add((StatementNode)ifBlock);
        }
    }

    private VariableDeclarationNode getQueryParameterEncodingMap(List<Parameter> queryParameters) throws BallerinaOpenApiException {
        ArrayList<Node> filedOfMap = new ArrayList<Node>();
        BuiltinSimpleNameReferenceNode mapType = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)"map<Encoding>"));
        CaptureBindingPatternNode bindingPattern = NodeFactory.createCaptureBindingPatternNode((Token)AbstractNodeFactory.createIdentifierToken((String)"queryParamEncoding"));
        TypedBindingPatternNode bindingPatternNode = NodeFactory.createTypedBindingPatternNode((TypeDescriptorNode)mapType, (BindingPatternNode)bindingPattern);
        for (Parameter parameter : queryParameters) {
            Schema paramSchema = parameter.getSchema();
            if (paramSchema != null && paramSchema.get$ref() != null) {
                paramSchema = (Schema)this.openAPI.getComponents().getSchemas().get(GeneratorUtils.escapeIdentifier(GeneratorUtils.extractReferenceType(paramSchema.get$ref())));
            }
            if (paramSchema == null || paramSchema.getProperties() == null && (GeneratorUtils.getOpenAPIType(paramSchema) == null || !GeneratorUtils.getOpenAPIType(paramSchema).equals("array")) && !GeneratorUtils.isComposedSchema(paramSchema) || parameter.getStyle() == null && parameter.getExplode() == null) continue;
            GeneratorUtils.createEncodingMap(filedOfMap, parameter.getStyle().toString(), parameter.getExplode(), parameter.getName().trim());
        }
        if (!filedOfMap.isEmpty()) {
            filedOfMap.remove(filedOfMap.size() - 1);
            MappingConstructorExpressionNode initialize = NodeFactory.createMappingConstructorExpressionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList(filedOfMap), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
            return NodeFactory.createVariableDeclarationNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), null, (TypedBindingPatternNode)bindingPatternNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)initialize, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        }
        return null;
    }

    private Set<String> getSecurityRequirementForOperation(Operation operation) {
        LinkedHashSet<String> securitySchemasAvailable = new LinkedHashSet<String>();
        List securityRequirements = new ArrayList();
        if (operation.getSecurity() != null) {
            securityRequirements = operation.getSecurity();
        } else if (this.openAPI.getSecurity() != null) {
            securityRequirements = this.openAPI.getSecurity();
        }
        if (!securityRequirements.isEmpty()) {
            for (SecurityRequirement requirement : securityRequirements) {
                securitySchemasAvailable.addAll(requirement.keySet());
            }
        }
        return securitySchemasAvailable;
    }

    private void handleRequestBodyInOperation(List<StatementNode> statementsList, String method, RequestBody requestBody) throws BallerinaOpenApiException {
        RequestBody requestBodySchema;
        Content rbContent;
        Set entries;
        Iterator<Map.Entry<String, MediaType>> iterator;
        if (requestBody.getContent() != null) {
            Content rbContent2 = requestBody.getContent();
            Set entries2 = rbContent2.entrySet();
            Iterator<Map.Entry<String, MediaType>> iterator2 = entries2.iterator();
            if (iterator2.hasNext()) {
                this.createRequestBodyStatements(statementsList, method, iterator2);
            }
        } else if (requestBody.get$ref() != null && (iterator = (entries = (rbContent = (requestBodySchema = (RequestBody)this.openAPI.getComponents().getRequestBodies().get(GeneratorUtils.extractReferenceType(requestBody.get$ref()))).getContent()).entrySet()).iterator()).hasNext()) {
            this.createRequestBodyStatements(statementsList, method, iterator);
        }
    }

    private void createCommonFunctionBodyStatements(List<StatementNode> statementsList, String method) {
        String clientCallStatement;
        boolean isEntityBodyMethods;
        boolean bl = isEntityBodyMethods = method.equals("post") || method.equals("put") || method.equals("patch") || method.equals("execute");
        if (this.hasHeaders) {
            String paramName;
            String string = paramName = this.hasDefaultHeaders ? this.headersParamName : "httpHeaders";
            if (isEntityBodyMethods) {
                ExpressionStatementNode requestStatementNode = GeneratorUtils.getSimpleExpressionStatementNode("http:Request request = new");
                statementsList.add((StatementNode)requestStatementNode);
                clientCallStatement = this.getClientCallWithRequestAndHeaders().formatted(method, "resourcePath", paramName);
            } else {
                clientCallStatement = method.equals("delete") ? this.getClientCallWithHeadersParam().formatted(method, "resourcePath", paramName) : this.getClientCallWithHeaders().formatted(method, "resourcePath", paramName);
            }
        } else if (method.equals("delete")) {
            clientCallStatement = this.getSimpleClientCall().formatted(method, "resourcePath");
        } else if (isEntityBodyMethods) {
            ExpressionStatementNode requestStatementNode = GeneratorUtils.getSimpleExpressionStatementNode("http:Request request = new");
            statementsList.add((StatementNode)requestStatementNode);
            clientCallStatement = this.getClientCallWithRequest().formatted(method, "resourcePath");
        } else {
            clientCallStatement = this.getSimpleClientCall().formatted(method, "resourcePath");
        }
        this.generateReturnStatement(statementsList, clientCallStatement);
    }

    protected String getClientCallWithHeadersParam() {
        return "self.clientEp->%s(%s, headers = %s)";
    }

    protected String getClientCallWithRequestAndHeaders() {
        return "self.clientEp->%s(%s, request, %s)";
    }

    protected String getClientCallWithHeaders() {
        return "self.clientEp->%s(%s, %s)";
    }

    protected String getClientCallWithRequest() {
        return "self.clientEp->%s(%s, request)";
    }

    protected String getSimpleClientCall() {
        return "self.clientEp->%s(%s)";
    }

    private VariableDeclarationNode getPathStatement(String path, NodeList<AnnotationNode> annotationNodes) {
        TypedBindingPatternNode typedBindingPatternNode = NodeFactory.createTypedBindingPatternNode((TypeDescriptorNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.STRING_KEYWORD)), (BindingPatternNode)NodeFactory.createCaptureBindingPatternNode((Token)AbstractNodeFactory.createIdentifierToken((String)"resourcePath")));
        path = this.generatePathWithPathParameter(path);
        NodeList content = AbstractNodeFactory.createNodeList((Node[])new Node[]{AbstractNodeFactory.createLiteralValueToken(null, (String)path, (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList(), (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList())});
        TemplateExpressionNode initializer = NodeFactory.createTemplateExpressionNode(null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.STRING_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.BACKTICK_TOKEN), (NodeList)content, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.BACKTICK_TOKEN));
        return NodeFactory.createVariableDeclarationNode(annotationNodes, null, (TypedBindingPatternNode)typedBindingPatternNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)initializer, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    public String generatePathWithPathParameter(String path) {
        if (path.contains("{")) {
            String refinedPath = path;
            Pattern p = Pattern.compile("\\{[^}]*}");
            Matcher m = p.matcher(path);
            while (m.find()) {
                String pathVariable = path.substring(m.start(), m.end());
                if (!pathVariable.startsWith("{") || !pathVariable.endsWith("}")) continue;
                String d = pathVariable.replace("{", "").replace("}", "");
                String replaceVariable = "{getEncodedUri(" + GeneratorUtils.escapeIdentifier(d) + ")}";
                refinedPath = refinedPath.replace(pathVariable, replaceVariable);
            }
            path = refinedPath.replaceAll("[{]", "\\${");
        }
        this.ballerinaUtilGenerator.setPathParametersFound(true);
        return path;
    }

    private void createRequestBodyStatements(List<StatementNode> statementsList, String method, Iterator<Map.Entry<String, MediaType>> iterator) throws BallerinaOpenApiException {
        Map.Entry<String, MediaType> mediaTypeEntry = iterator.next();
        if (GeneratorUtils.isSupportedMediaType(mediaTypeEntry)) {
            VariableDeclarationNode requestVariable = GeneratorUtils.getSimpleStatement("http:Request", "request", "new");
            statementsList.add((StatementNode)requestVariable);
        }
        if (mediaTypeEntry.getValue() != null && GeneratorUtils.isSupportedMediaType(mediaTypeEntry)) {
            this.genStatementsForRequestMediaType(statementsList, mediaTypeEntry);
        } else {
            ExpressionStatementNode expressionStatementNode = GeneratorUtils.getSimpleExpressionStatementNode("// TODO: Update the request as needed");
            statementsList.add((StatementNode)expressionStatementNode);
        }
        String requestStatement = this.getClientCallWithRequest().formatted(method, "resourcePath");
        if (this.hasHeaders) {
            if (method.equals("post") || method.equals("put") || method.equals("patch") || method.equals("delete") || method.equals("execute")) {
                requestStatement = this.getClientCallWithRequestAndHeaders().formatted(method, "resourcePath", this.hasDefaultHeaders ? this.headersParamName : "httpHeaders");
                this.generateReturnStatement(statementsList, requestStatement);
            }
        } else {
            this.generateReturnStatement(statementsList, requestStatement);
        }
    }

    protected void generateReturnStatement(List<StatementNode> statementsList, String returnStatement) {
        IdentifierToken returnKeyWord = AbstractNodeFactory.createIdentifierToken((String)"return");
        SimpleNameReferenceNode returns = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)returnStatement));
        ReturnStatementNode returnStatementNode = NodeFactory.createReturnStatementNode((Token)returnKeyWord, (ExpressionNode)returns, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        statementsList.add((StatementNode)returnStatementNode);
    }

    private void genStatementsForRequestMediaType(List<StatementNode> statementsList, Map.Entry<String, MediaType> mediaTypeEntry) throws BallerinaOpenApiException {
        MimeFactory factory = new MimeFactory();
        MimeType mimeType = factory.getMimeType(mediaTypeEntry, this.ballerinaUtilGenerator, this.imports);
        mimeType.setPayload(statementsList, mediaTypeEntry);
    }

    @Override
    public List<ClientDiagnostic> getDiagnostics() {
        return new ArrayList<ClientDiagnostic>();
    }
}

