/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.client;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.openapi.core.generators.client.FunctionReturnTypeGenerator;
import io.ballerina.openapi.core.generators.client.diagnostic.ClientDiagnostic;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.TypeHandler;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class FunctionReturnTypeGeneratorImp
implements FunctionReturnTypeGenerator {
    protected OpenAPI openAPI;
    protected Operation operation;
    protected String httpMethod;
    List<ClientDiagnostic> diagnostics = new ArrayList<ClientDiagnostic>();
    private ReturnTypesInfo returnTypesInfo;

    public FunctionReturnTypeGeneratorImp(Operation operation, OpenAPI openAPI, String httpMethod) {
        this.openAPI = openAPI;
        this.operation = operation;
        this.httpMethod = httpMethod;
    }

    @Override
    public Optional<ReturnTypeDescriptorNode> getReturnType() {
        ReturnTypesInfo returnTypesInfo = this.getReturnTypeInfo();
        List<TypeDescriptorNode> returnTypes = returnTypesInfo.types();
        boolean noContentResponseFound = returnTypesInfo.noContentResponseFound();
        if (!returnTypes.isEmpty()) {
            if (noContentResponseFound) {
                returnTypesInfo.types().add((TypeDescriptorNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"error?")));
            } else {
                returnTypesInfo.types().add((TypeDescriptorNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"error")));
            }
            return Optional.of(NodeFactory.createReturnTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RETURNS_KEYWORD), (NodeList)AbstractNodeFactory.createEmptyNodeList(), (Node)FunctionReturnTypeGeneratorImp.createUnionReturnType(returnTypes)));
        }
        if (noContentResponseFound) {
            return Optional.of(NodeFactory.createReturnTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RETURNS_KEYWORD), (NodeList)AbstractNodeFactory.createEmptyNodeList(), (Node)AbstractNodeFactory.createIdentifierToken((String)"error?")));
        }
        return Optional.of(NodeFactory.createReturnTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RETURNS_KEYWORD), (NodeList)AbstractNodeFactory.createEmptyNodeList(), (Node)AbstractNodeFactory.createIdentifierToken((String)"http:Response|error")));
    }

    public ReturnTypesInfo getReturnTypeInfo() {
        ArrayList<TypeDescriptorNode> returnTypes = new ArrayList<TypeDescriptorNode>();
        HashSet<String> returnTypesSet = new HashSet<String>();
        boolean noContentResponseFound = false;
        if (this.operation.getResponses() != null) {
            ApiResponses responses = this.operation.getResponses();
            for (Map.Entry entry : responses.entrySet()) {
                String statusCode = (String)entry.getKey();
                ApiResponse response = (ApiResponse)entry.getValue();
                noContentResponseFound = noContentResponseFound || this.populateReturnType(statusCode, response, returnTypes, returnTypesSet);
            }
        }
        this.returnTypesInfo = new ReturnTypesInfo(returnTypes, noContentResponseFound);
        return this.returnTypesInfo;
    }

    public ReturnTypesInfo getAlreadyDefinedReturnTypeInfo() {
        return this.returnTypesInfo;
    }

    protected boolean populateReturnType(String statusCode, ApiResponse response, List<TypeDescriptorNode> returnTypes, HashSet<String> returnTypesSet) {
        boolean noContentResponseFound = false;
        if (statusCode.startsWith("2")) {
            Content content = response.getContent();
            if (content != null && !content.isEmpty()) {
                Set mediaTypes = content.entrySet();
                SimpleNameReferenceNode type = null;
                for (Map.Entry media : mediaTypes) {
                    if (((MediaType)media.getValue()).getSchema() != null) {
                        Schema schema = ((MediaType)media.getValue()).getSchema();
                        Optional<TypeDescriptorNode> dataType = this.getDataType(media, schema);
                        if (dataType.isPresent()) {
                            type = dataType.get();
                        } else {
                            String mediaType = GeneratorUtils.getBallerinaMediaType(((String)media.getKey()).trim(), false);
                            type = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)mediaType));
                        }
                    } else {
                        String mediaType = GeneratorUtils.getBallerinaMediaType(((String)media.getKey()).trim(), false);
                        type = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)mediaType));
                    }
                    if (type.toString().equals("http:Response")) continue;
                    break;
                }
                if (!returnTypesSet.contains(type.toString())) {
                    returnTypesSet.add(type.toString());
                    returnTypes.add((TypeDescriptorNode)type);
                }
            } else {
                noContentResponseFound = true;
            }
        }
        if ((statusCode.startsWith("1") || statusCode.startsWith("2") || statusCode.startsWith("3")) && response.getContent() == null) {
            noContentResponseFound = true;
        }
        return noContentResponseFound;
    }

    public static TypeDescriptorNode createUnionReturnType(List<TypeDescriptorNode> types) {
        if (types.size() == 1) {
            return types.get(0);
        }
        TypeDescriptorNode unionType = types.get(0);
        for (int i = 1; i < types.size(); ++i) {
            unionType = NodeFactory.createUnionTypeDescriptorNode((TypeDescriptorNode)unionType, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PIPE_TOKEN), (TypeDescriptorNode)types.get(i));
        }
        return unionType;
    }

    private Optional<TypeDescriptorNode> getDataType(Map.Entry<String, MediaType> media, Schema<?> schema) {
        String mediaType = media.getKey().trim();
        String[] contentTypes = mediaType.split(";");
        if (mediaType.length() > 1) {
            mediaType = contentTypes[0];
        }
        if ((mediaType.matches(".*/json") || mediaType.matches("application/.*\\+json")) && schema != null) {
            return TypeHandler.getInstance().getTypeNodeFromOASSchema(schema);
        }
        String type = GeneratorUtils.getBallerinaMediaType(media.getKey().trim(), false);
        return Optional.of(NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)type)));
    }

    @Override
    public List<ClientDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    @Override
    public boolean hasDefaultStatusCodeBinding() {
        return false;
    }

    @Override
    public List<String> getNonDefaultStatusCodes() {
        return new ArrayList<String>();
    }

    public record ReturnTypesInfo(List<TypeDescriptorNode> types, boolean noContentResponseFound) {
    }
}

