/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.client;

import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.openapi.core.generators.client.BallerinaUtilGenerator;
import io.ballerina.openapi.core.generators.client.mime.CustomType;
import io.ballerina.openapi.core.generators.client.mime.JsonType;
import io.ballerina.openapi.core.generators.client.mime.MimeType;
import io.ballerina.openapi.core.generators.client.mime.MultipartFormData;
import io.ballerina.openapi.core.generators.client.mime.OctetStreamType;
import io.ballerina.openapi.core.generators.client.mime.UrlEncodedType;
import io.ballerina.openapi.core.generators.client.mime.XmlType;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.exception.BallerinaOpenApiException;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import java.util.List;
import java.util.Map;

public class MimeFactory {
    public MimeType getMimeType(Map.Entry<String, MediaType> mediaTypeEntry, BallerinaUtilGenerator ballerinaUtilGenerator, List<ImportDeclarationNode> imports) throws BallerinaOpenApiException {
        Schema requestBodySchema = mediaTypeEntry.getValue().getSchema();
        if (requestBodySchema != null && (requestBodySchema.get$ref() != null || GeneratorUtils.getOpenAPIType(requestBodySchema) != null || requestBodySchema.getProperties() != null)) {
            String mediaType = mediaTypeEntry.getKey();
            if (mediaType.matches(".*/json") || mediaType.matches("application/.*\\+json")) {
                return new JsonType(imports);
            }
            if (mediaType.startsWith("text/") || mediaType.contains("pdf") || mediaType.startsWith("image")) {
                return new CustomType();
            }
            if (mediaType.matches(".*/xml") || mediaType.matches("application/.*\\+xml")) {
                return new XmlType(imports);
            }
            if (mediaType.equals("application/x-www-form-urlencoded")) {
                return new UrlEncodedType(ballerinaUtilGenerator, imports);
            }
            if (mediaType.equals("application/octet-stream") || mediaType.matches("application/.*\\+octet-stream")) {
                return new OctetStreamType();
            }
            if (mediaType.equals("multipart/form-data")) {
                return new MultipartFormData(imports, ballerinaUtilGenerator);
            }
            if (mediaType.contains("vnd.")) {
                return new CustomType();
            }
            throw new BallerinaOpenApiException(String.format("Unsupported media type '%s' is given in the request body", mediaType));
        }
        return new CustomType();
    }
}

