/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.client;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.openapi.core.generators.client.AbstractFunctionSignatureGenerator;
import io.ballerina.openapi.core.generators.client.FunctionSignatureGenerator;
import io.ballerina.openapi.core.generators.client.parameter.PathParameterGenerator;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class RemoteFunctionSignatureGenerator
extends AbstractFunctionSignatureGenerator {
    public RemoteFunctionSignatureGenerator(Operation operation, OpenAPI openAPI, String httpMethod, String path) {
        super(operation, openAPI, httpMethod, path);
    }

    @Override
    protected FunctionSignatureGenerator.ParametersInfo getParametersInfo(List<Parameter> parameters) {
        if (Objects.isNull(parameters)) {
            return super.getParametersInfo(null);
        }
        ArrayList<Node> requiredParams = new ArrayList<Node>();
        for (Parameter parameter : parameters) {
            if (!parameter.getIn().equals("path")) continue;
            PathParameterGenerator paramGenerator = new PathParameterGenerator(parameter, this.openAPI);
            Optional<ParameterNode> param = paramGenerator.generateParameterNode();
            if (param.isEmpty()) {
                this.diagnostics.addAll(paramGenerator.getDiagnostics());
                return null;
            }
            requiredParams.add((Node)param.get());
            requiredParams.add((Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
        }
        return super.getParametersInfo(parameters, requiredParams);
    }
}

