/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.client;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.openapi.core.generators.client.AuthConfigGeneratorImp;
import io.ballerina.openapi.core.generators.client.BallerinaUtilGenerator;
import io.ballerina.openapi.core.generators.client.ResourceExternalFunctionSignatureGenerator;
import io.ballerina.openapi.core.generators.client.ResourceFunctionGenerator;
import io.ballerina.openapi.core.generators.client.diagnostic.ClientDiagnostic;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ResourceExternalFunctionGenerator
extends ResourceFunctionGenerator {
    ResourceExternalFunctionGenerator(Map.Entry<PathItem.HttpMethod, Operation> operation, String path, OpenAPI openAPI, AuthConfigGeneratorImp authConfigGeneratorImp, BallerinaUtilGenerator ballerinaUtilGenerator, List<ImportDeclarationNode> imports) {
        super(operation, path, openAPI, authConfigGeneratorImp, ballerinaUtilGenerator, imports);
        this.signatureGenerator = new ResourceExternalFunctionSignatureGenerator(operation.getValue(), openAPI, operation.getKey().toString().toLowerCase(Locale.ROOT), path, ballerinaUtilGenerator);
    }

    @Override
    protected Optional<FunctionDefinitionNode> getFunctionDefinitionNode(NodeList<Token> qualifierList, Token functionKeyWord, IdentifierToken functionName, NodeList<Node> relativeResourcePath, FunctionSignatureNode signatureNode, FunctionBodyNode functionBodyNode) {
        BasicLiteralNode implFuncName = NodeFactory.createBasicLiteralNode((SyntaxKind)SyntaxKind.STRING_LITERAL, (Token)AbstractNodeFactory.createLiteralValueToken((SyntaxKind)SyntaxKind.STRING_LITERAL_TOKEN, (String)("\"" + ((Operation)this.operation.getValue()).getOperationId() + "Impl\""), (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList(), (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList()));
        SpecificFieldNode implFuncNameField = NodeFactory.createSpecificFieldNode(null, (Node)AbstractNodeFactory.createIdentifierToken((String)"name"), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (ExpressionNode)implFuncName);
        MappingConstructorExpressionNode implFunctionMap = NodeFactory.createMappingConstructorExpressionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[]{implFuncNameField}), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
        SimpleNameReferenceNode annotationRef = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"MethodImpl"));
        AnnotationNode implAnnotation = NodeFactory.createAnnotationNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.AT_TOKEN), (Node)annotationRef, (MappingConstructorExpressionNode)implFunctionMap);
        MetadataNode metadataNode = NodeFactory.createMetadataNode(null, (NodeList)AbstractNodeFactory.createNodeList((Node[])new AnnotationNode[]{implAnnotation}));
        return Optional.of(NodeFactory.createFunctionDefinitionNode((SyntaxKind)SyntaxKind.RESOURCE_ACCESSOR_DEFINITION, (MetadataNode)metadataNode, qualifierList, (Token)functionKeyWord, (IdentifierToken)functionName, relativeResourcePath, (FunctionSignatureNode)signatureNode, (FunctionBodyNode)functionBodyNode));
    }

    @Override
    protected Optional<FunctionBodyNode> getFunctionBodyNode(List<ClientDiagnostic> diagnostics, boolean hasHeaders, boolean hasDefaultHeaders, boolean hasQueries, String headersParamName) {
        QualifiedNameReferenceNode javaMethodToken = NodeFactory.createQualifiedNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"java"), (Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (IdentifierToken)AbstractNodeFactory.createIdentifierToken((String)"Method"));
        BasicLiteralNode classValueExp = NodeFactory.createBasicLiteralNode((SyntaxKind)SyntaxKind.STRING_LITERAL, (Token)AbstractNodeFactory.createLiteralValueToken((SyntaxKind)SyntaxKind.STRING_LITERAL_TOKEN, (String)"\"io.ballerina.openapi.client.GeneratedClient\"", (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList(), (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList()));
        BasicLiteralNode methodValueExp = NodeFactory.createBasicLiteralNode((SyntaxKind)SyntaxKind.STRING_LITERAL, (Token)AbstractNodeFactory.createLiteralValueToken((SyntaxKind)SyntaxKind.STRING_LITERAL_TOKEN, (String)("\"" + this.getNativeMethodName() + "\""), (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList(), (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList()));
        SpecificFieldNode classFieldNode = NodeFactory.createSpecificFieldNode(null, (Node)AbstractNodeFactory.createIdentifierToken((String)"'class"), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (ExpressionNode)classValueExp);
        SpecificFieldNode methodFieldNode = NodeFactory.createSpecificFieldNode(null, (Node)AbstractNodeFactory.createIdentifierToken((String)"name"), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (ExpressionNode)methodValueExp);
        MappingConstructorExpressionNode methodMapExp = NodeFactory.createMappingConstructorExpressionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[]{classFieldNode, AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN), methodFieldNode}), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
        AnnotationNode javaMethodAnnot = NodeFactory.createAnnotationNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.AT_TOKEN), (Node)javaMethodToken, (MappingConstructorExpressionNode)methodMapExp);
        return Optional.of(NodeFactory.createExternalFunctionBodyNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (NodeList)AbstractNodeFactory.createNodeList((Node[])new AnnotationNode[]{javaMethodAnnot}), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EXTERNAL_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN)));
    }

    private String getNativeMethodName() {
        return Objects.nonNull(((Operation)this.operation.getValue()).getParameters()) && ((Operation)this.operation.getValue()).getParameters().stream().anyMatch(p -> p.getIn().equals("path")) ? "invokeResource" : "invokeResourceWithoutPath";
    }
}

