/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.client.diagnostic;

import io.ballerina.openapi.core.generators.client.diagnostic.ClientDiagnostic;
import io.ballerina.openapi.core.generators.client.diagnostic.DiagnosticMessages;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.util.Optional;

public class ClientDiagnosticImp
implements ClientDiagnostic {
    private final String code;
    private final String message;
    private final DiagnosticSeverity diagnosticSeverity;

    public ClientDiagnosticImp(DiagnosticMessages message, String ... args) {
        this.code = message.getCode();
        this.message = String.format(message.getDescription(), args);
        this.diagnosticSeverity = message.getSeverity();
    }

    public ClientDiagnosticImp(Diagnostic diagnostic) {
        this.code = diagnostic.diagnosticInfo().code();
        this.message = diagnostic.message();
        this.diagnosticSeverity = diagnostic.diagnosticInfo().severity();
    }

    @Override
    public DiagnosticSeverity getDiagnosticSeverity() {
        return this.diagnosticSeverity;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Optional<Location> getLocation() {
        return Optional.empty();
    }

    @Override
    public String getCode() {
        return this.code;
    }
}

