/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.client.diagnostic;

import io.ballerina.openapi.core.generators.client.diagnostic.ClientDiagnostic;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.util.Optional;

public class ClientExceptionDiagnostic
implements ClientDiagnostic {
    private final String code;
    private final String message;
    private final DiagnosticSeverity diagnosticSeverity;
    private final Location location;

    public ClientExceptionDiagnostic(String code, String message, Location location, String ... args) {
        this.code = code;
        this.message = String.format(message, args);
        this.diagnosticSeverity = DiagnosticSeverity.ERROR;
        this.location = location;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public DiagnosticSeverity getDiagnosticSeverity() {
        return this.diagnosticSeverity;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Optional<Location> getLocation() {
        return Optional.ofNullable(this.location);
    }
}

