/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.client.mime;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionStatementNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.openapi.core.generators.client.BallerinaUtilGenerator;
import io.ballerina.openapi.core.generators.client.mime.MimeType;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.swagger.v3.oas.models.media.Encoding;
import io.swagger.v3.oas.models.media.MediaType;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultipartFormData
extends MimeType {
    BallerinaUtilGenerator ballerinaUtilGenerator;
    List<ImportDeclarationNode> imports;

    public MultipartFormData(List<ImportDeclarationNode> imports, BallerinaUtilGenerator ballerinaUtilGenerator) {
        this.imports = imports;
        this.ballerinaUtilGenerator = ballerinaUtilGenerator;
    }

    @Override
    public void setPayload(List<StatementNode> statementsList, Map.Entry<String, MediaType> mediaTypeEntry) {
        VariableDeclarationNode bodyPartsVariable;
        this.ballerinaUtilGenerator.setRequestBodyMultipartFormDatafound(true);
        GeneratorUtils.addImport(this.imports, "mime");
        GeneratorUtils.addImport(this.imports, "data.jsondata");
        VariableDeclarationNode encodingMap = this.getMultipartMap(mediaTypeEntry);
        if (encodingMap == null) {
            bodyPartsVariable = GeneratorUtils.getSimpleStatement("mime:Entity[]", "bodyParts", "check createBodyParts(check jsondata:toJson(payload).ensureType())");
        } else {
            statementsList.add((StatementNode)encodingMap);
            bodyPartsVariable = GeneratorUtils.getSimpleStatement("mime:Entity[]", "bodyParts", "check createBodyParts(check jsondata:toJson(payload).ensureType(), encodingMap)");
        }
        statementsList.add((StatementNode)bodyPartsVariable);
        ExpressionStatementNode setPayloadExpression = GeneratorUtils.getSimpleExpressionStatementNode("request.setBodyParts(bodyParts)");
        statementsList.add((StatementNode)setPayloadExpression);
    }

    private VariableDeclarationNode getMultipartMap(Map.Entry<String, MediaType> mediaTypeEntry) {
        if (mediaTypeEntry.getValue().getEncoding() != null) {
            LinkedList<Node> mapFields = new LinkedList<Node>();
            BuiltinSimpleNameReferenceNode mapType = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)"map<Encoding>"));
            CaptureBindingPatternNode bindingPattern = NodeFactory.createCaptureBindingPatternNode((Token)AbstractNodeFactory.createIdentifierToken((String)"encodingMap"));
            TypedBindingPatternNode bindingPatternNode = NodeFactory.createTypedBindingPatternNode((TypeDescriptorNode)mapType, (BindingPatternNode)bindingPattern);
            Set encodingEntries = mediaTypeEntry.getValue().getEncoding().entrySet();
            for (Map.Entry<String, Encoding> entry : encodingEntries) {
                this.getEncoding(entry, mapFields);
            }
            if (mapFields.isEmpty()) {
                return null;
            }
            mapFields.remove(mapFields.size() - 1);
            MappingConstructorExpressionNode initialize = NodeFactory.createMappingConstructorExpressionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList(mapFields), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
            return NodeFactory.createVariableDeclarationNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), null, (TypedBindingPatternNode)bindingPatternNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)initialize, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        }
        return null;
    }

    private void getEncoding(Map.Entry<String, Encoding> entry, List<Node> mapFields) {
        SpecificFieldNode contentField = null;
        SpecificFieldNode headersField = null;
        IdentifierToken fieldName = AbstractNodeFactory.createIdentifierToken((String)("\"" + entry.getKey() + "\""));
        SeparatedNodeList separatedNodeList = AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[0]);
        if (entry.getValue().getContentType() != null) {
            contentField = NodeFactory.createSpecificFieldNode(null, (Node)AbstractNodeFactory.createIdentifierToken((String)"contentType"), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (ExpressionNode)NodeFactory.createRequiredExpressionNode((Token)AbstractNodeFactory.createIdentifierToken((String)("\"" + entry.getValue().getContentType().split(",")[0] + "\""))));
        }
        if (entry.getValue().getHeaders() != null) {
            headersField = this.getHeaderEncoding(entry);
        }
        if (headersField != null && contentField != null) {
            separatedNodeList = AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[]{contentField, AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN), headersField});
        } else if (contentField != null) {
            separatedNodeList = AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[]{contentField});
        } else if (headersField != null) {
            separatedNodeList = AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[]{headersField});
        }
        MappingConstructorExpressionNode expressionNode = NodeFactory.createMappingConstructorExpressionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (SeparatedNodeList)separatedNodeList, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
        SpecificFieldNode specificFieldNode = NodeFactory.createSpecificFieldNode(null, (Node)fieldName, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (ExpressionNode)expressionNode);
        mapFields.add((Node)specificFieldNode);
        mapFields.add((Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
    }

    private SpecificFieldNode getHeaderEncoding(Map.Entry<String, Encoding> entry) {
        ArrayList<Object> headerMap = new ArrayList<Object>();
        for (Map.Entry header : entry.getValue().getHeaders().entrySet()) {
            IdentifierToken headerName = AbstractNodeFactory.createIdentifierToken((String)("\"" + (String)header.getKey() + "\""));
            SimpleNameReferenceNode valueExpr = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)GeneratorUtils.escapeIdentifier((String)header.getKey())));
            SpecificFieldNode specificFieldNode = NodeFactory.createSpecificFieldNode(null, (Node)headerName, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (ExpressionNode)valueExpr);
            headerMap.add(specificFieldNode);
            headerMap.add(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
        }
        if (!headerMap.isEmpty()) {
            headerMap.remove(headerMap.size() - 1);
        }
        MappingConstructorExpressionNode initialize = NodeFactory.createMappingConstructorExpressionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList(headerMap), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
        return NodeFactory.createSpecificFieldNode(null, (Node)AbstractNodeFactory.createIdentifierToken((String)"headers"), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (ExpressionNode)initialize);
    }
}

