/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.client.mock;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyBlockNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.ReturnStatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.openapi.core.generators.client.BallerinaClientGenerator;
import io.ballerina.openapi.core.generators.client.exception.ClientException;
import io.ballerina.openapi.core.generators.client.mock.MockClientFunctionGenerator;
import io.ballerina.openapi.core.generators.client.model.OASClientConfig;
import io.ballerina.openapi.core.generators.common.exception.BallerinaOpenApiException;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class BallerinaMockClientGenerator
extends BallerinaClientGenerator {
    public BallerinaMockClientGenerator(OASClientConfig oasClientConfig) {
        super(oasClientConfig);
    }

    public FunctionDefinitionNode getInitFunction() {
        FunctionSignatureNode functionSignatureNode = super.getInitFunctionSignatureNode();
        NodeList qualifierList = AbstractNodeFactory.createNodeList((Node[])new Token[]{AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ISOLATED_KEYWORD)});
        IdentifierToken functionName = AbstractNodeFactory.createIdentifierToken((String)"init");
        ArrayList<ReturnStatementNode> assignmentNodes = new ArrayList<ReturnStatementNode>();
        ReturnStatementNode returnStatementNode = NodeFactory.createReturnStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RETURN_KEYWORD), null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        assignmentNodes.add(returnStatementNode);
        NodeList statementList = AbstractNodeFactory.createNodeList(assignmentNodes);
        FunctionBodyBlockNode functionBodyNode = NodeFactory.createFunctionBodyBlockNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), null, (NodeList)statementList, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN), null);
        return NodeFactory.createFunctionDefinitionNode((SyntaxKind)SyntaxKind.FUNCTION_DEFINITION, (MetadataNode)super.getInitDocComment(), (NodeList)qualifierList, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.FUNCTION_KEYWORD), (IdentifierToken)functionName, (NodeList)AbstractNodeFactory.createEmptyNodeList(), (FunctionSignatureNode)functionSignatureNode, (FunctionBodyNode)functionBodyNode);
    }

    @Override
    public ClassDefinitionNode getClassDefinitionNode() {
        ArrayList<Object> memberNodeList = new ArrayList<Object>();
        memberNodeList.addAll(this.createClassInstanceVariables());
        memberNodeList.add(this.getInitFunction());
        Map<String, Map<PathItem.HttpMethod, Operation>> filteredOperations = this.filterOperations();
        ArrayList functionDefinitionNodeList = new ArrayList();
        for (Map.Entry<String, Map<PathItem.HttpMethod, Operation>> operation : filteredOperations.entrySet()) {
            for (Map.Entry<PathItem.HttpMethod, Operation> operationEntry : operation.getValue().entrySet()) {
                MockClientFunctionGenerator mockClientFunctionGenerator = new MockClientFunctionGenerator(operation.getKey(), operationEntry, this.oasClientConfig);
                Optional<FunctionDefinitionNode> funDefOptionalNode = mockClientFunctionGenerator.generateFunction();
                funDefOptionalNode.ifPresent(functionDefinitionNodeList::add);
                this.diagnostics.addAll(mockClientFunctionGenerator.getDiagnostics());
            }
        }
        memberNodeList.addAll(functionDefinitionNodeList);
        MetadataNode metadataNode = this.getClassMetadataNode();
        IdentifierToken className = AbstractNodeFactory.createIdentifierToken((String)"Client");
        NodeList classTypeQualifiers = AbstractNodeFactory.createNodeList((Node[])new Token[]{AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ISOLATED_KEYWORD), AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLIENT_KEYWORD)});
        return NodeFactory.createClassDefinitionNode((MetadataNode)metadataNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (NodeList)classTypeQualifiers, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLASS_KEYWORD), (Token)className, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (NodeList)AbstractNodeFactory.createNodeList(memberNodeList), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN), null);
    }

    @Override
    public SyntaxTree generateSyntaxTree() throws BallerinaOpenApiException, ClientException {
        return this.getSyntaxTree();
    }

    @Override
    public List<ObjectFieldNode> createClassInstanceVariables() {
        ArrayList<ObjectFieldNode> fieldNodeList = new ArrayList<ObjectFieldNode>();
        ObjectFieldNode apiKeyFieldNode = this.authConfigGeneratorImp.getApiKeyMapClassVariable();
        if (apiKeyFieldNode != null) {
            apiKeyFieldNode = apiKeyFieldNode.modify((MetadataNode)apiKeyFieldNode.metadata().orElse(null), (Token)apiKeyFieldNode.visibilityQualifier().orElse(null), apiKeyFieldNode.qualifierList(), apiKeyFieldNode.typeName(), apiKeyFieldNode.fieldName(), AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), NodeParser.parseExpression((String)"{ apikey: \"\"}"), apiKeyFieldNode.semicolonToken());
            fieldNodeList.add(apiKeyFieldNode);
        }
        return fieldNodeList;
    }
}

