/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.client.parameter;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.ArrayDimensionNode;
import io.ballerina.compiler.syntax.tree.ArrayTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.LiteralValueToken;
import io.ballerina.compiler.syntax.tree.MapTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypeParameterNode;
import io.ballerina.compiler.syntax.tree.UnionTypeDescriptorNode;
import io.ballerina.openapi.core.generators.client.diagnostic.ClientDiagnostic;
import io.ballerina.openapi.core.generators.client.diagnostic.ClientDiagnosticImp;
import io.ballerina.openapi.core.generators.client.diagnostic.DiagnosticMessages;
import io.ballerina.openapi.core.generators.client.parameter.ParameterGenerator;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.TypeHandler;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class HeadersParameterGenerator
implements ParameterGenerator {
    private final List<Parameter> parameters;
    private final List<ClientDiagnostic> diagnostics = new ArrayList<ClientDiagnostic>();
    private final OpenAPI openAPI;
    private final Operation operation;
    private final String httpMethod;
    private final String path;
    private boolean hasErrors = false;
    private final List<String> otherParamNames;

    public HeadersParameterGenerator(List<Parameter> parameters, OpenAPI openAPI, Operation operation, String httpMethod, String path) {
        this.parameters = parameters;
        this.openAPI = openAPI;
        this.operation = operation;
        this.httpMethod = httpMethod;
        this.path = path;
        this.otherParamNames = new ArrayList<String>();
    }

    public HeadersParameterGenerator(List<Parameter> parameters, OpenAPI openAPI, Operation operation, String httpMethod, String path, List<Parameter> otherParameters) {
        this.parameters = parameters;
        this.openAPI = openAPI;
        this.operation = operation;
        this.httpMethod = httpMethod;
        this.path = path;
        this.otherParamNames = otherParameters.stream().map(Parameter::getName).toList();
    }

    @Override
    public Optional<ParameterNode> generateParameterNode() {
        if (this.parameters.isEmpty()) {
            return Optional.empty();
        }
        ObjectSchema headersSchema = this.getHeadersSchema();
        if (Objects.isNull(headersSchema)) {
            return Optional.empty();
        }
        String operationId = GeneratorUtils.generateOperationUniqueId(this.operation, this.path, this.httpMethod);
        headersSchema.setDescription("Represents the Headers record for the operation: " + operationId);
        String headersName = GeneratorUtils.getValidName(operationId, true) + "Headers";
        this.openAPI.getComponents().addSchemas(headersName, (Schema)headersSchema);
        Schema headersRefSchema = new ObjectSchema().$ref(headersName);
        Optional<TypeDescriptorNode> headersType = TypeHandler.getInstance().getTypeNodeFromOASSchema(headersRefSchema, true);
        if (headersType.isEmpty()) {
            return Optional.empty();
        }
        boolean isDefaultable = this.isDefaultable(headersSchema);
        ParameterNode parameterNode = this.createParameterNode(headersType.get(), isDefaultable);
        return Optional.of(parameterNode);
    }

    private boolean isDefaultable(ObjectSchema headersSchema) {
        List requiredHeaders = headersSchema.getRequired();
        Map headers = headersSchema.getProperties();
        return Objects.isNull(requiredHeaders) || requiredHeaders.isEmpty() || requiredHeaders.stream().allMatch(header -> Objects.nonNull(((Schema)headers.get(header)).getDefault()));
    }

    private ParameterNode createParameterNode(TypeDescriptorNode headersType, boolean isDefaultable) {
        if (isDefaultable) {
            LiteralValueToken defaultMapVal = AbstractNodeFactory.createLiteralValueToken(null, (String)"{}", (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList(), (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList());
            BasicLiteralNode defaultMapExp = NodeFactory.createBasicLiteralNode(null, (Token)defaultMapVal);
            return NodeFactory.createDefaultableParameterNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), (Node)headersType, (Token)AbstractNodeFactory.createIdentifierToken((String)HeadersParameterGenerator.getHeadersParamName(this.otherParamNames)), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (Node)defaultMapExp);
        }
        return NodeFactory.createRequiredParameterNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), (Node)headersType, (Token)AbstractNodeFactory.createIdentifierToken((String)HeadersParameterGenerator.getHeadersParamName(this.otherParamNames)));
    }

    public static String getHeadersParamName(List<String> otherParamNames) {
        Object headersParamName = "headers";
        int i = 1;
        while (otherParamNames.contains(headersParamName)) {
            headersParamName = "headers" + i;
            ++i;
        }
        return headersParamName;
    }

    public static Optional<ParameterNode> getDefaultParameterNode() {
        return HeadersParameterGenerator.getDefaultParameterNode(new ArrayList<Parameter>());
    }

    public static Optional<ParameterNode> getDefaultParameterNode(List<Parameter> otherParameters) {
        List<String> otherParamNames = otherParameters.stream().map(Parameter::getName).toList();
        SimpleNameReferenceNode stringType = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"string"));
        ArrayDimensionNode dimensionNode = NodeFactory.createArrayDimensionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACKET_TOKEN), null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACKET_TOKEN));
        ArrayTypeDescriptorNode stringArrType = NodeFactory.createArrayTypeDescriptorNode((TypeDescriptorNode)stringType, (NodeList)AbstractNodeFactory.createNodeList((Node[])new ArrayDimensionNode[]{dimensionNode}));
        UnionTypeDescriptorNode unionType = NodeFactory.createUnionTypeDescriptorNode((TypeDescriptorNode)stringType, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PIPE_TOKEN), (TypeDescriptorNode)stringArrType);
        TypeParameterNode headerParamNode = NodeFactory.createTypeParameterNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.LT_TOKEN), (TypeDescriptorNode)unionType, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.GT_TOKEN));
        MapTypeDescriptorNode defaultHeadersType = NodeFactory.createMapTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.MAP_KEYWORD), (TypeParameterNode)headerParamNode);
        LiteralValueToken defaultMapVal = AbstractNodeFactory.createLiteralValueToken(null, (String)"{}", (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList(), (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList());
        BasicLiteralNode defaultMapExp = NodeFactory.createBasicLiteralNode(null, (Token)defaultMapVal);
        return Optional.of(NodeFactory.createDefaultableParameterNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), (Node)defaultHeadersType, (Token)AbstractNodeFactory.createIdentifierToken((String)HeadersParameterGenerator.getHeadersParamName(otherParamNames)), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (Node)defaultMapExp));
    }

    @Override
    public List<ClientDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    private ObjectSchema getHeadersSchema() {
        HashMap<String, Schema> properties = new HashMap<String, Schema>();
        for (Parameter parameter2 : this.parameters) {
            properties.put(parameter2.getName(), this.getSchemaWithDetails(parameter2));
        }
        properties.entrySet().removeIf(entry -> {
            if (Objects.isNull(entry.getValue())) {
                ClientDiagnosticImp diagnostic = new ClientDiagnosticImp(DiagnosticMessages.OAS_CLIENT_108, (String)entry.getKey());
                this.diagnostics.add(diagnostic);
                this.hasErrors = true;
                return true;
            }
            return false;
        });
        if (properties.isEmpty()) {
            return null;
        }
        ArrayList<String> requiredFields = new ArrayList<String>(this.parameters.stream().filter(parameter -> Boolean.TRUE.equals(parameter.getRequired())).map(Parameter::getName).toList());
        requiredFields.removeIf(field -> !properties.containsKey(field));
        ObjectSchema headersSchema = new ObjectSchema();
        headersSchema.setProperties(properties);
        if (!requiredFields.isEmpty()) {
            headersSchema.setRequired(requiredFields);
        }
        return headersSchema;
    }

    public static String getHeadersParamName(ParameterNode parameterNode) {
        DefaultableParameterNode parameter;
        RequiredParameterNode requiredParameterNode;
        if (parameterNode instanceof RequiredParameterNode && (requiredParameterNode = (RequiredParameterNode)parameterNode).paramName().isPresent()) {
            return ((Token)requiredParameterNode.paramName().get()).text();
        }
        if (parameterNode instanceof DefaultableParameterNode && (parameter = (DefaultableParameterNode)parameterNode).paramName().isPresent()) {
            return ((Token)parameter.paramName().get()).text();
        }
        return "headers";
    }
}

