/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.client.parameter;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.openapi.core.generators.client.diagnostic.ClientDiagnostic;
import io.ballerina.openapi.core.generators.client.diagnostic.ClientDiagnosticImp;
import io.ballerina.openapi.core.generators.client.diagnostic.DiagnosticMessages;
import io.ballerina.openapi.core.generators.client.parameter.ParameterGenerator;
import io.ballerina.openapi.core.generators.client.parameter.RequestBodyHeaderParameter;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.TypeHandler;
import io.ballerina.openapi.core.generators.common.exception.BallerinaOpenApiException;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.Encoding;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class RequestBodyGenerator
implements ParameterGenerator {
    OpenAPI openAPI;
    RequestBody requestBody;
    List<ClientDiagnostic> diagnostics = new ArrayList<ClientDiagnostic>();
    List<Parameter> headerSchemas = new ArrayList<Parameter>();

    public RequestBodyGenerator(RequestBody requestBody, OpenAPI openAPI) {
        this.requestBody = requestBody;
        this.openAPI = openAPI;
    }

    public List<Parameter> getHeaderSchemas() {
        return this.headerSchemas;
    }

    @Override
    public Optional<ParameterNode> generateParameterNode() {
        Content requestBodyContent;
        RequestBody referencedRequestBody;
        SimpleNameReferenceNode typeDescNode = null;
        if (this.requestBody.get$ref() != null) {
            String referencedRequestBodyName;
            try {
                referencedRequestBodyName = GeneratorUtils.extractReferenceType(this.requestBody.get$ref()).trim();
            }
            catch (BallerinaOpenApiException e) {
                ClientDiagnosticImp diagnostic = new ClientDiagnosticImp(DiagnosticMessages.OAS_CLIENT_109, this.requestBody.get$ref());
                this.diagnostics.add(diagnostic);
                return Optional.empty();
            }
            referencedRequestBody = (RequestBody)this.openAPI.getComponents().getRequestBodies().get(referencedRequestBodyName);
            requestBodyContent = referencedRequestBody.getContent();
            this.requestBody.setDescription(referencedRequestBody.getDescription());
        } else {
            requestBodyContent = this.requestBody.getContent();
        }
        if (requestBodyContent == null || requestBodyContent.isEmpty()) {
            return Optional.empty();
        }
        referencedRequestBody = requestBodyContent.entrySet().iterator();
        if (referencedRequestBody.hasNext()) {
            Map.Entry mediaTypeEntry = (Map.Entry)referencedRequestBody.next();
            Schema schema = ((MediaType)mediaTypeEntry.getValue()).getSchema();
            if (schema != null && GeneratorUtils.isSupportedMediaType(mediaTypeEntry)) {
                String mediaTypeEntryKey = (String)mediaTypeEntry.getKey();
                if (mediaTypeEntryKey.equals("application/octet-stream") || mediaTypeEntryKey.matches("application/.*\\+octet-stream")) {
                    String paramType = GeneratorUtils.getBallerinaMediaType(mediaTypeEntryKey, true);
                    typeDescNode = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)paramType));
                } else if (schema.get$ref() != null) {
                    Optional<TypeDescriptorNode> node = TypeHandler.getInstance().getTypeNodeFromOASSchema(schema);
                    if (node.isEmpty()) {
                        return Optional.empty();
                    }
                    typeDescNode = node.get();
                } else if (GeneratorUtils.getOpenAPIType(schema) != null || schema.getProperties() != null) {
                    Optional<TypeDescriptorNode> resultNode = TypeHandler.getInstance().getTypeNodeFromOASSchema(schema);
                    if (resultNode.isEmpty()) {
                        if (schema instanceof ArraySchema) {
                            String paramType = GeneratorUtils.getBallerinaMediaType((String)mediaTypeEntry.getKey(), true) + "[]";
                            typeDescNode = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)paramType));
                        } else {
                            String paramType = GeneratorUtils.getBallerinaMediaType(mediaTypeEntryKey, true);
                            typeDescNode = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)paramType));
                        }
                    } else {
                        typeDescNode = resultNode.get();
                        if (schema instanceof ArraySchema && typeDescNode.toSourceCode().contains("anydata")) {
                            String paramType = GeneratorUtils.getBallerinaMediaType((String)mediaTypeEntry.getKey(), true) + "[]";
                            typeDescNode = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)paramType));
                        }
                    }
                } else {
                    String paramType = GeneratorUtils.getBallerinaMediaType(mediaTypeEntryKey, true);
                    typeDescNode = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)paramType));
                }
                if (mediaTypeEntryKey.equals("multipart/form-data") || mediaTypeEntryKey.matches("multipart/.*\\+form-data")) {
                    this.extractHeaders(mediaTypeEntry);
                }
            } else if (((String)mediaTypeEntry.getKey()).equals("multipart/form-data") && ((MediaType)mediaTypeEntry.getValue()).getEncoding() != null) {
                this.extractHeaders(mediaTypeEntry);
            } else {
                String paramType = GeneratorUtils.getBallerinaMediaType((String)mediaTypeEntry.getKey(), true);
                typeDescNode = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)paramType));
            }
        }
        if (typeDescNode != null) {
            String reqBody = typeDescNode.toSourceCode().equals("http:Request") ? "request" : "payload";
            return Optional.of(NodeFactory.createRequiredParameterNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), typeDescNode, (Token)AbstractNodeFactory.createIdentifierToken((String)reqBody)));
        }
        return Optional.empty();
    }

    private void extractHeaders(Map.Entry<String, MediaType> mediaTypeEntry) {
        Map encodingHeaders = mediaTypeEntry.getValue().getEncoding();
        if (encodingHeaders == null) {
            return;
        }
        ArrayList<String> headerList = new ArrayList<String>();
        for (Map.Entry entry : encodingHeaders.entrySet()) {
            Map headers = ((Encoding)entry.getValue()).getHeaders();
            if (headers == null) continue;
            for (Map.Entry<String, Header> entry2 : headers.entrySet()) {
                if (headerList.contains(GeneratorUtils.escapeIdentifier((String)entry2.getKey()))) continue;
                RequestBodyHeaderParameter requestBodyHeaderParameter = new RequestBodyHeaderParameter(entry2);
                Optional<Parameter> parameter = requestBodyHeaderParameter.generateParameterSchema();
                parameter.ifPresent(param -> this.headerSchemas.add((Parameter)param));
                this.diagnostics.addAll(requestBodyHeaderParameter.getDiagnostics());
                headerList.add(GeneratorUtils.escapeIdentifier(entry2.getKey()));
            }
        }
    }

    @Override
    public List<ClientDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }
}

