/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.common;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ArrayDimensionNode;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionStatementNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Minutiae;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.ResourcePathParameterNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxInfo;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.openapi.core.generators.common.ErrorMessages;
import io.ballerina.openapi.core.generators.common.GeneratorConstants;
import io.ballerina.openapi.core.generators.common.InlineModelResolver;
import io.ballerina.openapi.core.generators.common.OASModifier;
import io.ballerina.openapi.core.generators.common.TypeHandler;
import io.ballerina.openapi.core.generators.common.diagnostic.CommonDiagnostic;
import io.ballerina.openapi.core.generators.common.diagnostic.CommonDiagnosticMessages;
import io.ballerina.openapi.core.generators.common.exception.BallerinaOpenApiException;
import io.ballerina.openapi.core.generators.common.exception.InvalidReferenceException;
import io.ballerina.openapi.core.generators.common.exception.NullPathParameterException;
import io.ballerina.openapi.core.generators.common.exception.UnsupportedOASDataTypeException;
import io.ballerina.openapi.core.generators.common.model.GenSrcFile;
import io.ballerina.openapi.core.generators.type.exception.OASTypeGenException;
import io.ballerina.openapi.core.generators.type.generators.EnumGenerator;
import io.ballerina.openapi.core.generators.type.model.GeneratorMetaData;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.servers.ServerVariable;
import io.swagger.v3.oas.models.servers.ServerVariables;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GeneratorUtils {
    public static final MinutiaeList SINGLE_WS_MINUTIAE = GeneratorUtils.getSingleWSMinutiae();
    public static final List<String> BAL_KEYWORDS = SyntaxInfo.keywords();
    public static final MinutiaeList SINGLE_END_OF_LINE_MINUTIAE = GeneratorUtils.getEndOfLineMinutiae();
    private static final PrintStream OUT_STREAM = System.err;
    public static final String NAME = "name";
    public static final String VALUE = "value";
    public static final char CHAR = '\"';
    public static final String JSONDATA_IMPORT = "import ballerina/data.jsondata;";
    public static final String HTTP_IMPORT = "import ballerina/http;";
    private static HashMap<String, Integer> recordCountMap;
    private static final List<String> primitiveTypeList;

    public static void initializeRecordCountMap() {
        recordCountMap = new HashMap();
    }

    public static ImportDeclarationNode getImportDeclarationNode(String orgName, String moduleName) {
        IdentifierToken importKeyword = AbstractNodeFactory.createIdentifierToken((String)"import", (MinutiaeList)SINGLE_WS_MINUTIAE, (MinutiaeList)SINGLE_WS_MINUTIAE);
        IdentifierToken orgNameToken = AbstractNodeFactory.createIdentifierToken((String)orgName);
        IdentifierToken slashToken = AbstractNodeFactory.createIdentifierToken((String)"/");
        ImportOrgNameNode importOrgNameNode = NodeFactory.createImportOrgNameNode((Token)orgNameToken, (Token)slashToken);
        IdentifierToken moduleNameToken = AbstractNodeFactory.createIdentifierToken((String)moduleName);
        SeparatedNodeList moduleNodeList = AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[]{moduleNameToken});
        IdentifierToken semicolon = AbstractNodeFactory.createIdentifierToken((String)";");
        return NodeFactory.createImportDeclarationNode((Token)importKeyword, (ImportOrgNameNode)importOrgNameNode, (SeparatedNodeList)moduleNodeList, null, (Token)semicolon);
    }

    public static QualifiedNameReferenceNode getQualifiedNameReferenceNode(String modulePrefix, String identifier) {
        IdentifierToken modulePrefixToken = AbstractNodeFactory.createIdentifierToken((String)modulePrefix);
        IdentifierToken colon = AbstractNodeFactory.createIdentifierToken((String)":");
        IdentifierToken identifierToken = AbstractNodeFactory.createIdentifierToken((String)identifier);
        return NodeFactory.createQualifiedNameReferenceNode((Token)modulePrefixToken, (Node)colon, (IdentifierToken)identifierToken);
    }

    public static NodeList<Node> getRelativeResourcePath(String path, Operation operation, Components components, boolean isWithoutDataBinding, List<Diagnostic> diagnostics) throws BallerinaOpenApiException {
        ArrayList<Node> functionRelativeResourcePath = new ArrayList<Node>();
        String[] pathNodes = path.split("/");
        if (pathNodes.length >= 2) {
            for (String pathNode : pathNodes) {
                if (pathNode.contains("{")) {
                    String pathParam = pathNode;
                    pathParam = pathParam.substring(pathParam.indexOf("{") + 1);
                    pathParam = pathParam.substring(0, pathParam.indexOf("}"));
                    pathParam = GeneratorUtils.escapeIdentifier(pathParam);
                    if (operation.getParameters() == null) continue;
                    GeneratorUtils.extractPathParameterDetails(operation, functionRelativeResourcePath, pathNode, pathParam, components, isWithoutDataBinding, diagnostics);
                    continue;
                }
                if (pathNode.isBlank()) continue;
                IdentifierToken idToken = AbstractNodeFactory.createIdentifierToken((String)GeneratorUtils.escapeIdentifier(pathNode.trim()));
                functionRelativeResourcePath.add((Node)idToken);
                functionRelativeResourcePath.add((Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SLASH_TOKEN));
            }
            functionRelativeResourcePath.remove(functionRelativeResourcePath.size() - 1);
        } else if (pathNodes.length == 0) {
            IdentifierToken idToken = AbstractNodeFactory.createIdentifierToken((String)".");
            functionRelativeResourcePath.add((Node)idToken);
        } else {
            IdentifierToken idToken = AbstractNodeFactory.createIdentifierToken((String)pathNodes[1].trim());
            functionRelativeResourcePath.add((Node)idToken);
        }
        return AbstractNodeFactory.createNodeList(functionRelativeResourcePath);
    }

    private static void extractPathParameterDetails(Operation operation, List<Node> functionRelativeResourcePath, String pathNode, String pathParam, Components components, boolean isWithoutDataBinding, List<Diagnostic> diagnostics) throws BallerinaOpenApiException {
        String[] split = pathNode.split("}", 2);
        Pattern pattern = Pattern.compile("[^a-zA-Z0-9]");
        Matcher matcher = pattern.matcher(split[1]);
        boolean hasSpecialCharacter = matcher.find();
        for (Parameter parameter : operation.getParameters()) {
            String paramType;
            if (parameter.get$ref() != null) {
                parameter = (Parameter)GeneratorMetaData.getInstance().getOpenAPI().getComponents().getParameters().get(GeneratorUtils.extractReferenceType(parameter.get$ref()));
            }
            if (parameter.getIn() == null || !pathParam.trim().equals(GeneratorUtils.escapeIdentifier(parameter.getName().trim())) || !parameter.getIn().equals("path")) continue;
            if (parameter.getSchema().get$ref() != null) {
                paramType = GeneratorUtils.resolveReferenceType(parameter.getSchema(), components, isWithoutDataBinding, pathParam, diagnostics);
            } else {
                paramType = GeneratorUtils.getPathParameterType(parameter.getSchema(), pathParam, diagnostics);
                if (paramType.endsWith("?")) {
                    throw new NullPathParameterException();
                }
            }
            BuiltinSimpleNameReferenceNode builtSNRNode = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)(parameter.getSchema() == null || hasSpecialCharacter ? AbstractNodeFactory.createIdentifierToken((String)"string") : AbstractNodeFactory.createIdentifierToken((String)paramType)));
            IdentifierToken paramName = AbstractNodeFactory.createIdentifierToken((String)(hasSpecialCharacter ? GeneratorUtils.escapeIdentifier(pathNode) : pathParam));
            ResourcePathParameterNode resourcePathParameterNode = NodeFactory.createResourcePathParameterNode((SyntaxKind)SyntaxKind.RESOURCE_PATH_SEGMENT_PARAM, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACKET_TOKEN), (NodeList)NodeFactory.createEmptyNodeList(), (TypeDescriptorNode)builtSNRNode, null, (Token)paramName, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACKET_TOKEN));
            functionRelativeResourcePath.add((Node)resourcePathParameterNode);
            functionRelativeResourcePath.add((Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SLASH_TOKEN));
            break;
        }
    }

    public static String convertOpenAPITypeToBallerina(Schema<?> schema, boolean ignoreNullableFlag) throws UnsupportedOASDataTypeException {
        String type = GeneratorUtils.getOpenAPIType(schema);
        if (schema.getEnum() != null && !schema.getEnum().isEmpty() && primitiveTypeList.contains(type)) {
            EnumGenerator enumGenerator = new EnumGenerator(schema, null, ignoreNullableFlag, new HashMap<String, TypeDefinitionNode>(), new HashMap<String, NameReferenceNode>());
            try {
                return enumGenerator.generateTypeDescriptorNode().toString();
            }
            catch (OASTypeGenException exp) {
                return "";
            }
        }
        if (("integer".equals(type) || "number".equals(type) || "string".equals(type)) && schema.getFormat() != null) {
            return GeneratorUtils.convertOpenAPITypeFormatToBallerina(type, schema);
        }
        if (GeneratorConstants.OPENAPI_TYPE_TO_BAL_TYPE_MAP.containsKey(type)) {
            return GeneratorConstants.OPENAPI_TYPE_TO_BAL_TYPE_MAP.get(type);
        }
        throw new UnsupportedOASDataTypeException(type);
    }

    private static String convertOpenAPITypeFormatToBallerina(String dataType, Schema<?> schema) throws UnsupportedOASDataTypeException {
        if (GeneratorConstants.OPENAPI_TYPE_TO_FORMAT_MAP.containsKey(dataType) && GeneratorConstants.OPENAPI_TYPE_TO_FORMAT_MAP.get(dataType).contains(schema.getFormat())) {
            if (GeneratorConstants.OPENAPI_TYPE_TO_BAL_TYPE_MAP.containsKey(schema.getFormat())) {
                return GeneratorConstants.OPENAPI_TYPE_TO_BAL_TYPE_MAP.get(schema.getFormat());
            }
            OUT_STREAM.printf("WARNING: unsupported format `%s` will be skipped when generating the counterpart Ballerina type for openAPI schema type: `%s`%n", schema.getFormat(), schema.getType());
            if (GeneratorConstants.OPENAPI_TYPE_TO_BAL_TYPE_MAP.containsKey(dataType)) {
                return GeneratorConstants.OPENAPI_TYPE_TO_BAL_TYPE_MAP.get(dataType);
            }
            throw new UnsupportedOASDataTypeException(dataType);
        }
        if (GeneratorConstants.OPENAPI_TYPE_TO_BAL_TYPE_MAP.containsKey(dataType)) {
            return GeneratorConstants.OPENAPI_TYPE_TO_BAL_TYPE_MAP.get(dataType);
        }
        throw new UnsupportedOASDataTypeException(dataType);
    }

    public static String escapeIdentifier(String identifier) {
        if (identifier.matches("\\b[0-9([\\[\\]\\\\?!<>@#&~'`*\\-=^+();:\\/{}\\s|.$])]*\\b") || identifier.matches("^[0-9].*")) {
            return "'" + identifier.replaceAll("([\\[\\]\\\\?!<>@#&~'`*\\-=^+();:\\/{}\\s|.$])", "\\\\$1");
        }
        if (!identifier.matches("\\b[_a-zA-Z][_a-zA-Z0-9]*\\b")) {
            return identifier.replaceAll("([\\[\\]\\\\?!<>@#&~'`*\\-=^+();:\\/{}\\s|.$])", "\\\\$1");
        }
        if (BAL_KEYWORDS.contains(identifier)) {
            return "'" + identifier;
        }
        return identifier;
    }

    /*
     * WARNING - void declaration
     */
    public static String getValidName(String identifier, boolean isSchema) {
        if (identifier.isBlank()) {
            return "\\" + identifier;
        }
        if (!identifier.matches("\\b[0-9]*\\b")) {
            String[] split = identifier.split("([\\[\\]\\\\?!<>@#&~'`*\\_\\-=^+();:\\/{}\\s|.$])");
            StringBuilder validName = new StringBuilder();
            for (String string : split) {
                void var7_7;
                if (string.isBlank()) continue;
                if (split.length > 1) {
                    String string2 = string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1);
                }
                validName.append((String)var7_7);
            }
            identifier = validName.toString();
        }
        if (isSchema) {
            return identifier.substring(0, 1).toUpperCase(Locale.ENGLISH) + identifier.substring(1);
        }
        return GeneratorUtils.escapeIdentifier(identifier.substring(0, 1).toLowerCase(Locale.ENGLISH) + identifier.substring(1));
    }

    public static boolean isValidSchemaName(String recordName) {
        return !recordName.matches("\\b[0-9]*\\b");
    }

    public static String extractReferenceType(String referenceVariable) throws InvalidReferenceException {
        if (referenceVariable.startsWith("#") && referenceVariable.contains("/")) {
            String[] refArray = referenceVariable.split("/");
            return refArray[refArray.length - 1];
        }
        throw new InvalidReferenceException(referenceVariable);
    }

    public static String extractReferenceSection(String referenceVariable) throws InvalidReferenceException {
        if (referenceVariable.startsWith("#") && referenceVariable.contains("/")) {
            String[] refArray = referenceVariable.split("/");
            return refArray[refArray.length - 2];
        }
        throw new InvalidReferenceException(referenceVariable);
    }

    public static Optional<String> getBallerinaNameExtension(Parameter parameter) {
        if (Objects.isNull(parameter) || Objects.isNull(parameter.getExtensions())) {
            return Optional.empty();
        }
        return GeneratorUtils.getBallerinaNameExtension(parameter.getExtensions());
    }

    public static Optional<String> getBallerinaNameExtension(Schema schema) {
        return Optional.ofNullable(schema).map(Schema::getExtensions).flatMap(GeneratorUtils::getBallerinaNameExtension);
    }

    public static Optional<String> getBallerinaNameExtension(Map<String, Object> extensions) {
        return Optional.ofNullable(extensions).map(ext -> ext.get("x-ballerina-name")).filter(String.class::isInstance).map(String.class::cast).map(String::trim);
    }

    public static boolean hasTags(List<String> tags, List<String> filterTags) {
        return !Collections.disjoint(filterTags, tags);
    }

    public static OpenAPI getOpenAPIFromOpenAPIV3Parser(Path definitionPath) throws IOException, BallerinaOpenApiException {
        Path contractPath = Paths.get(definitionPath.toString(), new String[0]);
        if (!Files.exists(contractPath, new LinkOption[0])) {
            throw new BallerinaOpenApiException(ErrorMessages.invalidFilePath(definitionPath.toString()));
        }
        if (!(definitionPath.toString().endsWith(".yaml") || definitionPath.toString().endsWith(".json") || definitionPath.toString().endsWith(".yml"))) {
            throw new BallerinaOpenApiException(ErrorMessages.invalidFileType());
        }
        String openAPIFileContent = Files.readString(definitionPath);
        ParseOptions parseOptions = new ParseOptions();
        parseOptions.setResolve(true);
        parseOptions.setFlatten(true);
        SwaggerParseResult parseResult = new OpenAPIParser().readContents(openAPIFileContent, null, parseOptions);
        if (!parseResult.getMessages().isEmpty()) {
            if (parseResult.getMessages().contains("attribute swaggerVersion is unexpected")) {
                throw new BallerinaOpenApiException(ErrorMessages.unsupportedOpenAPIVersion());
            }
            StringBuilder errorMessage = new StringBuilder("OpenAPI definition has errors: \n");
            for (String message : parseResult.getMessages()) {
                errorMessage.append(message).append(GeneratorConstants.LINE_SEPARATOR);
            }
            throw new BallerinaOpenApiException(errorMessage.toString());
        }
        return parseResult.getOpenAPI();
    }

    public static boolean isSupportedMediaType(Map.Entry<String, MediaType> mediaTypeEntry) {
        boolean isValidMultipartFormData;
        String mediaType = mediaTypeEntry.getKey();
        String[] contentTypes = mediaType.split(";");
        if (mediaType.length() > 1) {
            mediaType = contentTypes[0];
        }
        String defaultBallerinaType = GeneratorUtils.getBallerinaMediaType(mediaType, true);
        Schema schema = mediaTypeEntry.getValue().getSchema();
        boolean bl = isValidMultipartFormData = mediaType.equals("multipart/form-data") && schema != null && (schema.get$ref() != null || schema.getProperties() != null || GeneratorUtils.getOpenAPIType(schema).equals("object"));
        return !defaultBallerinaType.equals("http:Request") || isValidMultipartFormData;
    }

    public static boolean hasRequestBinding(String mediaType) {
        return GeneratorUtils.getBallerinaMediaType(mediaType, true).equals("http:Request");
    }

    public static String getBallerinaMediaType(String mediaType, boolean isRequest) {
        String[] contentTypes = mediaType.split(";");
        if (mediaType.length() > 1) {
            mediaType = contentTypes[0];
        }
        if (mediaType.matches(".*/json") || mediaType.matches("application/.*\\+json")) {
            return SyntaxKind.JSON_KEYWORD.stringValue();
        }
        if (mediaType.matches(".*/xml") || mediaType.matches("application/.*\\+xml")) {
            return SyntaxKind.XML_KEYWORD.stringValue();
        }
        if (mediaType.equals("text/event-stream") && !isRequest) {
            return "stream<http:SseEvent, error?>";
        }
        if (mediaType.equals("application//x-www-form-urlencoded") || mediaType.matches("text/.*")) {
            return SyntaxKind.STRING_KEYWORD.stringValue();
        }
        if (mediaType.equals("application/octet-stream") || mediaType.equals("image/png") || mediaType.matches("application/.*\\+octet-stream")) {
            return SyntaxKind.BYTE_KEYWORD.stringValue() + "[]";
        }
        if (mediaType.equals("application/x-www-form-urlencoded")) {
            return "map<string>";
        }
        if (mediaType.equals("multipart/form-data") && isRequest) {
            return "record{}";
        }
        return isRequest ? "http:Request" : "http:Response";
    }

    public static VariableDeclarationNode getSimpleStatement(String responseType, String variable, String initializer) {
        SimpleNameReferenceNode resTypeBind = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)responseType));
        CaptureBindingPatternNode bindingPattern = NodeFactory.createCaptureBindingPatternNode((Token)AbstractNodeFactory.createIdentifierToken((String)variable));
        TypedBindingPatternNode typedBindingPatternNode = NodeFactory.createTypedBindingPatternNode((TypeDescriptorNode)resTypeBind, (BindingPatternNode)bindingPattern);
        SimpleNameReferenceNode init = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)initializer));
        return NodeFactory.createVariableDeclarationNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), null, (TypedBindingPatternNode)typedBindingPatternNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)init, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    public static ExpressionStatementNode getSimpleExpressionStatementNode(String expression) {
        SimpleNameReferenceNode expressionNode = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)expression));
        return NodeFactory.createExpressionStatementNode(null, (ExpressionNode)expressionNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    public static String buildUrl(String absUrl, ServerVariables variables) {
        String url = absUrl;
        if (variables != null) {
            for (Map.Entry entry : variables.entrySet()) {
                String replaceKey = "\\{" + (String)entry.getKey() + "}";
                url = url.replaceAll(replaceKey, ((ServerVariable)entry.getValue()).getDefault());
            }
        }
        return url;
    }

    private static MinutiaeList getSingleWSMinutiae() {
        Minutiae whitespace = AbstractNodeFactory.createWhitespaceMinutiae((String)" ");
        MinutiaeList leading = AbstractNodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{whitespace});
        return leading;
    }

    private static MinutiaeList getEndOfLineMinutiae() {
        Minutiae endOfLineMinutiae = AbstractNodeFactory.createEndOfLineMinutiae((String)GeneratorConstants.LINE_SEPARATOR);
        MinutiaeList leading = AbstractNodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{endOfLineMinutiae});
        return leading;
    }

    public static void setGeneratedFileName(List<File> listFiles, GenSrcFile gFile, int duplicateCount) {
        for (File listFile : listFiles) {
            String listFileName = listFile.getName();
            if (!listFileName.contains(".") || listFileName.split("\\.").length < 2 || !listFileName.split("\\.")[0].equals(gFile.getFileName().split("\\.")[0])) continue;
            duplicateCount = 1 + duplicateCount;
        }
        gFile.setFileName(gFile.getFileName().split("\\.")[0] + "." + duplicateCount + "." + gFile.getFileName().split("\\.")[1]);
    }

    public static void createEncodingMap(List<Node> filedOfMap, String style, Boolean explode, String key) {
        IdentifierToken fieldName = AbstractNodeFactory.createIdentifierToken((String)("\"" + key + "\""));
        Token colon = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN);
        SpecificFieldNode styleField = NodeFactory.createSpecificFieldNode(null, (Node)AbstractNodeFactory.createIdentifierToken((String)"style"), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (ExpressionNode)NodeFactory.createRequiredExpressionNode((Token)AbstractNodeFactory.createIdentifierToken((String)style.toUpperCase(Locale.ROOT))));
        SpecificFieldNode explodeField = NodeFactory.createSpecificFieldNode(null, (Node)AbstractNodeFactory.createIdentifierToken((String)"explode"), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (ExpressionNode)NodeFactory.createRequiredExpressionNode((Token)AbstractNodeFactory.createIdentifierToken((String)explode.toString())));
        MappingConstructorExpressionNode expressionNode = NodeFactory.createMappingConstructorExpressionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[]{styleField, AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN), explodeField}), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
        SpecificFieldNode specificFieldNode = NodeFactory.createSpecificFieldNode(null, (Node)fieldName, (Token)colon, (ExpressionNode)expressionNode);
        filedOfMap.add((Node)specificFieldNode);
        filedOfMap.add((Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
    }

    public static boolean checkImportDuplicate(List<ImportDeclarationNode> imports, String module) {
        for (ImportDeclarationNode importModule : imports) {
            StringBuilder moduleBuilder = new StringBuilder();
            for (IdentifierToken identifierToken : importModule.moduleName()) {
                moduleBuilder.append(identifierToken.toString().trim());
            }
            if (!"ballerina".equals(((ImportOrgNameNode)importModule.orgName().get()).orgName().toString().trim()) || !module.equals(moduleBuilder.toString())) continue;
            return true;
        }
        return false;
    }

    public static void addImport(List<ImportDeclarationNode> imports, String module) {
        if (imports == null) {
            imports = new ArrayList<ImportDeclarationNode>();
        }
        if (!GeneratorUtils.checkImportDuplicate(imports, module)) {
            ImportDeclarationNode importModule = GeneratorUtils.getImportDeclarationNode("ballerina", module);
            imports.add(importModule);
        }
    }

    public static boolean isComplexURL(String path) {
        String[] subPathSegment = path.split("/");
        Pattern pattern = Pattern.compile("[^a-zA-Z0-9]");
        for (String subPath : subPathSegment) {
            if (!subPath.contains("{") || !pattern.matcher(subPath.split("}", 2)[1]).find()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasConstraints(Schema<?> value) {
        if (value.getProperties() != null) {
            boolean constraintExists = value.getProperties().values().stream().anyMatch(GeneratorUtils::hasConstraints);
            if (constraintExists) {
                return true;
            }
        } else if (GeneratorUtils.isComposedSchema(value)) {
            List allOf = value.getAllOf();
            List oneOf = value.getOneOf();
            List anyOf = value.getAnyOf();
            boolean constraintExists = false;
            if (allOf != null) {
                constraintExists = allOf.stream().anyMatch(GeneratorUtils::hasConstraints);
            } else if (oneOf != null) {
                constraintExists = oneOf.stream().anyMatch(GeneratorUtils::hasConstraints);
            } else if (anyOf != null) {
                constraintExists = anyOf.stream().anyMatch(GeneratorUtils::hasConstraints);
            }
            if (constraintExists) {
                return true;
            }
        } else if (GeneratorUtils.isArraySchema(value) && !GeneratorUtils.isConstraintExists(value)) {
            return GeneratorUtils.isConstraintExists(value.getItems());
        }
        return GeneratorUtils.isConstraintExists(value);
    }

    private static boolean isConstraintExists(Schema<?> propertyValue) {
        return propertyValue.getMaximum() != null || propertyValue.getMinimum() != null || propertyValue.getMaxLength() != null || propertyValue.getMinLength() != null || propertyValue.getMaxItems() != null || propertyValue.getMinItems() != null || propertyValue.getExclusiveMinimum() != null || propertyValue.getExclusiveMaximum() != null || propertyValue.getPattern() != null;
    }

    public static OpenAPI normalizeOpenAPI(Path openAPIPath, boolean validateOpIds, boolean isSanitized) throws IOException, BallerinaOpenApiException {
        return GeneratorUtils.normalizeOpenAPI(openAPIPath, validateOpIds, isSanitized, false);
    }

    public static OpenAPI normalizeOpenAPI(Path openAPIPath, boolean validateOpIds, boolean isSanitized, boolean isFlatten) throws IOException, BallerinaOpenApiException {
        OpenAPI openAPI = GeneratorUtils.getOpenAPIFromOpenAPIV3Parser(openAPIPath);
        return GeneratorUtils.normalizeOpenAPI(openAPI, validateOpIds, isSanitized, isFlatten);
    }

    public static OpenAPI normalizeOpenAPI(OpenAPI openAPI, boolean validateOpIds, boolean isSanitized) throws BallerinaOpenApiException {
        return GeneratorUtils.normalizeOpenAPI(openAPI, validateOpIds, isSanitized, false);
    }

    public static OpenAPI normalizeOpenAPI(OpenAPI openAPI, boolean validateOpIds, boolean isSanitized, boolean flatten) throws BallerinaOpenApiException {
        io.swagger.v3.oas.models.Paths openAPIPaths = openAPI.getPaths();
        if (validateOpIds) {
            GeneratorUtils.validateOperationIds(openAPIPaths.entrySet());
        }
        GeneratorUtils.validateRequestBody(openAPIPaths.entrySet());
        if (flatten) {
            new InlineModelResolver(true, false).flatten(openAPI);
        }
        if (isSanitized) {
            openAPI = new OASModifier().modify(openAPI);
        }
        return openAPI;
    }

    public static void validateOperationIds(Set<Map.Entry<String, PathItem>> paths) throws BallerinaOpenApiException {
        ArrayList<String> errorList = new ArrayList<String>();
        for (Map.Entry<String, PathItem> entry : paths) {
            for (Map.Entry operation : entry.getValue().readOperationsMap().entrySet()) {
                if (((Operation)operation.getValue()).getOperationId() != null) {
                    String operationId = GeneratorUtils.getValidName(((Operation)operation.getValue()).getOperationId(), false);
                    ((Operation)operation.getValue()).setOperationId(operationId);
                    continue;
                }
                errorList.add(String.format("OperationId is missing in the resource path: '%s(%s)'", entry.getKey(), operation.getKey()));
            }
        }
        if (!errorList.isEmpty()) {
            throw new BallerinaOpenApiException("the configured generation mode requires operation ids for all operations: " + GeneratorConstants.LINE_SEPARATOR + String.join((CharSequence)GeneratorConstants.LINE_SEPARATOR, errorList));
        }
    }

    public static void validateRequestBody(Set<Map.Entry<String, PathItem>> paths) throws BallerinaOpenApiException {
        ArrayList<CallSite> errorList = new ArrayList<CallSite>();
        for (Map.Entry<String, PathItem> entry : paths) {
            if (entry.getValue().readOperationsMap().isEmpty()) continue;
            for (Map.Entry operation : entry.getValue().readOperationsMap().entrySet()) {
                String method = ((PathItem.HttpMethod)operation.getKey()).name().trim().toLowerCase(Locale.ENGLISH);
                boolean isRequestBodyInvalid = method.equals("get") || method.equals("head");
                if (!isRequestBodyInvalid || ((Operation)operation.getValue()).getRequestBody() == null) continue;
                errorList.add((CallSite)((Object)(method.toUpperCase(Locale.ENGLISH) + " operation cannot have a requestBody. Error at operationId: " + ((Operation)operation.getValue()).getOperationId())));
            }
        }
        if (!errorList.isEmpty()) {
            StringBuilder errorMessage = new StringBuilder("OpenAPI definition has errors: " + GeneratorConstants.LINE_SEPARATOR);
            for (String string : errorList) {
                errorMessage.append(string).append(GeneratorConstants.LINE_SEPARATOR);
            }
            throw new BallerinaOpenApiException(errorMessage.toString());
        }
    }

    public static String getOpenAPIType(Schema<?> schema) {
        if (schema.getTypes() != null && !schema.getTypes().isEmpty()) {
            for (String type : schema.getTypes()) {
                if (type.equals("null")) continue;
                return type;
            }
        } else if (schema.getType() != null) {
            return schema.getType();
        }
        return null;
    }

    public static boolean isArraySchema(Schema schema) {
        return GeneratorUtils.getOpenAPIType(schema) != null && Objects.equals(GeneratorUtils.getOpenAPIType(schema), "array");
    }

    public static boolean isMapSchema(Schema schema) {
        return schema.getAdditionalProperties() != null;
    }

    public static boolean isObjectSchema(Schema schema) {
        return GeneratorUtils.getOpenAPIType(schema) != null && Objects.equals(GeneratorUtils.getOpenAPIType(schema), "object");
    }

    public static boolean isComposedSchema(Schema schema) {
        return schema.getAnyOf() != null || schema.getOneOf() != null || schema.getAllOf() != null;
    }

    public static boolean isStringSchema(Schema<?> schema) {
        return GeneratorUtils.getOpenAPIType(schema) != null && Objects.equals(GeneratorUtils.getOpenAPIType(schema), "string");
    }

    public static boolean isBooleanSchema(Schema<?> schema) {
        return GeneratorUtils.getOpenAPIType(schema) != null && Objects.equals(GeneratorUtils.getOpenAPIType(schema), "boolean");
    }

    public static boolean isIntegerSchema(Schema<?> fieldSchema) {
        return Objects.equals(GeneratorUtils.getOpenAPIType(fieldSchema), "integer");
    }

    public static boolean isNumberSchema(Schema<?> fieldSchema) {
        return Objects.equals(GeneratorUtils.getOpenAPIType(fieldSchema), "number");
    }

    public static String resolveReferenceType(Schema<?> schema, Components components, boolean isWithoutDataBinding, String pathParam, List<Diagnostic> diagnostics) throws InvalidReferenceException, UnsupportedOASDataTypeException {
        String type = GeneratorUtils.extractReferenceType(schema.get$ref());
        if (isWithoutDataBinding) {
            Schema referencedSchema = (Schema)components.getSchemas().get(GeneratorUtils.escapeIdentifier(type));
            if (referencedSchema != null) {
                type = referencedSchema.get$ref() != null ? GeneratorUtils.resolveReferenceType(referencedSchema, components, isWithoutDataBinding, pathParam, diagnostics) : GeneratorUtils.getPathParameterType(referencedSchema, pathParam, diagnostics);
            }
        } else {
            type = GeneratorUtils.escapeIdentifier(type);
            TypeHandler.getInstance().getTypeNodeFromOASSchema(schema);
        }
        return type;
    }

    private static String getPathParameterType(Schema<?> typeSchema, String pathParam, List<Diagnostic> diagnostics) throws UnsupportedOASDataTypeException {
        String type = null;
        if (!(GeneratorUtils.isStringSchema(typeSchema) || GeneratorUtils.isNumberSchema(typeSchema) || GeneratorUtils.isBooleanSchema(typeSchema) || GeneratorUtils.isIntegerSchema(typeSchema))) {
            type = "string";
            CommonDiagnosticMessages unsupportedPath = CommonDiagnosticMessages.OAS_COMMON_204;
            CommonDiagnostic diagnostic = new CommonDiagnostic(unsupportedPath, pathParam);
            diagnostics.add(diagnostic);
        } else {
            type = GeneratorUtils.convertOpenAPITypeToBallerina(typeSchema, true);
        }
        return type;
    }

    public static List<String> getComplexPaths(OpenAPI openAPI) {
        ArrayList<String> complexPathList = new ArrayList<String>();
        if (openAPI.getPaths() != null) {
            for (Map.Entry path : openAPI.getPaths().entrySet()) {
                if (!GeneratorUtils.isComplexURL((String)path.getKey())) continue;
                complexPathList.add((String)path.getKey());
            }
        }
        return complexPathList;
    }

    public static String selectMediaType(String mediaTypeContent) {
        String[] contentTypes = mediaTypeContent.split(";");
        if (mediaTypeContent.length() > 1) {
            mediaTypeContent = contentTypes[0];
        }
        if (mediaTypeContent.matches("application/.*\\+json") || mediaTypeContent.matches(".*/json")) {
            mediaTypeContent = "application/json";
        } else if (mediaTypeContent.matches("application/.*\\+xml") || mediaTypeContent.matches(".*/xml")) {
            mediaTypeContent = "application/xml";
        } else if (mediaTypeContent.matches("text/.*")) {
            mediaTypeContent = "text";
        } else if (mediaTypeContent.matches("application/.*\\+octet-stream")) {
            mediaTypeContent = "application/octet-stream";
        } else if (mediaTypeContent.matches("application/.*\\+x-www-form-urlencoded")) {
            mediaTypeContent = "application/x-www-form-urlencoded";
        }
        return mediaTypeContent;
    }

    public static Schema getHeadersTypeSchema(ApiResponse apiResponse) {
        Map headers = apiResponse.getHeaders();
        if (Objects.isNull(headers)) {
            return null;
        }
        HashMap<String, Schema> properties = new HashMap<String, Schema>();
        ArrayList<String> requiredFields = new ArrayList<String>();
        for (Map.Entry headerEntry : headers.entrySet()) {
            String headerName = (String)headerEntry.getKey();
            Header header = (Header)headerEntry.getValue();
            Schema headerTypeSchema = GeneratorUtils.getValidatedHeaderSchema(header.getSchema());
            headerTypeSchema.setDescription(header.getDescription());
            headerTypeSchema.deprecated(header.getDeprecated());
            headerTypeSchema.extensions(header.getExtensions());
            properties.put(headerName, headerTypeSchema);
            if (header.getRequired() == null || !header.getRequired().booleanValue()) continue;
            requiredFields.add(headerName);
        }
        if (properties.isEmpty()) {
            return null;
        }
        ObjectSchema headersSchema = new ObjectSchema();
        headersSchema.setProperties(properties);
        if (!requiredFields.isEmpty()) {
            headersSchema.setRequired(requiredFields);
        }
        headersSchema.setAdditionalProperties((Object)false);
        return headersSchema;
    }

    public static Schema getValidatedHeaderSchema(Schema headerSchema) {
        return GeneratorUtils.getValidatedHeaderSchema(headerSchema, headerSchema);
    }

    private static Schema getValidatedHeaderSchema(Schema targetSchema, Schema originalSchema) {
        if (targetSchema instanceof StringSchema || targetSchema instanceof IntegerSchema || targetSchema instanceof BooleanSchema) {
            return originalSchema;
        }
        if (targetSchema instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)targetSchema;
            Schema items = arraySchema.getItems();
            return GeneratorUtils.getValidatedHeaderSchema(items, originalSchema);
        }
        return new StringSchema();
    }

    public static String replaceContentWithinBrackets(String input, String replacement) {
        Pattern pattern = Pattern.compile("[\\{\\[].*?[\\}\\]]");
        Matcher matcher = pattern.matcher(input);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        input = sb.toString();
        if (!input.startsWith(".")) {
            Pattern pattern2 = Pattern.compile("/(?=[^/]*[^a-zA-Z0-9_/])(.*?)(?=/)");
            Matcher matcher2 = pattern2.matcher(input);
            StringBuffer sb2 = new StringBuffer();
            while (matcher2.find()) {
                matcher2.appendReplacement(sb2, "/ZZZ");
            }
            matcher2.appendTail(sb2);
            return sb2.toString();
        }
        return input;
    }

    public static TypeDescriptorNode generateStatusCodeTypeInclusionRecord(String code, ApiResponse response, String method, OpenAPI openAPI, String path, List<Diagnostic> diagnosticList) throws InvalidReferenceException {
        Set bodyTypeSchema;
        Content responseContent = response.getContent();
        if (Objects.nonNull(responseContent)) {
            bodyTypeSchema = responseContent.entrySet();
        } else if (response.get$ref() != null) {
            String referenceType = GeneratorUtils.extractReferenceType(response.get$ref());
            ApiResponse apiResponse = (ApiResponse)openAPI.getComponents().getResponses().get(referenceType);
            bodyTypeSchema = apiResponse.getContent().entrySet();
        } else {
            bodyTypeSchema = new LinkedHashSet();
        }
        Schema headersTypeSchema = GeneratorUtils.getHeadersTypeSchema(response);
        LinkedHashMap<String, TypeDescriptorNode> generatedTypes = new LinkedHashMap<String, TypeDescriptorNode>();
        if (!code.equals("NoContent")) {
            for (Map.Entry mediaTypeEntry : bodyTypeSchema) {
                TypeDescriptorNode mediaTypeToken = GeneratorUtils.generateTypeDescForMediaType(openAPI, path, false, mediaTypeEntry);
                generatedTypes.put(mediaTypeToken.toString(), mediaTypeToken);
            }
        } else {
            if (!bodyTypeSchema.isEmpty()) {
                diagnosticList.add(new CommonDiagnostic(CommonDiagnosticMessages.OAS_COMMON_101, new String[0]));
            }
            return TypeHandler.getInstance().createTypeInclusionRecord(code, null, TypeHandler.getInstance().generateHeaderType(headersTypeSchema), method);
        }
        TypeDescriptorNode typeDescriptorNode = GeneratorUtils.getUnionTypeDescriptorNodeFromTypeDescNodes(generatedTypes);
        return TypeHandler.getInstance().createTypeInclusionRecord(code, typeDescriptorNode, TypeHandler.getInstance().generateHeaderType(headersTypeSchema), method);
    }

    public static TypeDescriptorNode generateTypeDescForMediaType(OpenAPI openAPI, String path, boolean isRequest, Map.Entry<String, MediaType> mediaTypeEntry) {
        TypeDescriptorNode mediaTypeToken;
        String mediaType;
        switch (mediaType = GeneratorUtils.selectMediaType(mediaTypeEntry.getKey().trim())) {
            case "application/json": {
                TypeDescriptorNode typeDescriptorNode;
                TypeDescriptorNode typeDescriptorNode2;
                if (mediaTypeEntry.getValue().getSchema() != null && (typeDescriptorNode2 = GeneratorUtils.generateTypeDescriptorForGenericMediaType(mediaTypeEntry, path, isRequest)) != null) {
                    typeDescriptorNode = typeDescriptorNode2;
                    break;
                }
                typeDescriptorNode = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"json"));
                break;
            }
            case "application/xml": {
                TypeDescriptorNode typeDescriptorNode = GeneratorUtils.generateTypeDescriptorForXMLContent();
                break;
            }
            case "application/x-www-form-urlencoded": {
                TypeDescriptorNode typeDescriptorNode = GeneratorUtils.generateTypeDescriptorForMapStringContent();
                break;
            }
            case "text": {
                TypeDescriptorNode typeDescriptorNode;
                if (mediaTypeEntry.getValue().getSchema() != null) {
                    typeDescriptorNode = GeneratorUtils.generateTypeDescriptorForGenericMediaType(mediaTypeEntry, path, isRequest);
                    break;
                }
                typeDescriptorNode = GeneratorUtils.getSimpleNameReferenceNode("string");
                break;
            }
            case "application/octet-stream": {
                TypeDescriptorNode typeDescriptorNode = GeneratorUtils.generateTypeDescriptorForOctetStreamContent();
                break;
            }
            default: {
                TypeDescriptorNode typeDescriptorNode = mediaTypeToken = null;
            }
        }
        if (mediaTypeToken == null) {
            mediaTypeToken = isRequest ? NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"http:Request")) : NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"anydata"));
        }
        return mediaTypeToken;
    }

    public static TypeDescriptorNode generateTypeDescriptorForXMLContent() {
        return GeneratorUtils.getSimpleNameReferenceNode("xml");
    }

    public static TypeDescriptorNode generateTypeDescriptorForMapStringContent() {
        return GeneratorUtils.getSimpleNameReferenceNode("map<string>");
    }

    private static TypeDescriptorNode generateTypeDescriptorForGenericMediaType(Map.Entry<String, MediaType> mediaTypeEntry, String path, boolean isRequest) {
        Schema schema = mediaTypeEntry.getValue().getSchema();
        TypeDescriptorNode typeDescNode = TypeHandler.getInstance().getTypeNodeFromOASSchema(schema).orElse(null);
        if (GeneratorUtils.isMapSchema(mediaTypeEntry.getValue().getSchema())) {
            String recordName = GeneratorUtils.getNewStatusCodeRecordName(path, isRequest);
            TypeHandler.getInstance().addTypeDefinitionNode(recordName, NodeFactory.createTypeDefinitionNode(null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)AbstractNodeFactory.createIdentifierToken((String)recordName), (Node)typeDescNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN)));
            typeDescNode = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)recordName));
        }
        return typeDescNode;
    }

    public static TypeDescriptorNode generateTypeDescriptorForOctetStreamContent() {
        ArrayDimensionNode dimensionNode = NodeFactory.createArrayDimensionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACKET_TOKEN), null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACKET_TOKEN));
        return NodeFactory.createArrayTypeDescriptorNode((TypeDescriptorNode)NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)"byte")), (NodeList)NodeFactory.createNodeList((Node[])new ArrayDimensionNode[]{dimensionNode}));
    }

    private static TypeDescriptorNode getSimpleNameReferenceNode(String typeName) {
        return NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)typeName));
    }

    private static String getNewStatusCodeRecordName(String path, boolean isRequest) {
        String typeSuffix;
        String pathRecord = Objects.equals(path, "/") || Objects.equals(path, "/*") ? "" : GeneratorUtils.getValidName(path, true);
        String recordName = pathRecord + (typeSuffix = isRequest ? "Request" : "Response");
        if (recordCountMap.containsKey(recordName)) {
            recordCountMap.put(recordName, recordCountMap.get(recordName) + 1);
            return recordName + "_" + String.valueOf(recordCountMap.get(recordName));
        }
        recordCountMap.put(recordName, 0);
        return recordName;
    }

    public static TypeDescriptorNode getUnionTypeDescriptorNodeFromTypeDescNodes(HashMap<String, TypeDescriptorNode> typeDescNodes) {
        if (typeDescNodes.isEmpty()) {
            return null;
        }
        List<TypeDescriptorNode> qualifiedNodeList = typeDescNodes.values().stream().toList();
        TypeDescriptorNode unionTypeDescriptorNode = qualifiedNodeList.get(0);
        for (int i = 1; i < qualifiedNodeList.size(); ++i) {
            TypeDescriptorNode rightTypeDesc = qualifiedNodeList.get(i);
            unionTypeDescriptorNode = NodeFactory.createUnionTypeDescriptorNode((TypeDescriptorNode)unionTypeDescriptorNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PIPE_TOKEN), (TypeDescriptorNode)rightTypeDesc);
        }
        return unionTypeDescriptorNode;
    }

    public static void addCommonParamsToOperationParams(Map.Entry<PathItem.HttpMethod, Operation> operation, OpenAPI openAPI, String path) {
        List parameters = operation.getValue().getParameters();
        List commonParameters = ((PathItem)openAPI.getPaths().get((Object)path)).getParameters();
        if (parameters == null) {
            operation.getValue().setParameters(commonParameters);
        } else if (commonParameters != null) {
            parameters.forEach(parameter -> {
                if (commonParameters.contains(parameter)) {
                    commonParameters.remove(parameter);
                }
            });
            parameters.addAll(commonParameters);
        }
    }

    public static String generateOperationUniqueId(Operation operation, String path, String method) {
        return Objects.nonNull(operation.getOperationId()) ? operation.getOperationId() : method + GeneratorUtils.getValidName(path, true);
    }

    public static MetadataNode getNameAnnotationMetadataNode(String fieldName, Schema fieldSchema) {
        String annotationType = GeneratorUtils.getAnnotationType(fieldSchema);
        AnnotationNode annotationNode = GeneratorUtils.getNameAnnotationNode(fieldName, annotationType);
        return NodeFactory.createMetadataNode(null, (NodeList)AbstractNodeFactory.createNodeList((Node[])new AnnotationNode[]{annotationNode}));
    }

    public static AnnotationNode getNameAnnotationNode(String fieldName, String annotationType) {
        TypeHandler.getInstance().addImport(annotationType.equals("jsondata:Name") ? JSONDATA_IMPORT : HTTP_IMPORT);
        SimpleNameReferenceNode annotType = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)annotationType));
        SpecificFieldNode nameField = NodeFactory.createSpecificFieldNode(null, (Node)AbstractNodeFactory.createIdentifierToken((String)(annotationType.equals("jsondata:Name") ? VALUE : NAME)), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (ExpressionNode)NodeFactory.createBasicLiteralNode((SyntaxKind)SyntaxKind.STRING_LITERAL, (Token)AbstractNodeFactory.createLiteralValueToken((SyntaxKind)SyntaxKind.STRING_LITERAL_TOKEN, (String)("\"" + fieldName + "\""), (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList(), (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList())));
        MappingConstructorExpressionNode recExp = NodeFactory.createMappingConstructorExpressionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[]{nameField}), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
        return NodeFactory.createAnnotationNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.AT_TOKEN), (Node)annotType, (MappingConstructorExpressionNode)recExp);
    }

    private static String getAnnotationType(Schema schema) {
        Object object;
        Map extensions = schema.getExtensions();
        if (Objects.isNull(extensions) || Objects.isNull(extensions.get("x-param-type")) || !((object = extensions.get("x-param-type")) instanceof String)) {
            return "jsondata:Name";
        }
        String type = (String)object;
        return switch (type) {
            case "query" -> "http:Query";
            case "header" -> "http:Header";
            default -> "jsondata:Name";
        };
    }

    static {
        primitiveTypeList = new ArrayList<String>(Arrays.asList("integer", "number", "string", "boolean"));
    }
}

