/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.document;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.IncludedRecordParameterNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationNode;
import io.ballerina.compiler.syntax.tree.MarkdownParameterDocumentationLineNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.exception.BallerinaOpenApiException;
import io.ballerina.openapi.core.generators.common.exception.InvalidReferenceException;
import io.ballerina.openapi.core.generators.document.DocCommentsGenerator;
import io.ballerina.openapi.core.generators.document.DocCommentsGeneratorUtil;
import io.ballerina.openapi.core.generators.document.OperationDetails;
import io.ballerina.openapi.core.generators.type.model.GeneratorMetaData;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ClientDocCommentGenerator
implements DocCommentsGenerator {
    OpenAPI openAPI;
    SyntaxTree syntaxTree;
    boolean isResource;

    public ClientDocCommentGenerator(SyntaxTree syntaxTree, OpenAPI openAPI, boolean isResource) {
        this.openAPI = openAPI;
        this.syntaxTree = syntaxTree;
        this.isResource = isResource;
    }

    @Override
    public SyntaxTree updateSyntaxTreeWithDocComments() {
        HashMap<String, OperationDetails> operationDetailsMap = new HashMap<String, OperationDetails>();
        Paths paths = this.openAPI.getPaths();
        this.extractOperations(operationDetailsMap, paths);
        Node rootNode = this.syntaxTree.rootNode();
        ModulePartNode modulePartNode = (ModulePartNode)rootNode;
        NodeList members = modulePartNode.members();
        ArrayList updatedMembers = new ArrayList();
        members.forEach(member -> {
            if (member.kind().equals((Object)SyntaxKind.CLASS_DEFINITION)) {
                ClassDefinitionNode classDef = (ClassDefinitionNode)member;
                LinkedList updatedList = new LinkedList();
                NodeList classMembers = classDef.members();
                classMembers.forEach(classMember -> {
                    if (classMember.kind().equals((Object)SyntaxKind.OBJECT_METHOD_DEFINITION) || classMember.kind().equals((Object)SyntaxKind.RESOURCE_ACCESSOR_DEFINITION)) {
                        FunctionDefinitionNode funcDef = (FunctionDefinitionNode)classMember;
                        if (this.isResource) {
                            NodeList nodes = funcDef.relativeResourcePath();
                            StringBuilder path = new StringBuilder();
                            for (Node node : nodes) {
                                path.append(DocCommentsGeneratorUtil.unescapeIdentifier(node.toString().replace("\"", "")));
                            }
                            String key = GeneratorUtils.replaceContentWithinBrackets(path.toString(), "XXX") + "_" + funcDef.functionName().text();
                            funcDef = this.updateDocCommentsForFunctionNode(operationDetailsMap, funcDef, key);
                        } else {
                            String key = funcDef.functionName().text();
                            funcDef = this.updateDocCommentsForFunctionNode(operationDetailsMap, funcDef, key);
                        }
                        classMember = funcDef;
                    }
                    updatedList.add(classMember);
                });
                classDef = classDef.modify((MetadataNode)classDef.metadata().orElse(null), (Token)classDef.visibilityQualifier().orElse(null), classDef.classTypeQualifiers(), classDef.classKeyword(), classDef.className(), classDef.openBrace(), updatedList.isEmpty() ? classDef.members() : AbstractNodeFactory.createNodeList(updatedList), classDef.closeBrace(), (Token)classDef.semicolonToken().orElse(null));
                member = classDef;
            }
            updatedMembers.add(member);
            NodeList clientMembers = AbstractNodeFactory.createNodeList((Collection)updatedMembers);
            ModulePartNode updatedmodulePartNode = modulePartNode.modify(modulePartNode.imports(), clientMembers, modulePartNode.eofToken());
            this.syntaxTree = this.syntaxTree.modifyWith((Node)updatedmodulePartNode);
        });
        return this.syntaxTree;
    }

    private void extractOperations(HashMap<String, OperationDetails> operationDetailsMap, Paths paths) {
        paths.forEach((path, pathItem) -> {
            for (Map.Entry entry : pathItem.readOperationsMap().entrySet()) {
                PathItem.HttpMethod method = (PathItem.HttpMethod)entry.getKey();
                Operation operation = (Operation)entry.getValue();
                if (!this.isResource) {
                    operationDetailsMap.put(operation.getOperationId(), new OperationDetails(operation.getOperationId(), operation, (String)path, method.name()));
                    continue;
                }
                path = path.equals("/") ? "." : path;
                String key = GeneratorUtils.replaceContentWithinBrackets(path.replaceFirst("/", ""), "XXX") + "_" + method.name().toLowerCase(Locale.ENGLISH);
                operationDetailsMap.put(key, new OperationDetails(operation.getOperationId(), operation, (String)path, method.name()));
            }
        });
    }

    private FunctionDefinitionNode updateDocCommentsForFunctionNode(HashMap<String, OperationDetails> operationDetailsMap, FunctionDefinitionNode funcDef, String key) {
        OperationDetails operationDetails = operationDetailsMap.get(key);
        if (operationDetails != null) {
            MetadataNode metadataNode;
            ApiResponse response;
            Optional<String> responseDescription;
            ApiResponses responses;
            Collection values;
            Iterator iteratorRes;
            ArrayList<Node> docs = new ArrayList<Node>();
            ArrayList<AnnotationNode> annotations = new ArrayList<AnnotationNode>();
            Operation operation = operationDetails.operation();
            if (operation.getSummary() != null) {
                docs.addAll(DocCommentsGeneratorUtil.createAPIDescriptionDoc(operation.getSummary(), true));
            } else if (operation.getDescription() != null) {
                docs.addAll(DocCommentsGeneratorUtil.createAPIDescriptionDoc(operation.getDescription(), true));
            }
            if (operation.getExtensions() != null) {
                DocCommentsGeneratorUtil.extractDisplayAnnotation(operation.getExtensions(), annotations);
            }
            FunctionSignatureNode functionSignatureNode = funcDef.functionSignature();
            if (operation.getParameters() != null) {
                SeparatedNodeList parameters = functionSignatureNode.parameters();
                ArrayList<Node> updatedParamsRequired = new ArrayList<Node>();
                ArrayList<Node> updatedParamsDefault = new ArrayList<Node>();
                ArrayList updatedIncludedParam = new ArrayList();
                HashMap<String, ParameterNode> collection = ClientDocCommentGenerator.getParameterNodeHashMap((SeparatedNodeList<ParameterNode>)parameters);
                ClientDocCommentGenerator.updateParameterNodes(docs, this.openAPI, operation, updatedParamsRequired, updatedParamsDefault, collection);
                if (collection.size() > 0) {
                    collection.forEach((keyParam, value) -> {
                        if (value instanceof RequiredParameterNode) {
                            RequiredParameterNode reParam = (RequiredParameterNode)value;
                            updatedParamsRequired.add((Node)reParam);
                            updatedParamsRequired.add((Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
                        } else if (value instanceof DefaultableParameterNode) {
                            DefaultableParameterNode deParam = (DefaultableParameterNode)value;
                            updatedParamsDefault.add((Node)deParam);
                            updatedParamsDefault.add((Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
                        } else if (value instanceof IncludedRecordParameterNode) {
                            IncludedRecordParameterNode incParam = (IncludedRecordParameterNode)value;
                            updatedIncludedParam.add(incParam);
                            updatedIncludedParam.add(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
                        }
                    });
                }
                updatedParamsRequired.addAll(updatedParamsDefault);
                updatedParamsRequired.addAll(updatedIncludedParam);
                if (!updatedParamsRequired.isEmpty()) {
                    if (updatedParamsRequired.get(updatedParamsRequired.size() - 1) instanceof Token) {
                        updatedParamsRequired.remove(updatedParamsRequired.size() - 1);
                    }
                    functionSignatureNode = functionSignatureNode.modify(functionSignatureNode.openParenToken(), AbstractNodeFactory.createSeparatedNodeList(updatedParamsRequired), functionSignatureNode.closeParenToken(), (ReturnTypeDescriptorNode)functionSignatureNode.returnTypeDesc().orElse(null));
                }
            } else {
                docs.add((Node)DocCommentsGeneratorUtil.createAPIParamDoc("headers", "Headers to be sent with the request"));
            }
            RequestBody requestBody = operation.getRequestBody();
            if (requestBody != null) {
                this.addRequestBodyDoc(docs, requestBody);
            }
            if (operation.getResponses() != null && (iteratorRes = (values = (responses = operation.getResponses()).values()).iterator()).hasNext() && (responseDescription = DocCommentsGeneratorUtil.getResponseDescription(response = (ApiResponse)iteratorRes.next(), this.openAPI.getComponents())).isPresent()) {
                MarkdownParameterDocumentationLineNode returnDoc = DocCommentsGeneratorUtil.createAPIParamDoc("return", responseDescription.get());
                docs.add((Node)returnDoc);
            }
            if (operation.getDeprecated() != null && operation.getDeprecated().booleanValue()) {
                DocCommentsGeneratorUtil.extractDeprecatedAnnotation(operation.getExtensions(), docs, annotations);
            }
            MarkdownDocumentationNode documentationNode = NodeFactory.createMarkdownDocumentationNode((NodeList)AbstractNodeFactory.createNodeList(docs));
            Optional metadata = funcDef.metadata();
            metadataNode = metadata.isEmpty() ? NodeFactory.createMetadataNode((Node)documentationNode, (NodeList)AbstractNodeFactory.createNodeList(annotations)) : NodeFactory.createMetadataNode((Node)documentationNode, (NodeList)((metadataNode = (MetadataNode)metadata.get()).annotations().isEmpty() ? AbstractNodeFactory.createNodeList(annotations) : metadataNode.annotations().addAll(annotations)));
            funcDef = funcDef.modify(funcDef.kind(), metadataNode, funcDef.qualifierList(), funcDef.functionKeyword(), funcDef.functionName(), funcDef.relativeResourcePath(), functionSignatureNode, funcDef.functionBody());
        }
        return funcDef;
    }

    private void addRequestBodyDoc(List<Node> docs, RequestBody requestBody) {
        if (requestBody.get$ref() != null) {
            try {
                requestBody = (RequestBody)this.openAPI.getComponents().getRequestBodies().get(GeneratorUtils.extractReferenceType(requestBody.get$ref()));
            }
            catch (BallerinaOpenApiException e) {
                requestBody = new RequestBody();
            }
        }
        Content content = requestBody.getContent();
        String[] paramName = new String[]{"http:Request"};
        if (content != null) {
            content.entrySet().stream().findFirst().ifPresent(mediaType -> {
                paramName[0] = GeneratorUtils.getBallerinaMediaType((String)mediaType.getKey(), true);
            });
        } else {
            paramName[0] = "http:Request";
        }
        Optional<String> requestBodyDescription = DocCommentsGeneratorUtil.getRequestBodyDescription(requestBody, this.openAPI.getComponents());
        if (requestBodyDescription.isPresent()) {
            String description = requestBodyDescription.get().split("\n")[0];
            docs.add((Node)DocCommentsGeneratorUtil.createAPIParamDoc(paramName[0].equals("http:Request") ? "request" : "payload", description));
        }
    }

    private static void updateParameterNodes(List<Node> docs, OpenAPI openAPI, Operation operation, List<Node> updatedParamsRequired, List<Node> updatedParamsDefault, HashMap<String, ParameterNode> collection) {
        ArrayList deprecatedParamDocComments = new ArrayList();
        boolean hasQueryParams = operation.getParameters().stream().anyMatch(parameter -> parameter.getIn().equals("query"));
        operation.getParameters().forEach(parameter -> {
            if (parameter.get$ref() != null) {
                try {
                    parameter = (Parameter)GeneratorMetaData.getInstance().getOpenAPI().getComponents().getParameters().get(GeneratorUtils.extractReferenceType(parameter.get$ref()));
                }
                catch (InvalidReferenceException e) {
                    return;
                }
            }
            if (Objects.isNull(parameter.getIn()) || !parameter.getIn().equals("path")) {
                return;
            }
            ArrayList<AnnotationNode> paramAnnot = new ArrayList<AnnotationNode>();
            String parameterName = GeneratorUtils.escapeIdentifier(parameter.getName());
            if (parameter.getDeprecated() != null && parameter.getDeprecated().booleanValue()) {
                DocCommentsGeneratorUtil.extractDeprecatedAnnotationDetails(deprecatedParamDocComments, parameter, paramAnnot);
            }
            if (parameter.getExtensions() != null) {
                DocCommentsGeneratorUtil.extractDisplayAnnotation(parameter.getExtensions(), paramAnnot);
            }
            ParameterNode parameterNode = (ParameterNode)collection.get(parameterName);
            DocCommentsGeneratorUtil.updatedAnnotationInParameterNode(updatedParamsRequired, updatedParamsDefault, paramAnnot, parameterNode);
            collection.remove(parameterName);
            DocCommentsGeneratorUtil.getParameterDescription(parameter, openAPI.getComponents()).ifPresent(s -> docs.add((Node)DocCommentsGeneratorUtil.createAPIParamDocFromString(parameterName, s)));
        });
        docs.add((Node)DocCommentsGeneratorUtil.createAPIParamDoc("headers", "Headers to be sent with the request"));
        if (hasQueryParams) {
            docs.add((Node)DocCommentsGeneratorUtil.createAPIParamDoc("queries", "Queries to be sent with the request"));
        }
        docs.addAll(deprecatedParamDocComments);
    }

    private static HashMap<String, ParameterNode> getParameterNodeHashMap(SeparatedNodeList<ParameterNode> parameters) {
        HashMap<String, ParameterNode> collection = new HashMap<String, ParameterNode>();
        for (ParameterNode node : parameters) {
            if (node instanceof RequiredParameterNode) {
                RequiredParameterNode reParam = (RequiredParameterNode)node;
                collection.put(((Token)reParam.paramName().get()).toString(), (ParameterNode)reParam);
                continue;
            }
            if (node instanceof DefaultableParameterNode) {
                DefaultableParameterNode deParam = (DefaultableParameterNode)node;
                collection.put(((Token)deParam.paramName().get()).toString(), (ParameterNode)deParam);
                continue;
            }
            if (!(node instanceof IncludedRecordParameterNode)) continue;
            IncludedRecordParameterNode incParam = (IncludedRecordParameterNode)node;
            collection.put(((Token)incParam.paramName().get()).toString(), (ParameterNode)incParam);
        }
        return collection;
    }
}

