/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.document;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationLineNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationNode;
import io.ballerina.compiler.syntax.tree.MarkdownParameterDocumentationLineNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.exception.InvalidReferenceException;
import io.ballerina.runtime.api.utils.IdentifierUtils;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DocCommentsGeneratorUtil {
    public static void extractDisplayAnnotation(Map<String, Object> extensions, List<AnnotationNode> annotationNodes) {
        if (extensions != null) {
            for (Map.Entry<String, Object> extension : extensions.entrySet()) {
                if (!extension.getKey().trim().equals("x-ballerina-display")) continue;
                annotationNodes.add(DocCommentsGeneratorUtil.getAnnotationNode(extension));
            }
        }
    }

    public static void extractDeprecatedAnnotation(Map<String, Object> extensions, List<Node> documentation, List<AnnotationNode> annotationNodes) {
        AnnotationNode deprecatedAnnotation = NodeFactory.createAnnotationNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.AT_TOKEN), (Node)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"deprecated")), null);
        if (documentation.size() > 0) {
            documentation.addAll(DocCommentsGeneratorUtil.createAPIDescriptionDoc("\n# Deprecated", false));
            if (extensions != null && extensions.entrySet().size() > 0) {
                for (Map.Entry<String, Object> next : extensions.entrySet()) {
                    if (!next.getKey().equals("x-ballerina-deprecated-reason")) continue;
                    documentation.addAll(DocCommentsGeneratorUtil.createAPIDescriptionDoc(next.getValue().toString(), false));
                }
            }
        }
        annotationNodes.add(deprecatedAnnotation);
    }

    private static AnnotationNode getAnnotationNode(Map.Entry<String, Object> extension) {
        LinkedHashMap extFields = (LinkedHashMap)extension.getValue();
        ArrayList<Object> annotFields = new ArrayList<Object>();
        if (!extFields.isEmpty()) {
            for (Map.Entry field : extFields.entrySet()) {
                BasicLiteralNode valueExpr = NodeFactory.createBasicLiteralNode((SyntaxKind)SyntaxKind.STRING_LITERAL, (Token)AbstractNodeFactory.createLiteralValueToken((SyntaxKind)SyntaxKind.STRING_LITERAL_TOKEN, (String)("\"" + ((String)field.getValue()).trim() + "\""), (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList(), (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList()));
                SpecificFieldNode fields = NodeFactory.createSpecificFieldNode(null, (Node)AbstractNodeFactory.createIdentifierToken((String)((String)field.getKey()).trim()), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (ExpressionNode)valueExpr);
                annotFields.add(fields);
                annotFields.add(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
            }
            annotFields.remove(annotFields.size() - 1);
        }
        MappingConstructorExpressionNode annotValue = NodeFactory.createMappingConstructorExpressionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList(annotFields), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
        SimpleNameReferenceNode annotateReference = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"display"));
        return NodeFactory.createAnnotationNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.AT_TOKEN), (Node)annotateReference, (MappingConstructorExpressionNode)annotValue);
    }

    public static List<MarkdownDocumentationLineNode> createAPIDescriptionDoc(String description, boolean addExtraLine) {
        String[] descriptionLines = description.split("\n");
        ArrayList<MarkdownDocumentationLineNode> documentElements = new ArrayList<MarkdownDocumentationLineNode>();
        Token hashToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.HASH_TOKEN, (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList(), (MinutiaeList)GeneratorUtils.SINGLE_WS_MINUTIAE);
        for (String line : descriptionLines) {
            MarkdownDocumentationLineNode documentationLineNode = NodeFactory.createMarkdownDocumentationLineNode((SyntaxKind)SyntaxKind.MARKDOWN_DOCUMENTATION_LINE, (Token)hashToken, (NodeList)AbstractNodeFactory.createNodeList((Node[])new Node[]{AbstractNodeFactory.createLiteralValueToken((SyntaxKind)SyntaxKind.DOCUMENTATION_DESCRIPTION, (String)line, (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList(), (MinutiaeList)GeneratorUtils.SINGLE_END_OF_LINE_MINUTIAE)}));
            documentElements.add(documentationLineNode);
        }
        if (addExtraLine) {
            MarkdownDocumentationLineNode newLine = NodeFactory.createMarkdownDocumentationLineNode((SyntaxKind)SyntaxKind.MARKDOWN_DOCUMENTATION_LINE, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.HASH_TOKEN), (NodeList)AbstractNodeFactory.createEmptyNodeList());
            documentElements.add(newLine);
        }
        return documentElements;
    }

    public static MarkdownDocumentationNode createAPIParamDocFromString(String paramName, String description) {
        String[] paramDescriptionLines = description.split("\n");
        StringBuilder docComment = new StringBuilder("# + " + paramName + " - " + paramDescriptionLines[0] + System.lineSeparator());
        for (int i = 1; i < paramDescriptionLines.length; ++i) {
            String line = paramDescriptionLines[i].replaceAll("[\\r\\n\\t]", "");
            if (line.isBlank()) continue;
            docComment.append("# ").append(line).append(System.lineSeparator());
        }
        docComment.append(System.lineSeparator()).append("type a A;");
        ModuleMemberDeclarationNode moduleMemberDeclarationNode = NodeParser.parseModuleMemberDeclaration((String)docComment.toString());
        TypeDefinitionNode typeDefinitionNode = (TypeDefinitionNode)moduleMemberDeclarationNode;
        MetadataNode metadataNode = (MetadataNode)typeDefinitionNode.metadata().get();
        return (MarkdownDocumentationNode)metadataNode.children().get(0);
    }

    public static MarkdownParameterDocumentationLineNode createAPIParamDoc(String paramName, String description) {
        String[] paramDescriptionLines = description.split("\n");
        ArrayList<IdentifierToken> documentElements = new ArrayList<IdentifierToken>();
        for (String line : paramDescriptionLines) {
            if (line.isBlank()) continue;
            documentElements.add(AbstractNodeFactory.createIdentifierToken((String)(line + " ")));
        }
        return NodeFactory.createMarkdownParameterDocumentationLineNode(null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.HASH_TOKEN), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PLUS_TOKEN), (Token)AbstractNodeFactory.createIdentifierToken((String)paramName), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.MINUS_TOKEN), (NodeList)AbstractNodeFactory.createNodeList(documentElements));
    }

    public static void extractDeprecatedAnnotationDetails(List<Node> deprecatedParamDocComments, Parameter parameter, List<AnnotationNode> paramAnnot) {
        deprecatedParamDocComments.addAll(DocCommentsGeneratorUtil.createAPIDescriptionDoc("# Deprecated parameters", false));
        String deprecatedDescription = "";
        if (parameter.getExtensions() != null) {
            for (Map.Entry extension : parameter.getExtensions().entrySet()) {
                if (!((String)extension.getKey()).trim().equals("x-ballerina-deprecated-reason")) continue;
                deprecatedDescription = extension.getValue().toString();
                break;
            }
        }
        MarkdownParameterDocumentationLineNode paramAPIDoc = DocCommentsGeneratorUtil.createAPIParamDoc(GeneratorUtils.escapeIdentifier(parameter.getName()), deprecatedDescription);
        deprecatedParamDocComments.add((Node)paramAPIDoc);
        paramAnnot.add(NodeFactory.createAnnotationNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.AT_TOKEN), (Node)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"deprecated")), null));
    }

    public static void updatedAnnotationInParameterNode(List<Node> updatedParamsRequired, List<Node> updatedParamsDefault, List<AnnotationNode> paramAnnot, ParameterNode parameterNode) {
        if (parameterNode != null) {
            if (parameterNode instanceof RequiredParameterNode) {
                RequiredParameterNode reParam;
                updatedParamsRequired.add((Node)reParam.modify((reParam = (RequiredParameterNode)parameterNode).annotations().isEmpty() ? AbstractNodeFactory.createNodeList(paramAnnot) : reParam.annotations().addAll(paramAnnot), reParam.typeName(), (Token)reParam.paramName().orElse(null)));
                updatedParamsRequired.add((Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
            } else if (parameterNode instanceof DefaultableParameterNode) {
                DefaultableParameterNode deParam;
                updatedParamsDefault.add((Node)deParam.modify((deParam = (DefaultableParameterNode)parameterNode).annotations().isEmpty() ? AbstractNodeFactory.createNodeList(paramAnnot) : deParam.annotations().addAll(paramAnnot), deParam.typeName(), (Token)deParam.paramName().orElse(null), deParam.equalsToken(), deParam.expression()));
                updatedParamsDefault.add((Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
            }
        }
    }

    public static Optional<String> getSchemaDescription(Schema<?> schema, Components components) {
        if (Objects.nonNull(schema.getDescription()) && !schema.getDescription().isBlank()) {
            return Optional.of(schema.getDescription());
        }
        if (Objects.isNull(schema.get$ref())) {
            return Optional.empty();
        }
        try {
            String refName = GeneratorUtils.extractReferenceType(schema.get$ref());
            String refSection = GeneratorUtils.extractReferenceSection(schema.get$ref());
            return DocCommentsGeneratorUtil.getDescriptionFromReference(refName, refSection, components);
        }
        catch (InvalidReferenceException exp) {
            return Optional.empty();
        }
    }

    public static Optional<String> getParameterDescription(Parameter parameter, Components components) {
        if (Objects.nonNull(parameter.getDescription()) && !parameter.getDescription().isBlank()) {
            return Optional.of(parameter.getDescription());
        }
        if (Objects.isNull(parameter.get$ref())) {
            return Optional.empty();
        }
        try {
            String refName = GeneratorUtils.extractReferenceType(parameter.get$ref());
            String refSection = GeneratorUtils.extractReferenceSection(parameter.get$ref());
            return DocCommentsGeneratorUtil.getDescriptionFromReference(refName, refSection, components);
        }
        catch (InvalidReferenceException exp) {
            return Optional.empty();
        }
    }

    public static Optional<String> getResponseDescription(ApiResponse response, Components components) {
        if (Objects.nonNull(response.getDescription()) && !response.getDescription().isBlank()) {
            return Optional.of(response.getDescription());
        }
        if (Objects.isNull(response.get$ref())) {
            return Optional.empty();
        }
        try {
            String refName = GeneratorUtils.extractReferenceType(response.get$ref());
            String refSection = GeneratorUtils.extractReferenceSection(response.get$ref());
            return DocCommentsGeneratorUtil.getDescriptionFromReference(refName, refSection, components);
        }
        catch (InvalidReferenceException exp) {
            return Optional.empty();
        }
    }

    public static Optional<String> getRequestBodyDescription(RequestBody requestBody, Components components) {
        if (Objects.nonNull(requestBody.getDescription()) && !requestBody.getDescription().isBlank()) {
            return Optional.of(requestBody.getDescription());
        }
        if (Objects.isNull(requestBody.get$ref())) {
            return Optional.empty();
        }
        try {
            String refName = GeneratorUtils.extractReferenceType(requestBody.get$ref());
            String refSection = GeneratorUtils.extractReferenceSection(requestBody.get$ref());
            return DocCommentsGeneratorUtil.getDescriptionFromReference(refName, refSection, components);
        }
        catch (InvalidReferenceException exp) {
            return Optional.empty();
        }
    }

    private static Optional<String> getDescriptionFromReference(String refName, String refSection, Components components) throws InvalidReferenceException {
        if (Objects.isNull(components)) {
            return Optional.empty();
        }
        switch (refSection) {
            case "schemas": {
                if (!Objects.nonNull(components.getSchemas()) || !components.getSchemas().containsKey(refName)) break;
                return DocCommentsGeneratorUtil.getSchemaDescription((Schema)components.getSchemas().get(refName), components);
            }
            case "parameters": {
                if (!Objects.nonNull(components.getParameters()) || !components.getParameters().containsKey(refName)) break;
                return DocCommentsGeneratorUtil.getParameterDescription((Parameter)components.getParameters().get(refName), components);
            }
            case "responses": {
                if (!Objects.nonNull(components.getResponses()) || !components.getResponses().containsKey(refName)) break;
                return DocCommentsGeneratorUtil.getResponseDescription((ApiResponse)components.getResponses().get(refName), components);
            }
            case "requestBodies": {
                if (!Objects.nonNull(components.getRequestBodies()) || !components.getRequestBodies().containsKey(refName)) break;
                return DocCommentsGeneratorUtil.getRequestBodyDescription((RequestBody)components.getRequestBodies().get(refName), components);
            }
        }
        return Optional.empty();
    }

    public static String unescapeIdentifier(String parameterName) {
        String unescapedParamName = IdentifierUtils.unescapeBallerina((String)parameterName);
        return unescapedParamName.replaceAll("\\\\", "").replaceAll("'", "");
    }
}

