/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.document;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.RecordFieldNode;
import io.ballerina.compiler.syntax.tree.RecordFieldWithDefaultValueNode;
import io.ballerina.compiler.syntax.tree.RecordRestDescriptorNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.document.DocCommentsGenerator;
import io.ballerina.openapi.core.generators.document.DocCommentsGeneratorUtil;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TypesDocCommentGenerator
implements DocCommentsGenerator {
    OpenAPI openAPI;
    SyntaxTree syntaxTree;

    public TypesDocCommentGenerator(SyntaxTree syntaxTree, OpenAPI openAPI) {
        this.openAPI = openAPI;
        this.syntaxTree = syntaxTree;
    }

    @Override
    public SyntaxTree updateSyntaxTreeWithDocComments() {
        if (this.openAPI.getComponents() == null) {
            return this.syntaxTree;
        }
        Node rootNode = this.syntaxTree.rootNode();
        Map schemas = this.openAPI.getComponents().getSchemas();
        ModulePartNode modulePartNode = (ModulePartNode)rootNode;
        NodeList members = modulePartNode.members();
        ArrayList updatedMemberTypesList = new ArrayList();
        members.stream().forEach(member -> {
            if (!(member instanceof TypeDefinitionNode)) {
                updatedMemberTypesList.add(member);
                return;
            }
            TypeDefinitionNode typeDef = (TypeDefinitionNode)member;
            TypeDefinitionNode finalTypeDef = typeDef;
            if (schemas == null) {
                updatedMemberTypesList.add(typeDef);
                return;
            }
            Schema schema = schemas.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(finalTypeDef.typeName().text())).map(Map.Entry::getValue).findAny().orElse(null);
            if (schema != null) {
                if (finalTypeDef.typeDescriptor().kind().equals((Object)SyntaxKind.RECORD_TYPE_DESC)) {
                    ArrayList<Node> updatedFields = new ArrayList<Node>();
                    RecordTypeDescriptorNode record = (RecordTypeDescriptorNode)finalTypeDef.typeDescriptor();
                    NodeList fields = record.fields();
                    if (schema instanceof ComposedSchema) {
                        ComposedSchema composedSchema = (ComposedSchema)schema;
                        List allOf = composedSchema.getAllOf();
                        HashMap properties = new HashMap();
                        if (allOf != null) {
                            for (Schema allOfSchema : allOf) {
                                if (allOfSchema.getProperties() == null) continue;
                                properties.putAll(allOfSchema.getProperties());
                            }
                        }
                        schema.setProperties(properties);
                    }
                    TypesDocCommentGenerator.updateRecordFields(schema, updatedFields, (NodeList<Node>)fields, this.openAPI);
                    typeDef = typeDef.modify((MetadataNode)typeDef.metadata().orElse(null), (Token)typeDef.visibilityQualifier().get(), typeDef.typeKeyword(), typeDef.typeName(), (Node)NodeFactory.createRecordTypeDescriptorNode((Token)record.recordKeyword(), (Token)record.bodyStartDelimiter(), (NodeList)(updatedFields.isEmpty() ? fields : AbstractNodeFactory.createNodeList(updatedFields)), (RecordRestDescriptorNode)record.recordRestDescriptor().orElse(null), (Token)record.bodyEndDelimiter()), typeDef.semicolonToken());
                }
                Optional metadata = typeDef.metadata();
                Optional<String> schemaDescription = DocCommentsGeneratorUtil.getSchemaDescription(schema, this.openAPI.getComponents());
                if (schemaDescription.isPresent() || Objects.nonNull(schema.getDeprecated())) {
                    MetadataNode metadataNode = TypesDocCommentGenerator.updateMetadataNode(metadata, schema, schemaDescription);
                    typeDef = typeDef.modify(metadataNode, (Token)typeDef.visibilityQualifier().get(), typeDef.typeKeyword(), typeDef.typeName(), typeDef.typeDescriptor(), typeDef.semicolonToken());
                }
                updatedMemberTypesList.add(typeDef);
            } else {
                updatedMemberTypesList.add(typeDef);
            }
        });
        NodeList updatedMembers = AbstractNodeFactory.createNodeList((Node[])updatedMemberTypesList.toArray(new ModuleMemberDeclarationNode[updatedMemberTypesList.size()]));
        modulePartNode = modulePartNode.modify(modulePartNode.imports(), updatedMembers, modulePartNode.eofToken());
        return this.syntaxTree.modifyWith((Node)modulePartNode);
    }

    private static void updateRecordFields(Schema<?> schema, List<Node> updatedFields, NodeList<Node> fields, OpenAPI openAPI) {
        if (schema.getProperties() != null) {
            for (Node field : fields) {
                boolean isUpdated = false;
                for (Map.Entry<String, Schema> entry : schema.getProperties().entrySet()) {
                    RecordFieldWithDefaultValueNode recordFieldWithDefaultValueNode;
                    Optional<String> valueDescription;
                    String key = TypesDocCommentGenerator.getKey(entry);
                    Schema value = entry.getValue();
                    if (field instanceof RecordFieldNode) {
                        RecordFieldNode recordFieldNode = (RecordFieldNode)field;
                        if (recordFieldNode.fieldName().text().trim().equals(key) && ((valueDescription = DocCommentsGeneratorUtil.getSchemaDescription(value, openAPI.getComponents())).isPresent() || Objects.nonNull(value.getDeprecated()))) {
                            metadata = recordFieldNode.metadata();
                            metadataNode = TypesDocCommentGenerator.updateMetadataNode(metadata, value, valueDescription);
                            recordFieldNode = recordFieldNode.modify(metadataNode, (Token)recordFieldNode.readonlyKeyword().orElse(null), recordFieldNode.typeName(), recordFieldNode.fieldName(), (Token)recordFieldNode.questionMarkToken().orElse(null), recordFieldNode.semicolonToken());
                            updatedFields.add((Node)recordFieldNode);
                            isUpdated = true;
                        }
                    } else if (field instanceof RecordFieldWithDefaultValueNode && (recordFieldWithDefaultValueNode = (RecordFieldWithDefaultValueNode)field).fieldName().text().trim().equals(key) && ((valueDescription = DocCommentsGeneratorUtil.getSchemaDescription(value, openAPI.getComponents())).isPresent() || Objects.nonNull(value.getDeprecated()))) {
                        metadata = recordFieldWithDefaultValueNode.metadata();
                        metadataNode = TypesDocCommentGenerator.updateMetadataNode(metadata, value, valueDescription);
                        recordFieldWithDefaultValueNode = recordFieldWithDefaultValueNode.modify(metadataNode, (Token)recordFieldWithDefaultValueNode.readonlyKeyword().orElse(null), recordFieldWithDefaultValueNode.typeName(), recordFieldWithDefaultValueNode.fieldName(), recordFieldWithDefaultValueNode.equalsToken(), recordFieldWithDefaultValueNode.expression(), recordFieldWithDefaultValueNode.semicolonToken());
                        updatedFields.add((Node)recordFieldWithDefaultValueNode);
                        isUpdated = true;
                    }
                    if (!isUpdated) continue;
                    break;
                }
                if (isUpdated) continue;
                updatedFields.add(field);
            }
        }
    }

    private static String getKey(Map.Entry<String, Schema> entry) {
        return GeneratorUtils.getBallerinaNameExtension(entry.getValue()).orElse(GeneratorUtils.escapeIdentifier(entry.getKey()));
    }

    private static MetadataNode updateMetadataNode(Optional<MetadataNode> metadata, Schema<?> schema, Optional<String> schemaDescription) {
        MetadataNode metadataNode;
        ArrayList<Node> schemaDoc = new ArrayList<Node>();
        ArrayList<AnnotationNode> typeAnnotations = new ArrayList<AnnotationNode>();
        schemaDescription.ifPresent(description -> schemaDoc.addAll(DocCommentsGeneratorUtil.createAPIDescriptionDoc(description, false)));
        if (schema.getDeprecated() != null) {
            DocCommentsGeneratorUtil.extractDeprecatedAnnotation(schema.getExtensions(), schemaDoc, typeAnnotations);
        }
        MarkdownDocumentationNode documentationNode = NodeFactory.createMarkdownDocumentationNode((NodeList)AbstractNodeFactory.createNodeList(schemaDoc));
        if (metadata.isEmpty()) {
            metadataNode = NodeFactory.createMetadataNode((Node)documentationNode, (NodeList)AbstractNodeFactory.createNodeList(typeAnnotations));
        } else {
            metadataNode = metadata.get();
            NodeList annotations = metadataNode.annotations();
            annotations = annotations.addAll(typeAnnotations);
            metadataNode = NodeFactory.createMetadataNode((Node)documentationNode, (NodeList)annotations);
        }
        return metadataNode;
    }
}

