/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.service;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.openapi.core.generators.service.ListenerGeneratorImpl;
import io.ballerina.openapi.core.generators.service.ServiceTypeGenerator;
import io.ballerina.openapi.core.generators.service.model.OASServiceMetadata;
import java.util.List;

public class ServiceContractGenerator
extends ServiceTypeGenerator {
    public ServiceContractGenerator(OASServiceMetadata oasServiceMetadata, List<Node> functionsList) {
        super(oasServiceMetadata, functionsList);
    }

    @Override
    protected String getServiceTypeName() {
        return "http:ServiceContract";
    }

    @Override
    protected MetadataNode getServiceMetadata() {
        ListenerGeneratorImpl listenerGenerator = new ListenerGeneratorImpl();
        listenerGenerator.getListenerDeclarationNodes(this.oasServiceMetadata.getOpenAPI().getServers());
        AnnotationNode annotationNode = ServiceContractGenerator.createServiceConfigAnnotationNode("basePath:\"" + listenerGenerator.getBasePath() + "\"");
        return NodeFactory.createMetadataNode(null, (NodeList)AbstractNodeFactory.createNodeList((Node[])new AnnotationNode[]{annotationNode}));
    }

    private static AnnotationNode createServiceConfigAnnotationNode(String annotFields) {
        String annotBody = "{" + String.join((CharSequence)",", annotFields) + "}";
        MappingConstructorExpressionNode annotationBody = null;
        SimpleNameReferenceNode annotReference = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"http:ServiceConfig"));
        ExpressionNode expressionNode = NodeParser.parseExpression((String)annotBody);
        if (expressionNode.kind() == SyntaxKind.MAPPING_CONSTRUCTOR) {
            annotationBody = (MappingConstructorExpressionNode)expressionNode;
        }
        return NodeFactory.createAnnotationNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.AT_TOKEN), (Node)annotReference, (MappingConstructorExpressionNode)annotationBody);
    }
}

