/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.service;

import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.openapi.core.generators.common.SingleFileGenerator;
import io.ballerina.openapi.core.generators.common.exception.BallerinaOpenApiException;
import io.ballerina.openapi.core.generators.common.model.GenSrcFile;
import io.ballerina.openapi.core.generators.service.ServiceContractGenerator;
import io.ballerina.openapi.core.generators.service.ServiceDeclarationGenerator;
import io.ballerina.openapi.core.generators.service.ServiceTypeGenerator;
import io.ballerina.openapi.core.generators.service.model.OASServiceMetadata;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.formatter.core.Formatter;
import org.ballerinalang.formatter.core.FormatterException;

public class ServiceGenerationHandler {
    private final List<Diagnostic> diagnostics = new ArrayList<Diagnostic>();

    public List<GenSrcFile> generateServiceFiles(OASServiceMetadata oasServiceMetadata) throws FormatterException, BallerinaOpenApiException {
        Optional<ServiceTypeGenerator> serviceTypeGenerator;
        ArrayList<GenSrcFile> sourceFiles = new ArrayList<GenSrcFile>();
        ServiceDeclarationGenerator serviceGenerator = new ServiceDeclarationGenerator(oasServiceMetadata);
        if (!oasServiceMetadata.isServiceContractRequired()) {
            String mainContent = Formatter.format((SyntaxTree)serviceGenerator.generateSyntaxTree()).toSourceCode();
            sourceFiles.add(new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, oasServiceMetadata.getSrcPackage(), oasServiceMetadata.getSrcFile(), (oasServiceMetadata.getLicenseHeader().isBlank() ? "// AUTO-GENERATED FILE.\n// This file is auto-generated by the Ballerina OpenAPI tool.\n\n" : oasServiceMetadata.getLicenseHeader()) + mainContent));
        }
        if ((serviceTypeGenerator = this.getServiceTypeGenerator(oasServiceMetadata, serviceGenerator.getFunctionsList())).isPresent()) {
            String serviceType = Formatter.format((SyntaxTree)serviceTypeGenerator.get().generateSyntaxTree()).toSourceCode();
            sourceFiles.add(new GenSrcFile(GenSrcFile.GenFileType.GEN_SERVICE_TYPE, oasServiceMetadata.getSrcPackage(), oasServiceMetadata.isServiceContractRequired() ? "service_contract.bal" : "service_type.bal", (oasServiceMetadata.getLicenseHeader().isBlank() ? "// AUTO-GENERATED FILE. DO NOT MODIFY.\n// This file is auto-generated by the Ballerina OpenAPI tool.\n\n" : oasServiceMetadata.getLicenseHeader()) + serviceType));
        }
        this.diagnostics.addAll(serviceGenerator.getDiagnostics());
        return sourceFiles;
    }

    public SyntaxTree generateSingleSyntaxTree(OASServiceMetadata oasServiceMetadata) throws BallerinaOpenApiException {
        ServiceDeclarationGenerator serviceGenerator = new ServiceDeclarationGenerator(oasServiceMetadata);
        SyntaxTree syntaxTree = serviceGenerator.generateSyntaxTree();
        if (oasServiceMetadata.isServiceContractRequired()) {
            ServiceContractGenerator serviceContractGenerator = new ServiceContractGenerator(oasServiceMetadata, serviceGenerator.getFunctionsList());
            syntaxTree = serviceContractGenerator.generateSyntaxTree();
        } else if (oasServiceMetadata.isServiceTypeRequired()) {
            ServiceTypeGenerator serviceTypeGenerator = new ServiceTypeGenerator(oasServiceMetadata, serviceGenerator.getFunctionsList());
            syntaxTree = SingleFileGenerator.combineSyntaxTrees(syntaxTree, serviceTypeGenerator.generateSyntaxTree());
        }
        this.diagnostics.addAll(serviceGenerator.getDiagnostics());
        return syntaxTree;
    }

    public List<Diagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    private Optional<ServiceTypeGenerator> getServiceTypeGenerator(OASServiceMetadata oasServiceMetadata, List<Node> functionsList) {
        if (oasServiceMetadata.isServiceTypeRequired()) {
            return Optional.of(new ServiceTypeGenerator(oasServiceMetadata, functionsList));
        }
        if (oasServiceMetadata.isServiceContractRequired()) {
            return Optional.of(new ServiceContractGenerator(oasServiceMetadata, functionsList));
        }
        return Optional.empty();
    }
}

