/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.service;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.MethodDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ObjectTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeReferenceNode;
import io.ballerina.openapi.core.generators.common.exception.BallerinaOpenApiException;
import io.ballerina.openapi.core.generators.service.ServiceGenerationUtils;
import io.ballerina.openapi.core.generators.service.ServiceGenerator;
import io.ballerina.openapi.core.generators.service.model.OASServiceMetadata;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ServiceTypeGenerator
extends ServiceGenerator {
    public ServiceTypeGenerator(OASServiceMetadata oasServiceMetadata, List<Node> functionsList) {
        super(oasServiceMetadata, functionsList);
    }

    @Override
    public SyntaxTree generateSyntaxTree() throws BallerinaOpenApiException {
        NodeList<ImportDeclarationNode> imports = ServiceGenerationUtils.createImportDeclarationNodes();
        NodeList moduleMembers = AbstractNodeFactory.createNodeList((Node[])new ModuleMemberDeclarationNode[]{this.generateServiceObject()});
        IdentifierToken eofToken = AbstractNodeFactory.createIdentifierToken((String)"");
        ModulePartNode modulePartNode = NodeFactory.createModulePartNode(imports, (NodeList)moduleMembers, (Token)eofToken);
        TextDocument textDocument = TextDocuments.from((String)"");
        SyntaxTree syntaxTree = SyntaxTree.from((TextDocument)textDocument);
        return syntaxTree.modifyWith((Node)modulePartNode);
    }

    private TypeDefinitionNode generateServiceObject() throws BallerinaOpenApiException {
        ArrayList<Object> serviceObjectMemberNodes = new ArrayList<Object>();
        TypeReferenceNode httpServiceTypeRefNode = NodeFactory.createTypeReferenceNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ASTERISK_TOKEN), (Node)AbstractNodeFactory.createIdentifierToken((String)this.getServiceTypeName()), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        serviceObjectMemberNodes.add(httpServiceTypeRefNode);
        if (this.functionsList == null) {
            this.functionsList = this.createResourceFunctions(this.oasServiceMetadata.getOpenAPI(), this.oasServiceMetadata.getFilters());
        }
        for (Node functionNode : this.functionsList) {
            NodeList methodQualifierList = AbstractNodeFactory.createNodeList((Node[])new Token[]{AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RESOURCE_KEYWORD)});
            if (!(functionNode instanceof FunctionDefinitionNode) || !((FunctionDefinitionNode)functionNode).qualifierList().stream().anyMatch(token -> Objects.equals(token.text(), SyntaxKind.RESOURCE_KEYWORD.stringValue()))) continue;
            FunctionDefinitionNode resourceFunctionDefinitionNode = (FunctionDefinitionNode)functionNode;
            MethodDeclarationNode resourceMethodDeclarationNode = NodeFactory.createMethodDeclarationNode((SyntaxKind)SyntaxKind.RESOURCE_ACCESSOR_DECLARATION, null, (NodeList)methodQualifierList, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.FUNCTION_KEYWORD), (IdentifierToken)resourceFunctionDefinitionNode.functionName(), (NodeList)resourceFunctionDefinitionNode.relativeResourcePath(), (FunctionSignatureNode)resourceFunctionDefinitionNode.functionSignature(), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
            serviceObjectMemberNodes.add(resourceMethodDeclarationNode);
        }
        NodeList members = AbstractNodeFactory.createNodeList(serviceObjectMemberNodes);
        NodeList objectQualifierList = AbstractNodeFactory.createNodeList((Node[])new Token[]{AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SERVICE_KEYWORD)});
        ObjectTypeDescriptorNode objectTypeDescriptorNode = NodeFactory.createObjectTypeDescriptorNode((NodeList)objectQualifierList, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OBJECT_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (NodeList)members, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
        return NodeFactory.createTypeDefinitionNode((MetadataNode)this.getServiceMetadata(), null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)AbstractNodeFactory.createIdentifierToken((String)this.getServiceObjectTypeName()), (Node)objectTypeDescriptorNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    protected String getServiceObjectTypeName() {
        return this.oasServiceMetadata.getServiceObjectTypeName();
    }

    protected MetadataNode getServiceMetadata() {
        return null;
    }

    protected String getServiceTypeName() {
        return "http:Service";
    }
}

