/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.service.parameter;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.service.ServiceGenerationUtils;
import io.ballerina.openapi.core.generators.service.model.OASServiceMetadata;
import io.ballerina.openapi.core.generators.service.parameter.RequestBodyGenerator;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

public class DefaultRequestBodyGenerator
extends RequestBodyGenerator {
    public DefaultRequestBodyGenerator(OASServiceMetadata oasServiceMetadata, String path) {
        super(oasServiceMetadata, path);
    }

    @Override
    public RequiredParameterNode createRequestBodyNode(RequestBody requestBody) {
        String paramName;
        TypeDescriptorNode typeName;
        HashSet<String> types = new HashSet<String>();
        LinkedHashMap<String, TypeDescriptorNode> typeDescNodes = new LinkedHashMap<String, TypeDescriptorNode>();
        for (Map.Entry mime : requestBody.getContent().entrySet()) {
            typeName = GeneratorUtils.generateTypeDescForMediaType(this.oasServiceMetadata.getOpenAPI(), this.path, true, mime);
            if (typeName != null) {
                types.add(typeName.toSourceCode());
                typeDescNodes.put(typeName.toSourceCode(), typeName);
                continue;
            }
            types.add("http:Request");
        }
        typeName = types.contains("http:Request") || types.isEmpty() ? NodeParser.parseTypeDescriptor((String)"http:Request") : GeneratorUtils.getUnionTypeDescriptorNodeFromTypeDescNodes(typeDescNodes);
        AnnotationNode annotationNode = ServiceGenerationUtils.getAnnotationNode("Payload", null);
        NodeList annotation = NodeFactory.createNodeList((Node[])new AnnotationNode[]{annotationNode});
        String string = paramName = typeName.toString().equals("http:Request") ? "request" : "payload";
        if (typeName.toString().equals("http:Request")) {
            return NodeFactory.createRequiredParameterNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), (Node)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"http:Request")), (Token)AbstractNodeFactory.createIdentifierToken((String)"request"));
        }
        return NodeFactory.createRequiredParameterNode((NodeList)annotation, (Node)typeName, (Token)AbstractNodeFactory.createIdentifierToken((String)paramName, (MinutiaeList)GeneratorUtils.SINGLE_WS_MINUTIAE, (MinutiaeList)GeneratorUtils.SINGLE_WS_MINUTIAE));
    }
}

