/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.service.parameter;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ArrayDimensionNode;
import io.ballerina.compiler.syntax.tree.ArrayTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.OptionalTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.TypeHandler;
import io.ballerina.openapi.core.generators.common.exception.InvalidReferenceException;
import io.ballerina.openapi.core.generators.common.exception.UnsupportedOASDataTypeException;
import io.ballerina.openapi.core.generators.service.diagnostic.ServiceDiagnostic;
import io.ballerina.openapi.core.generators.service.diagnostic.ServiceDiagnosticMessages;
import io.ballerina.openapi.core.generators.service.model.OASServiceMetadata;
import io.ballerina.openapi.core.generators.service.parameter.ParameterGenerator;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.Map;
import java.util.Optional;

public class QueryParameterGenerator
extends ParameterGenerator {
    public QueryParameterGenerator(OASServiceMetadata oasServiceMetadata) {
        super(oasServiceMetadata);
    }

    @Override
    public ParameterNode generateParameterNode(Parameter parameter) throws InvalidReferenceException, UnsupportedOASDataTypeException {
        boolean isSchemaNotSupported;
        Schema schema = parameter.getSchema();
        String paramName = parameter.getName().trim();
        NodeList annotations = AbstractNodeFactory.createEmptyNodeList();
        Optional<String> nameFromExt = GeneratorUtils.getBallerinaNameExtension(parameter);
        if (nameFromExt.isPresent()) {
            paramName = nameFromExt.get();
            annotations = AbstractNodeFactory.createNodeList((Node[])new AnnotationNode[]{GeneratorUtils.getNameAnnotationNode(parameter.getName(), "http:Query")});
        }
        IdentifierToken parameterName = AbstractNodeFactory.createIdentifierToken((String)GeneratorUtils.escapeIdentifier(paramName), (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList(), (MinutiaeList)GeneratorUtils.SINGLE_WS_MINUTIAE);
        boolean bl = isSchemaNotSupported = schema == null || GeneratorUtils.getOpenAPIType(schema) == null;
        if (schema != null && schema.get$ref() != null) {
            String refType = GeneratorUtils.extractReferenceType(schema.get$ref());
            Schema refSchema = (Schema)this.openAPI.getComponents().getSchemas().get(refType);
            return this.handleReferencedQueryParameter(parameter, refSchema, parameterName, (NodeList<AnnotationNode>)annotations);
        }
        if (parameter.getContent() != null) {
            Content content = parameter.getContent();
            Optional mediaTypeEntry = content.entrySet().stream().findFirst();
            if (mediaTypeEntry.isPresent()) {
                return this.handleMapJsonQueryParameter(parameter, parameterName, (Map.Entry)mediaTypeEntry.get(), (NodeList<AnnotationNode>)annotations);
            }
        } else {
            if (isSchemaNotSupported) {
                this.diagnostics.add(new ServiceDiagnostic(ServiceDiagnosticMessages.OAS_SERVICE_102, GeneratorUtils.getOpenAPIType(parameter.getSchema())));
                OptionalTypeDescriptorNode optionalNode = NodeFactory.createOptionalTypeDescriptorNode((Node)AbstractNodeFactory.createIdentifierToken((String)"string"), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN));
                return NodeFactory.createRequiredParameterNode((NodeList)annotations, (Node)optionalNode, (Token)parameterName);
            }
            if (parameter.getSchema().getDefault() != null) {
                return this.handleDefaultQueryParameter(schema, parameterName, (NodeList<AnnotationNode>)annotations);
            }
            if (parameter.getRequired().booleanValue() && schema.getNullable() == null) {
                return this.handleRequiredQueryParameter(schema, parameterName, (NodeList<AnnotationNode>)annotations);
            }
            return this.handleOptionalQueryParameter(schema, parameterName, (NodeList<AnnotationNode>)annotations);
        }
        return null;
    }

    private RequiredParameterNode handleMapJsonQueryParameter(Parameter parameter, IdentifierToken parameterName, Map.Entry<String, MediaType> mediaTypeEntry, NodeList<AnnotationNode> annotations) throws InvalidReferenceException {
        Schema parameterSchema;
        String type;
        if (mediaTypeEntry.getValue().getSchema() != null && mediaTypeEntry.getValue().getSchema().get$ref() != null) {
            type = GeneratorUtils.escapeIdentifier(GeneratorUtils.extractReferenceType(mediaTypeEntry.getValue().getSchema().get$ref()));
            parameterSchema = (Schema)this.openAPI.getComponents().getSchemas().get(type.trim());
        } else {
            parameterSchema = mediaTypeEntry.getValue().getSchema();
        }
        if (mediaTypeEntry.getKey().equals("application/json") && GeneratorUtils.isMapSchema(parameterSchema)) {
            return this.getMapJsonParameterNode(parameterName, parameter, annotations);
        }
        type = GeneratorUtils.getBallerinaMediaType(mediaTypeEntry.getKey(), false);
        this.diagnostics.add(new ServiceDiagnostic(ServiceDiagnosticMessages.OAS_SERVICE_102, type));
        OptionalTypeDescriptorNode optionalNode = NodeFactory.createOptionalTypeDescriptorNode((Node)AbstractNodeFactory.createIdentifierToken((String)"string"), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN));
        return NodeFactory.createRequiredParameterNode(annotations, (Node)optionalNode, (Token)parameterName);
    }

    private RequiredParameterNode getMapJsonParameterNode(IdentifierToken parameterName, Parameter parameter, NodeList<AnnotationNode> annotations) {
        BuiltinSimpleNameReferenceNode rTypeName = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)"map<json>"));
        if (parameter.getRequired().booleanValue()) {
            return NodeFactory.createRequiredParameterNode(annotations, (Node)rTypeName, (Token)parameterName);
        }
        OptionalTypeDescriptorNode optionalNode = NodeFactory.createOptionalTypeDescriptorNode((Node)rTypeName, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN));
        return NodeFactory.createRequiredParameterNode(annotations, (Node)optionalNode, (Token)parameterName);
    }

    private ParameterNode handleOptionalQueryParameter(Schema<?> schema, IdentifierToken parameterName, NodeList<AnnotationNode> annotations) throws UnsupportedOASDataTypeException {
        IdentifierToken name;
        if (GeneratorUtils.isArraySchema(schema)) {
            Schema items = schema.getItems();
            if (GeneratorUtils.getOpenAPIType(items) == null && items.get$ref() == null) {
                this.diagnostics.add(new ServiceDiagnostic(ServiceDiagnosticMessages.OAS_SERVICE_101, new String[0]));
                return QueryParameterGenerator.createStringArrayParameterNode(parameterName, annotations);
            }
            if (!GeneratorUtils.isObjectSchema(items) && (GeneratorUtils.getOpenAPIType(items) == null || !GeneratorUtils.getOpenAPIType(items).equals("array")) || items.get$ref() != null) {
                Optional<TypeDescriptorNode> typeDescriptorNode = TypeHandler.getInstance().getTypeNodeFromOASSchema(schema, true);
                OptionalTypeDescriptorNode optionalNode = NodeFactory.createOptionalTypeDescriptorNode((Node)((Node)typeDescriptorNode.get()), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN));
                return NodeFactory.createRequiredParameterNode(annotations, (Node)optionalNode, (Token)parameterName);
            }
            if (GeneratorUtils.getOpenAPIType(items).equals("array")) {
                this.diagnostics.add(new ServiceDiagnostic(ServiceDiagnosticMessages.OAS_SERVICE_100, new String[0]));
                return QueryParameterGenerator.createStringArrayParameterNode(parameterName, annotations);
            }
            this.diagnostics.add(new ServiceDiagnostic(ServiceDiagnosticMessages.OAS_SERVICE_102, "object"));
            OptionalTypeDescriptorNode optionalNode = NodeFactory.createOptionalTypeDescriptorNode((Node)AbstractNodeFactory.createIdentifierToken((String)"string"), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN));
            return NodeFactory.createRequiredParameterNode(annotations, (Node)optionalNode, (Token)parameterName);
        }
        if (schema instanceof MapSchema) {
            Optional<TypeDescriptorNode> typeDescriptorNode = TypeHandler.getInstance().getTypeNodeFromOASSchema(schema, true);
            name = AbstractNodeFactory.createIdentifierToken((String)typeDescriptorNode.get().toSourceCode(), (MinutiaeList)GeneratorUtils.SINGLE_WS_MINUTIAE, (MinutiaeList)GeneratorUtils.SINGLE_WS_MINUTIAE);
        } else {
            name = AbstractNodeFactory.createIdentifierToken((String)GeneratorUtils.convertOpenAPITypeToBallerina(schema, true), (MinutiaeList)GeneratorUtils.SINGLE_WS_MINUTIAE, (MinutiaeList)GeneratorUtils.SINGLE_WS_MINUTIAE);
        }
        BuiltinSimpleNameReferenceNode queryParamType = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)name);
        if (!name.text().trim().endsWith("?")) {
            queryParamType = NodeFactory.createOptionalTypeDescriptorNode((Node)queryParamType, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN));
        }
        return NodeFactory.createRequiredParameterNode(annotations, (Node)queryParamType, (Token)parameterName);
    }

    private static RequiredParameterNode createStringArrayParameterNode(IdentifierToken parameterName, NodeList<AnnotationNode> annotations) {
        ArrayDimensionNode arrayDimensionNode = NodeFactory.createArrayDimensionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACKET_TOKEN), null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACKET_TOKEN));
        ArrayTypeDescriptorNode arrayTypedescNode = NodeFactory.createArrayTypeDescriptorNode((TypeDescriptorNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"string")), (NodeList)AbstractNodeFactory.createNodeList((Node[])new ArrayDimensionNode[]{arrayDimensionNode}));
        OptionalTypeDescriptorNode optionalNode = NodeFactory.createOptionalTypeDescriptorNode((Node)arrayTypedescNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN));
        return NodeFactory.createRequiredParameterNode(annotations, (Node)optionalNode, (Token)parameterName);
    }

    private ParameterNode handleReferencedQueryParameter(Parameter parameter, Schema<?> refSchema, IdentifierToken parameterName, NodeList<AnnotationNode> annotations) {
        IdentifierToken refTypeNameNode;
        if (refSchema.getAnyOf() != null || refSchema.getOneOf() != null) {
            refTypeNameNode = AbstractNodeFactory.createIdentifierToken((String)"string");
            this.diagnostics.add(new ServiceDiagnostic(ServiceDiagnosticMessages.OAS_SERVICE_107, "object"));
        } else {
            Optional<TypeDescriptorNode> typeDescriptorNode = TypeHandler.getInstance().getTypeNodeFromOASSchema(parameter.getSchema(), true);
            refTypeNameNode = AbstractNodeFactory.createIdentifierToken((String)typeDescriptorNode.get().toSourceCode());
        }
        if (refSchema.getDefault() != null) {
            String defaultValue = GeneratorUtils.getOpenAPIType(refSchema).equals("string") ? String.format("\"%s\"", refSchema.getDefault().toString()) : refSchema.getDefault().toString();
            return NodeFactory.createDefaultableParameterNode(annotations, (Node)refTypeNameNode, (Token)parameterName, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (Node)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)defaultValue)));
        }
        if (parameter.getRequired().booleanValue() && (refSchema.getNullable() == null || !refSchema.getNullable().booleanValue())) {
            return NodeFactory.createRequiredParameterNode(annotations, (Node)refTypeNameNode, (Token)parameterName);
        }
        OptionalTypeDescriptorNode optionalNode = NodeFactory.createOptionalTypeDescriptorNode((Node)refTypeNameNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN));
        return NodeFactory.createRequiredParameterNode(annotations, (Node)optionalNode, (Token)parameterName);
    }

    private ParameterNode handleRequiredQueryParameter(Schema<?> schema, IdentifierToken parameterName, NodeList<AnnotationNode> annotations) {
        if (GeneratorUtils.isArraySchema(schema)) {
            Schema items = schema.getItems();
            if (!(GeneratorUtils.isArraySchema(items) || GeneratorUtils.getOpenAPIType(items) == null && items.get$ref() == null)) {
                Optional<TypeDescriptorNode> typeDescriptorNode = TypeHandler.getInstance().getTypeNodeFromOASSchema(schema, true);
                IdentifierToken arrayTypeName = AbstractNodeFactory.createIdentifierToken((String)typeDescriptorNode.get().toSourceCode());
                return NodeFactory.createRequiredParameterNode(annotations, (Node)arrayTypeName, (Token)parameterName);
            }
            if (GeneratorUtils.getOpenAPIType(items) == null) {
                this.diagnostics.add(new ServiceDiagnostic(ServiceDiagnosticMessages.OAS_SERVICE_101, new String[0]));
                return QueryParameterGenerator.createStringArrayParameterNode(parameterName, annotations);
            }
            if (GeneratorUtils.isObjectSchema(items)) {
                this.diagnostics.add(new ServiceDiagnostic(ServiceDiagnosticMessages.OAS_SERVICE_102, "object"));
                OptionalTypeDescriptorNode optionalNode = NodeFactory.createOptionalTypeDescriptorNode((Node)AbstractNodeFactory.createIdentifierToken((String)"string"), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN));
                return NodeFactory.createRequiredParameterNode(annotations, (Node)optionalNode, (Token)parameterName);
            }
            this.diagnostics.add(new ServiceDiagnostic(ServiceDiagnosticMessages.OAS_SERVICE_100, new String[0]));
            return QueryParameterGenerator.createStringArrayParameterNode(parameterName, annotations);
        }
        Optional<TypeDescriptorNode> typeDescriptorNode = TypeHandler.getInstance().getTypeNodeFromOASSchema(schema, true);
        IdentifierToken name = AbstractNodeFactory.createIdentifierToken((String)typeDescriptorNode.get().toSourceCode());
        BuiltinSimpleNameReferenceNode rTypeName = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)name);
        return NodeFactory.createRequiredParameterNode(annotations, (Node)rTypeName, (Token)parameterName);
    }

    private ParameterNode handleDefaultQueryParameter(Schema<?> schema, IdentifierToken parameterName, NodeList<AnnotationNode> annotations) {
        if (GeneratorUtils.isArraySchema(schema)) {
            Schema items = schema.getItems();
            if (!(GeneratorUtils.isArraySchema(items) || GeneratorUtils.getOpenAPIType(items) == null && items.get$ref() == null)) {
                Optional<TypeDescriptorNode> typeDescriptorNode = TypeHandler.getInstance().getTypeNodeFromOASSchema(schema, true);
                IdentifierToken arrayTypeName = AbstractNodeFactory.createIdentifierToken((String)typeDescriptorNode.get().toSourceCode());
                return NodeFactory.createDefaultableParameterNode(annotations, (Node)arrayTypeName, (Token)parameterName, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (Node)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)schema.getDefault().toString())));
            }
            if (GeneratorUtils.getOpenAPIType(items) == null) {
                this.diagnostics.add(new ServiceDiagnostic(ServiceDiagnosticMessages.OAS_SERVICE_101, new String[0]));
                return QueryParameterGenerator.createStringArrayParameterNode(parameterName, annotations);
            }
            this.diagnostics.add(new ServiceDiagnostic(ServiceDiagnosticMessages.OAS_SERVICE_100, new String[0]));
            return QueryParameterGenerator.createStringArrayParameterNode(parameterName, annotations);
        }
        Optional<TypeDescriptorNode> typeDescriptorNode = TypeHandler.getInstance().getTypeNodeFromOASSchema(schema, true);
        IdentifierToken name = AbstractNodeFactory.createIdentifierToken((String)typeDescriptorNode.get().toSourceCode());
        BuiltinSimpleNameReferenceNode rTypeName = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)name);
        if (GeneratorUtils.getOpenAPIType(schema).equals("string")) {
            return NodeFactory.createDefaultableParameterNode(annotations, (Node)rTypeName, (Token)parameterName, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (Node)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)("\"" + schema.getDefault().toString() + "\""))));
        }
        return NodeFactory.createDefaultableParameterNode(annotations, (Node)rTypeName, (Token)parameterName, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (Node)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)schema.getDefault().toString())));
    }
}

