/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.service.resource;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.FunctionBodyBlockNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.exception.BallerinaOpenApiException;
import io.ballerina.openapi.core.generators.service.model.OASServiceMetadata;
import io.ballerina.openapi.core.generators.service.resource.ResourceGenerator;
import io.ballerina.openapi.core.generators.service.signature.FunctionSignatureGenerator;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import java.util.Locale;
import java.util.Map;

public class LowResourceGenerator
extends ResourceGenerator {
    public LowResourceGenerator(OASServiceMetadata oasServiceMetadata) {
        super(oasServiceMetadata);
    }

    @Override
    public FunctionDefinitionNode generateResourceFunction(Map.Entry<PathItem.HttpMethod, Operation> operation, String path) throws BallerinaOpenApiException {
        GeneratorUtils.addCommonParamsToOperationParams(operation, this.oasServiceMetadata.getOpenAPI(), path);
        NodeList qualifiersList = AbstractNodeFactory.createNodeList((Node[])new Token[]{AbstractNodeFactory.createIdentifierToken((String)"resource", (MinutiaeList)GeneratorUtils.SINGLE_WS_MINUTIAE, (MinutiaeList)GeneratorUtils.SINGLE_WS_MINUTIAE)});
        IdentifierToken functionKeyWord = AbstractNodeFactory.createIdentifierToken((String)"function", (MinutiaeList)GeneratorUtils.SINGLE_WS_MINUTIAE, (MinutiaeList)GeneratorUtils.SINGLE_WS_MINUTIAE);
        IdentifierToken functionName = AbstractNodeFactory.createIdentifierToken((String)operation.getKey().name().toLowerCase(Locale.ENGLISH), (MinutiaeList)GeneratorUtils.SINGLE_WS_MINUTIAE, (MinutiaeList)GeneratorUtils.SINGLE_WS_MINUTIAE);
        NodeList<Node> relativeResourcePath = GeneratorUtils.getRelativeResourcePath(path, operation.getValue(), this.oasServiceMetadata.getOpenAPI().getComponents(), this.oasServiceMetadata.generateWithoutDataBinding(), this.diagnostics);
        FunctionSignatureGenerator functionSignatureGenerator = FunctionSignatureGenerator.getFunctionSignatureGenerator(this.oasServiceMetadata);
        FunctionSignatureNode functionSignatureNode = functionSignatureGenerator.getFunctionSignature(operation, path);
        this.diagnostics.addAll(functionSignatureGenerator.getDiagnostics());
        FunctionBodyBlockNode functionBodyBlockNode = NodeFactory.createFunctionBodyBlockNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), null, (NodeList)AbstractNodeFactory.createEmptyNodeList(), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN), null);
        return NodeFactory.createFunctionDefinitionNode((SyntaxKind)SyntaxKind.RESOURCE_ACCESSOR_DEFINITION, null, (NodeList)qualifiersList, (Token)functionKeyWord, (IdentifierToken)functionName, relativeResourcePath, (FunctionSignatureNode)functionSignatureNode, (FunctionBodyNode)functionBodyBlockNode);
    }
}

