/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.service.signature;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.openapi.core.generators.common.exception.BallerinaOpenApiException;
import io.ballerina.openapi.core.generators.service.model.OASServiceMetadata;
import io.ballerina.openapi.core.generators.service.parameter.RequestBodyGenerator;
import io.ballerina.openapi.core.generators.service.response.ReturnTypeGenerator;
import io.ballerina.openapi.core.generators.service.signature.FunctionSignatureGenerator;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import java.util.ArrayList;
import java.util.Map;

public class LowResourceFunctionSignatureGenerator
extends FunctionSignatureGenerator {
    public LowResourceFunctionSignatureGenerator(OASServiceMetadata oasServiceMetadata) {
        super(oasServiceMetadata);
    }

    @Override
    public FunctionSignatureNode getFunctionSignature(Map.Entry<PathItem.HttpMethod, Operation> operation, String path) throws BallerinaOpenApiException {
        ArrayList<Object> parameters = new ArrayList<Object>();
        BuiltinSimpleNameReferenceNode typeName = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)"http:Caller"));
        IdentifierToken paramName = AbstractNodeFactory.createIdentifierToken((String)"caller");
        RequiredParameterNode httpCaller = NodeFactory.createRequiredParameterNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), (Node)typeName, (Token)paramName);
        parameters.add(httpCaller);
        parameters.add(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
        RequestBodyGenerator requestBodyGenerator = RequestBodyGenerator.getRequestBodyGenerator(this.oasServiceMetadata, path);
        RequiredParameterNode requestBodyNode = requestBodyGenerator.createRequestBodyNode(operation.getValue().getRequestBody());
        parameters.add(requestBodyNode);
        this.diagnostics.addAll(requestBodyGenerator.getDiagnostics());
        SeparatedNodeList parameterList = AbstractNodeFactory.createSeparatedNodeList(parameters);
        ReturnTypeGenerator returnTypeGenerator = ReturnTypeGenerator.getReturnTypeGenerator(this.oasServiceMetadata, path);
        ReturnTypeDescriptorNode returnTypeDescriptorNode = returnTypeGenerator.getReturnTypeDescriptorNode(operation, path);
        this.diagnostics.addAll(returnTypeGenerator.getDiagnostics());
        return NodeFactory.createFunctionSignatureNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), (SeparatedNodeList)parameterList, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN), (ReturnTypeDescriptorNode)returnTypeDescriptorNode);
    }
}

