/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.type.generators;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.RecordRestDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypeReferenceNode;
import io.ballerina.compiler.syntax.tree.UnionTypeDescriptorNode;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.exception.BallerinaOpenApiException;
import io.ballerina.openapi.core.generators.common.exception.InvalidReferenceException;
import io.ballerina.openapi.core.generators.type.TypeGeneratorUtils;
import io.ballerina.openapi.core.generators.type.diagnostic.TypeGenerationDiagnosticMessages;
import io.ballerina.openapi.core.generators.type.diagnostic.TypeGeneratorDiagnostic;
import io.ballerina.openapi.core.generators.type.exception.OASTypeGenException;
import io.ballerina.openapi.core.generators.type.generators.AnyDataTypeGenerator;
import io.ballerina.openapi.core.generators.type.generators.RecordTypeGenerator;
import io.ballerina.openapi.core.generators.type.generators.ReferencedTypeGenerator;
import io.ballerina.openapi.core.generators.type.generators.TypeGenerator;
import io.ballerina.openapi.core.generators.type.model.GeneratorMetaData;
import io.ballerina.openapi.core.generators.type.model.RecordMetadata;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class AllOfRecordTypeGenerator
extends RecordTypeGenerator {
    private final List<Schema<?>> restSchemas = new LinkedList();
    private final Map<String, Schema> allProperties = new HashMap<String, Schema>();

    public AllOfRecordTypeGenerator(Schema schema, String typeName, boolean ignoreNullableFlag, HashMap<String, TypeDefinitionNode> subTypesMap, HashMap<String, NameReferenceNode> pregeneratedTypeMap) {
        super(schema, typeName, ignoreNullableFlag, subTypesMap, pregeneratedTypeMap);
        this.allProperties.putAll(this.getAllPropertiesFromComposedSchema(schema));
    }

    @Override
    public TypeDescriptorNode generateTypeDescriptorNode() throws OASTypeGenException {
        List allOfSchemas = this.schema.getAllOf();
        ArrayList<String> requiredFields = this.schema.getRequired();
        if (Objects.isNull(requiredFields)) {
            requiredFields = new ArrayList<String>();
        }
        RecordMetadata recordMetadata = this.getRecordMetadata();
        RecordRestDescriptorNode restDescriptorNode = recordMetadata.getRestDescriptorNode();
        if (allOfSchemas.size() == 1 && ((Schema)allOfSchemas.get(0)).get$ref() != null) {
            ReferencedTypeGenerator referencedTypeGenerator = new ReferencedTypeGenerator((Schema)allOfSchemas.get(0), this.typeName, this.ignoreNullableFlag, this.subTypesMap, this.pregeneratedTypeMap);
            TypeDescriptorNode typeDescriptorNode = referencedTypeGenerator.generateTypeDescriptorNode();
            return typeDescriptorNode;
        }
        ImmutablePair<List<Node>, List<Schema<?>>> recordFlist = this.generateAllOfRecordFields(allOfSchemas, requiredFields);
        List recordFieldList = (List)recordFlist.getLeft();
        List validSchemas = (List)recordFlist.getRight();
        if (validSchemas.isEmpty()) {
            AnyDataTypeGenerator anyDataTypeGenerator = new AnyDataTypeGenerator(this.schema, this.typeName, this.ignoreNullableFlag, this.subTypesMap, this.pregeneratedTypeMap);
            TypeDescriptorNode typeDescriptorNode = anyDataTypeGenerator.generateTypeDescriptorNode();
            return typeDescriptorNode;
        }
        if (validSchemas.size() == 1) {
            TypeGenerator typeGenerator = TypeGeneratorUtils.getTypeGenerator((Schema)validSchemas.get(0), this.typeName, null, this.ignoreNullableFlag, this.subTypesMap, this.pregeneratedTypeMap);
            TypeDescriptorNode typeDescriptorNode = typeGenerator.generateTypeDescriptorNode();
            return typeDescriptorNode;
        }
        this.addAdditionalSchemas(this.schema);
        restDescriptorNode = this.restSchemas.size() > 1 ? this.getRestDescriptorNodeForAllOf(this.restSchemas) : restDescriptorNode;
        NodeList fieldNodes = AbstractNodeFactory.createNodeList((Collection)recordFieldList);
        return NodeFactory.createRecordTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RECORD_KEYWORD), (Token)(recordMetadata.isOpenRecord() ? AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN) : AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_PIPE_TOKEN)), (NodeList)fieldNodes, (RecordRestDescriptorNode)restDescriptorNode, (Token)(recordMetadata.isOpenRecord() ? AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN) : AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_PIPE_TOKEN)));
    }

    private ImmutablePair<List<Node>, List<Schema<?>>> generateAllOfRecordFields(List<Schema<?>> allOfSchemas, List<String> requiredFields) throws OASTypeGenException {
        ArrayList<Node> recordFieldList = new ArrayList<Node>();
        ArrayList validSchemas = new ArrayList();
        for (Schema<?> allOfSchema : allOfSchemas) {
            if (allOfSchema.get$ref() != null) {
                String extractedSchemaName;
                try {
                    extractedSchemaName = GeneratorUtils.extractReferenceType(allOfSchema.get$ref());
                }
                catch (BallerinaOpenApiException e) {
                    throw new OASTypeGenException(e.getMessage());
                }
                String modifiedSchemaName = GeneratorUtils.escapeIdentifier(extractedSchemaName);
                IdentifierToken typeRef = AbstractNodeFactory.createIdentifierToken((String)modifiedSchemaName);
                TypeReferenceNode recordField = NodeFactory.createTypeReferenceNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ASTERISK_TOKEN), (Node)typeRef, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
                OpenAPI openAPI = GeneratorMetaData.getInstance().getOpenAPI();
                Schema refSchema = (Schema)openAPI.getComponents().getSchemas().get(extractedSchemaName);
                this.addAdditionalSchemas(refSchema);
                if (!this.pregeneratedTypeMap.containsKey(modifiedSchemaName)) {
                    this.pregeneratedTypeMap.put(modifiedSchemaName, NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)modifiedSchemaName)));
                    TypeGenerator reffredTypeGenerator = TypeGeneratorUtils.getTypeGenerator(refSchema, modifiedSchemaName, modifiedSchemaName, this.ignoreNullableFlag, this.subTypesMap, this.pregeneratedTypeMap);
                    TypeDescriptorNode typeDescriptorNode1 = reffredTypeGenerator.generateTypeDescriptorNode();
                    this.subTypesMap.put(extractedSchemaName, NodeFactory.createTypeDefinitionNode(null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)AbstractNodeFactory.createIdentifierToken((String)modifiedSchemaName), (Node)typeDescriptorNode1, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN)));
                }
                recordFieldList.add((Node)recordField);
                if (!requiredFields.isEmpty()) {
                    this.handleCommonRequiredFields(requiredFields, refSchema, recordFieldList);
                }
            } else if (allOfSchema.getProperties() != null) {
                Map properties = allOfSchema.getProperties();
                ArrayList<String> required = allOfSchema.getRequired();
                if (Objects.isNull(required)) {
                    required = new ArrayList<String>();
                }
                this.updateRFieldsWithRequiredProperties(properties, required);
                required.addAll(requiredFields);
                recordFieldList.addAll(this.addRecordFields(required, properties.entrySet(), this.typeName));
                this.addAdditionalSchemas(allOfSchema);
            } else if (GeneratorUtils.isComposedSchema(allOfSchema)) {
                if (allOfSchema.getAllOf() != null) {
                    ImmutablePair<List<Node>, List<Schema<?>>> immutablePair = this.generateAllOfRecordFields(allOfSchema.getAllOf(), requiredFields);
                    List recordAllFields = (List)immutablePair.getLeft();
                    recordFieldList.addAll(recordAllFields);
                } else {
                    this.diagnostics.add(new TypeGeneratorDiagnostic(TypeGenerationDiagnosticMessages.OAS_TYPE_102, new String[0]));
                }
            }
            if (allOfSchema.getType() == null && allOfSchema.getProperties() == null && allOfSchema.get$ref() == null && allOfSchema.getAllOf() == null) continue;
            validSchemas.add(allOfSchema);
        }
        return ImmutablePair.of(recordFieldList, validSchemas);
    }

    private void handleCommonRequiredFields(List<String> requiredFields, Schema refSchema, List<Node> recordFieldList) throws OASTypeGenException {
        try {
            Map<String, Schema<?>> properties = AllOfRecordTypeGenerator.getPropertiesFromRefSchema(refSchema);
            List required = refSchema.getRequired();
            if (Objects.nonNull(required)) {
                requiredFields.removeAll(required);
                this.updateRFieldsWithRequiredProperties(properties, required);
            }
            HashSet fieldProperties = new HashSet();
            for (Map.Entry<String, Schema<?>> property : properties.entrySet()) {
                if (!requiredFields.contains(property.getKey())) continue;
                fieldProperties.add(property);
            }
            recordFieldList.addAll(this.addRecordFields(requiredFields, fieldProperties, this.typeName));
        }
        catch (BallerinaOpenApiException e) {
            throw new OASTypeGenException(e.getMessage());
        }
    }

    private void updateRFieldsWithRequiredProperties(Map<String, Schema<?>> properties, List<String> required) {
        for (String field : required) {
            if (properties.containsKey(field) || !this.allProperties.containsKey(field)) continue;
            properties.put(field, this.allProperties.get(field));
        }
    }

    private static Map<String, Schema<?>> getPropertiesFromRefSchema(Schema schema) throws InvalidReferenceException {
        List allOfSchemas;
        String refSchema;
        HashMap properties = schema.getProperties();
        if (Objects.isNull(properties)) {
            properties = new HashMap();
        }
        if (Objects.nonNull(refSchema = schema.get$ref())) {
            String extractedSchemaName = GeneratorUtils.extractReferenceType(refSchema);
            OpenAPI openAPI = GeneratorMetaData.getInstance().getOpenAPI();
            Schema refSchemaObj = (Schema)openAPI.getComponents().getSchemas().get(extractedSchemaName);
            if (Objects.nonNull(refSchemaObj)) {
                properties.putAll(AllOfRecordTypeGenerator.getPropertiesFromRefSchema(refSchemaObj));
            }
        }
        if (Objects.nonNull(allOfSchemas = schema.getAllOf())) {
            for (Schema allOfSchema : allOfSchemas) {
                properties.putAll(AllOfRecordTypeGenerator.getPropertiesFromRefSchema(allOfSchema));
            }
        }
        return properties;
    }

    private RecordRestDescriptorNode getRestDescriptorNodeForAllOf(List<Schema<?>> restSchemas) throws OASTypeGenException {
        TypeDescriptorNode unionType = this.getUnionType(restSchemas);
        return NodeFactory.createRecordRestDescriptorNode((Node)unionType, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ELLIPSIS_TOKEN), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    private TypeDescriptorNode getUnionType(List<Schema<?>> schemas) throws OASTypeGenException {
        ArrayList<TypeDescriptorNode> typeDescriptorNodes = new ArrayList<TypeDescriptorNode>();
        for (Schema<?> schema : schemas) {
            TypeGenerator typeGenerator = TypeGeneratorUtils.getTypeGenerator(schema, null, null, this.ignoreNullableFlag, this.subTypesMap, this.pregeneratedTypeMap);
            TypeDescriptorNode typeDescriptorNode = typeGenerator.generateTypeDescriptorNode();
            this.imports.addAll(typeGenerator.getImports());
            typeDescriptorNodes.add(typeDescriptorNode);
        }
        if (typeDescriptorNodes.size() > 1) {
            UnionTypeDescriptorNode unionTypeDescriptorNode = null;
            TypeDescriptorNode leftTypeDesc = (TypeDescriptorNode)typeDescriptorNodes.get(0);
            for (int i = 1; i < typeDescriptorNodes.size(); ++i) {
                TypeDescriptorNode rightTypeDesc = (TypeDescriptorNode)typeDescriptorNodes.get(i);
                unionTypeDescriptorNode = NodeFactory.createUnionTypeDescriptorNode((TypeDescriptorNode)leftTypeDesc, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PIPE_TOKEN), (TypeDescriptorNode)rightTypeDesc);
                leftTypeDesc = unionTypeDescriptorNode;
            }
            return unionTypeDescriptorNode;
        }
        return (TypeDescriptorNode)typeDescriptorNodes.get(0);
    }

    private void addAdditionalSchemas(Schema<?> refSchema) {
        if (refSchema.getAdditionalProperties() != null && refSchema.getAdditionalProperties() instanceof Schema) {
            this.restSchemas.add((Schema)refSchema.getAdditionalProperties());
        }
    }

    public Map<String, Schema> getAllPropertiesFromComposedSchema(Schema schemaV) {
        HashMap<String, Schema> properties = new HashMap<String, Schema>();
        if (!(schemaV instanceof ComposedSchema)) {
            return new HashMap<String, Schema>();
        }
        ComposedSchema composedSchema = (ComposedSchema)schemaV;
        try {
            this.addPropertiesFromSchemas(composedSchema.getAllOf(), properties);
            this.addPropertiesFromSchemas(composedSchema.getAnyOf(), properties);
            this.addPropertiesFromSchemas(composedSchema.getOneOf(), properties);
        }
        catch (InvalidReferenceException e) {
            this.diagnostics.add(new TypeGeneratorDiagnostic(TypeGenerationDiagnosticMessages.OAS_TYPE_103, e.getMessage()));
        }
        return properties;
    }

    private void addPropertiesFromSchemas(List<Schema> schemas, Map<String, Schema> properties) throws InvalidReferenceException {
        if (schemas != null) {
            for (Schema schema : schemas) {
                if (schema instanceof ComposedSchema) {
                    ComposedSchema composedSchema = (ComposedSchema)schema;
                    properties.putAll(this.getAllPropertiesFromComposedSchema((Schema)composedSchema));
                    continue;
                }
                properties.putAll(this.resolveAndGetProperties(schema, GeneratorMetaData.getInstance().getOpenAPI()));
            }
        }
    }

    private Map<String, Schema> resolveAndGetProperties(Schema schema, OpenAPI openapi) throws InvalidReferenceException {
        if (schema.get$ref() != null) {
            String refName = GeneratorUtils.extractReferenceType(schema.get$ref());
            schema = (Schema)openapi.getComponents().getSchemas().get(refName);
        }
        if (schema instanceof ComposedSchema) {
            ComposedSchema composedSchema = (ComposedSchema)schema;
            return this.getAllPropertiesFromComposedSchema((Schema)composedSchema);
        }
        return schema != null && schema.getProperties() != null ? schema.getProperties() : new HashMap<String, Schema>();
    }
}

