/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.type.generators;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.type.GeneratorConstants;
import io.ballerina.openapi.core.generators.type.TypeGeneratorUtils;
import io.ballerina.openapi.core.generators.type.exception.OASTypeGenException;
import io.ballerina.openapi.core.generators.type.generators.TypeGenerator;
import io.swagger.v3.oas.models.media.Schema;
import java.util.HashMap;
import java.util.List;

public class EnumGenerator
extends TypeGenerator {
    public EnumGenerator(Schema schema, String typeName, boolean ignoreNullableFlag, HashMap<String, TypeDefinitionNode> subTypesMap, HashMap<String, NameReferenceNode> pregeneratedTypeMap) {
        super(schema, typeName, ignoreNullableFlag, subTypesMap, pregeneratedTypeMap);
    }

    @Override
    public TypeDescriptorNode generateTypeDescriptorNode() throws OASTypeGenException {
        List enumList = this.schema.getEnum();
        boolean isNull = false;
        StringBuilder enumBuilder = new StringBuilder();
        if (TypeGeneratorUtils.PRIMITIVE_TYPE_LIST.contains(GeneratorUtils.getOpenAPIType(this.schema))) {
            for (Object enumValue : enumList) {
                isNull = enumValue == null;
                if (isNull) continue;
                if (enumValue instanceof String) {
                    String stringEnumValue = (String)enumValue;
                    stringEnumValue = stringEnumValue.replaceAll("\"", "\\\\\"");
                    enumBuilder.append("\"").append(stringEnumValue).append("\"").append("|");
                    continue;
                }
                enumBuilder.append(enumValue).append("|");
            }
            if (enumBuilder.length() > 0) {
                isNull = !isNull ? this.schema.getNullable() != null && this.schema.getNullable().booleanValue() : isNull;
                enumBuilder.deleteCharAt(enumBuilder.length() - 1);
                Object enumString = isNull ? String.valueOf(enumBuilder) + "?" : enumBuilder.toString();
                return NodeParser.parseTypeDescriptor((String)enumString);
            }
            if (!GeneratorConstants.OPENAPI_TYPE_TO_BAL_TYPE_MAP.containsKey(this.schema.getType().trim())) {
                throw new OASTypeGenException("Unsupported OAS data type `" + this.schema.getType().trim() + "`");
            }
            String typeDescriptorName = GeneratorConstants.OPENAPI_TYPE_TO_BAL_TYPE_MAP.get(GeneratorUtils.getOpenAPIType(this.schema));
            if (isNull) {
                return NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)(typeDescriptorName + "?")));
            }
            SimpleNameReferenceNode typeDescriptorNode = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)typeDescriptorName));
            return TypeGeneratorUtils.getNullableType(this.schema, (TypeDescriptorNode)typeDescriptorNode, this.ignoreNullableFlag);
        }
        throw new OASTypeGenException(String.format("The data type '%s' is not a valid enum type.The supported types are string, integer, number and boolean", GeneratorUtils.getOpenAPIType(this.schema)));
    }
}

