/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.type.generators;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.openapi.core.generators.type.exception.OASTypeGenException;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;

public abstract class TypeGenerator {
    Schema schema;
    String typeName;
    final boolean ignoreNullableFlag;
    final LinkedHashSet<String> imports = new LinkedHashSet();
    final HashMap<String, TypeDefinitionNode> subTypesMap;
    final HashMap<String, NameReferenceNode> pregeneratedTypeMap;
    final List<Diagnostic> diagnostics = new ArrayList<Diagnostic>();

    public TypeGenerator(Schema schema, String typeName, boolean ignoreNullableFlag, HashMap<String, TypeDefinitionNode> subTypesMap, HashMap<String, NameReferenceNode> pregeneratedTypeMap) {
        this.schema = schema;
        this.typeName = typeName;
        this.ignoreNullableFlag = ignoreNullableFlag;
        this.subTypesMap = subTypesMap;
        this.pregeneratedTypeMap = pregeneratedTypeMap;
    }

    public LinkedHashSet<String> getImports() {
        return this.imports;
    }

    public List<Diagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    public TypeDefinitionNode generateTypeDefinitionNode(IdentifierToken typeName) throws OASTypeGenException {
        return NodeFactory.createTypeDefinitionNode(null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)typeName, (Node)this.generateTypeDescriptorNode(), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    public abstract TypeDescriptorNode generateTypeDescriptorNode() throws OASTypeGenException;
}

