/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.compiler;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Documentable;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ObjectConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.graphql.commons.types.Schema;
import io.ballerina.stdlib.graphql.compiler.CacheConfigContext;
import io.ballerina.stdlib.graphql.compiler.ServiceAnalysisTask;
import io.ballerina.stdlib.graphql.compiler.Utils;
import io.ballerina.stdlib.graphql.compiler.schema.generator.GeneratorUtils;
import io.ballerina.stdlib.graphql.compiler.service.InterfaceEntityFinder;
import io.ballerina.stdlib.graphql.compiler.service.validator.ServiceValidator;
import java.util.Map;

public class ModuleLevelVariableDeclarationAnalysisTask
extends ServiceAnalysisTask {
    public ModuleLevelVariableDeclarationAnalysisTask(Map<String, Object> nodeMap) {
        super(nodeMap);
    }

    public void perform(SyntaxNodeAnalysisContext context) {
        if (Utils.hasCompilationErrors(context)) {
            return;
        }
        if (context.node().kind() != SyntaxKind.MODULE_VAR_DECL) {
            return;
        }
        ModuleVariableDeclarationNode moduleVariableDeclarationNode = (ModuleVariableDeclarationNode)context.node();
        if (!io.ballerina.stdlib.graphql.commons.utils.Utils.isGraphQLServiceObjectDeclaration((ModuleVariableDeclarationNode)moduleVariableDeclarationNode)) {
            return;
        }
        if (moduleVariableDeclarationNode.initializer().isEmpty()) {
            return;
        }
        ExpressionNode expressionNode = (ExpressionNode)moduleVariableDeclarationNode.initializer().get();
        if (expressionNode.kind() != SyntaxKind.OBJECT_CONSTRUCTOR) {
            return;
        }
        ObjectConstructorExpressionNode graphqlServiceObjectNode = (ObjectConstructorExpressionNode)expressionNode;
        InterfaceEntityFinder interfaceEntityFinder = this.getInterfaceEntityFinder(context.semanticModel());
        ServiceValidator serviceObjectValidator = this.getServiceValidator(context, (Node)graphqlServiceObjectNode, interfaceEntityFinder, new CacheConfigContext(false));
        if (serviceObjectValidator.isErrorOccurred()) {
            return;
        }
        String description = ModuleLevelVariableDeclarationAnalysisTask.getDescription(context.semanticModel(), moduleVariableDeclarationNode);
        Schema schema = this.generateSchema(context, interfaceEntityFinder, (Node)graphqlServiceObjectNode, description);
        DocumentId documentId = context.documentId();
        this.addToModifierContextMap(documentId, (Node)moduleVariableDeclarationNode, schema);
        this.addToModifierContextMap(documentId, (Node)moduleVariableDeclarationNode, serviceObjectValidator.getCacheConfigContext());
    }

    public static String getDescription(SemanticModel semanticModel, ModuleVariableDeclarationNode moduleVariableDeclarationNode) {
        if (semanticModel.symbol((Node)moduleVariableDeclarationNode).isEmpty()) {
            return null;
        }
        VariableSymbol serviceVariableSymbol = (VariableSymbol)semanticModel.symbol((Node)moduleVariableDeclarationNode).get();
        return GeneratorUtils.getDescription((Documentable)serviceVariableSymbol);
    }
}

