/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.compiler;

import io.ballerina.compiler.api.symbols.Documentable;
import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.graphql.commons.types.Schema;
import io.ballerina.stdlib.graphql.compiler.CacheConfigContext;
import io.ballerina.stdlib.graphql.compiler.ServiceAnalysisTask;
import io.ballerina.stdlib.graphql.compiler.Utils;
import io.ballerina.stdlib.graphql.compiler.schema.generator.GeneratorUtils;
import io.ballerina.stdlib.graphql.compiler.service.InterfaceEntityFinder;
import io.ballerina.stdlib.graphql.compiler.service.validator.ServiceValidator;
import java.util.Map;

public class ServiceDeclarationAnalysisTask
extends ServiceAnalysisTask {
    public ServiceDeclarationAnalysisTask(Map<String, Object> nodeMap) {
        super(nodeMap);
    }

    public void perform(SyntaxNodeAnalysisContext context) {
        InterfaceEntityFinder interfaceEntityFinder;
        if (Utils.hasCompilationErrors(context)) {
            return;
        }
        if (!io.ballerina.stdlib.graphql.commons.utils.Utils.isGraphqlService((SyntaxNodeAnalysisContext)context)) {
            return;
        }
        ServiceDeclarationNode node = (ServiceDeclarationNode)context.node();
        ServiceValidator serviceValidator = this.getServiceValidator(context, (Node)node, interfaceEntityFinder = this.getInterfaceEntityFinder(context.semanticModel()), new CacheConfigContext(false));
        if (serviceValidator.isErrorOccurred()) {
            return;
        }
        ServiceDeclarationSymbol symbol = (ServiceDeclarationSymbol)context.semanticModel().symbol((Node)node).get();
        String description = GeneratorUtils.getDescription((Documentable)symbol);
        Schema schema = this.generateSchema(context, interfaceEntityFinder, (Node)node, description);
        DocumentId documentId = context.documentId();
        this.addToModifierContextMap(documentId, (Node)node, schema);
        this.addToModifierContextMap(documentId, (Node)node, serviceValidator.getCacheConfigContext());
    }
}

