/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.compiler.service.validator;

import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ResourceMethodSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeLocation;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.graphql.compiler.Utils;
import io.ballerina.stdlib.graphql.compiler.diagnostics.CompilationDiagnostic;
import io.ballerina.stdlib.graphql.compiler.service.validator.ValidatorUtils;
import io.ballerina.tools.diagnostics.Location;

public class InterceptorValidator {
    private final ClassDefinitionNode classDefinitionNode;
    private final SyntaxNodeAnalysisContext context;
    private boolean errorOccurred;

    public InterceptorValidator(SyntaxNodeAnalysisContext context, ClassDefinitionNode classDefinitionNode) {
        this.context = context;
        this.classDefinitionNode = classDefinitionNode;
        this.errorOccurred = false;
    }

    public void validate() {
        NodeList members = this.classDefinitionNode.members();
        for (Node member : members) {
            if (member.kind() != SyntaxKind.TYPE_REFERENCE || !this.isInterceptor(member)) continue;
            this.validateInterceptorService((NodeList<Node>)members);
            break;
        }
    }

    public boolean isErrorOccurred() {
        return this.errorOccurred;
    }

    private void validateInterceptorService(NodeList<Node> members) {
        for (Node node : members) {
            this.validateInterceptorServiceMember(node);
        }
    }

    private void validateInterceptorServiceMember(Node node) {
        if (this.context.semanticModel().symbol(node).isEmpty()) {
            return;
        }
        Symbol symbol = (Symbol)this.context.semanticModel().symbol(node).get();
        NodeLocation location = node.location();
        if (symbol.kind() == SymbolKind.METHOD) {
            MethodSymbol methodSymbol = (MethodSymbol)symbol;
            if (Utils.isRemoteMethod(methodSymbol)) {
                this.validateRemoteMethod(methodSymbol, (Location)location);
            }
        } else if (symbol.kind() == SymbolKind.RESOURCE_METHOD) {
            ResourceMethodSymbol resourceMethodSymbol = (ResourceMethodSymbol)symbol;
            String resourceMethodSignature = resourceMethodSymbol.signature();
            this.addDiagnostic(CompilationDiagnostic.RESOURCE_METHOD_INSIDE_INTERCEPTOR, (Location)location, resourceMethodSignature);
        }
    }

    private void validateRemoteMethod(MethodSymbol methodSymbol, Location location) {
        if (methodSymbol.getName().isEmpty()) {
            return;
        }
        if (!((String)methodSymbol.getName().get()).equals("execute")) {
            this.addDiagnostic(CompilationDiagnostic.INVALID_REMOTE_METHOD_INSIDE_INTERCEPTOR, location, methodSymbol.signature());
        }
    }

    public boolean isInterceptor(Node member) {
        if (this.context.semanticModel().symbol(member).isEmpty()) {
            return false;
        }
        Symbol symbol = (Symbol)this.context.semanticModel().symbol(member).get();
        TypeReferenceTypeSymbol typeReferenceTypeSymbol = (TypeReferenceTypeSymbol)symbol;
        if (typeReferenceTypeSymbol.getName().isEmpty()) {
            return false;
        }
        if (!io.ballerina.stdlib.graphql.commons.utils.Utils.isGraphqlModuleSymbol((Symbol)typeReferenceTypeSymbol)) {
            return false;
        }
        return "Interceptor".equals(typeReferenceTypeSymbol.getName().get());
    }

    private void addDiagnostic(CompilationDiagnostic compilationDiagnostic, Location location, Object ... args) {
        this.errorOccurred = true;
        ValidatorUtils.updateContext(this.context, compilationDiagnostic, location, args);
    }
}

