/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.compiler.service.validator;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ListenerDeclarationNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.graphql.compiler.Utils;
import io.ballerina.stdlib.graphql.compiler.diagnostics.CompilationDiagnostic;
import io.ballerina.stdlib.graphql.compiler.service.validator.ValidatorUtils;
import io.ballerina.tools.diagnostics.Location;

public class ListenerValidator
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    private static final String LISTEN_TO = "listenTo";

    public void perform(SyntaxNodeAnalysisContext context) {
        if (context.node().kind() == SyntaxKind.EXPLICIT_NEW_EXPRESSION) {
            ExplicitNewExpressionNode node = (ExplicitNewExpressionNode)context.node();
            this.validateExplicitNewListener(context, node);
        } else if (context.node().kind() == SyntaxKind.IMPLICIT_NEW_EXPRESSION) {
            ImplicitNewExpressionNode node = (ImplicitNewExpressionNode)context.node();
            this.validateImplicitNewExpression(context, node);
        }
    }

    private void validateExplicitNewListener(SyntaxNodeAnalysisContext context, ExplicitNewExpressionNode node) {
        if (context.semanticModel().symbol((Node)node.typeDescriptor()).isEmpty()) {
            return;
        }
        Symbol listenerSymbol = (Symbol)context.semanticModel().symbol((Node)node.typeDescriptor()).get();
        if (!Utils.isGraphqlListener(listenerSymbol)) {
            return;
        }
        SeparatedNodeList functionArgs = node.parenthesizedArgList().arguments();
        this.validateListenerArguments(context, (SeparatedNodeList<FunctionArgumentNode>)functionArgs);
    }

    private void validateImplicitNewExpression(SyntaxNodeAnalysisContext context, ImplicitNewExpressionNode node) {
        ListenerDeclarationNode listenerDeclarationNode;
        if (node.parent().kind() == SyntaxKind.CHECK_EXPRESSION) {
            if (node.parent().parent().kind() != SyntaxKind.LISTENER_DECLARATION) {
                return;
            }
            listenerDeclarationNode = (ListenerDeclarationNode)node.parent().parent();
        } else {
            if (node.parent().kind() != SyntaxKind.LISTENER_DECLARATION) {
                return;
            }
            listenerDeclarationNode = (ListenerDeclarationNode)node.parent();
        }
        this.validateImplicitNewListener(context, node, listenerDeclarationNode);
    }

    private void validateImplicitNewListener(SyntaxNodeAnalysisContext context, ImplicitNewExpressionNode node, ListenerDeclarationNode listenerDeclarationNode) {
        if (listenerDeclarationNode.typeDescriptor().isEmpty()) {
            return;
        }
        if (context.semanticModel().symbol((Node)listenerDeclarationNode.typeDescriptor().get()).isEmpty()) {
            return;
        }
        Symbol listenerSymbol = (Symbol)context.semanticModel().symbol((Node)listenerDeclarationNode.typeDescriptor().get()).get();
        if (!Utils.isGraphqlListener(listenerSymbol)) {
            return;
        }
        if (node.parenthesizedArgList().isEmpty()) {
            return;
        }
        SeparatedNodeList functionArgs = ((ParenthesizedArgList)node.parenthesizedArgList().get()).arguments();
        this.validateListenerArguments(context, (SeparatedNodeList<FunctionArgumentNode>)functionArgs);
    }

    private void validateListenerArguments(SyntaxNodeAnalysisContext context, SeparatedNodeList<FunctionArgumentNode> arguments) {
        if (arguments.size() < 2) {
            return;
        }
        FunctionArgumentNode firstArg = (FunctionArgumentNode)arguments.get(0);
        if (firstArg.kind() == SyntaxKind.POSITIONAL_ARG) {
            PositionalArgumentNode positionalArgumentNode = (PositionalArgumentNode)firstArg;
            if (context.semanticModel().symbol((Node)positionalArgumentNode.expression()).isEmpty()) {
                return;
            }
            Symbol firstArgSymbol = (Symbol)context.semanticModel().symbol((Node)positionalArgumentNode.expression()).get();
            this.validateListenerArgSymbol(context, firstArgSymbol, (Location)positionalArgumentNode.location());
        } else if (firstArg.kind() == SyntaxKind.NAMED_ARG) {
            this.validateListenerNamedArguments(context, arguments);
        }
    }

    private void validateListenerNamedArguments(SyntaxNodeAnalysisContext context, SeparatedNodeList<FunctionArgumentNode> arguments) {
        for (FunctionArgumentNode argument : arguments) {
            NamedArgumentNode namedArgument = (NamedArgumentNode)argument;
            String argumentName = namedArgument.argumentName().name().text();
            if (!argumentName.equals(LISTEN_TO)) continue;
            if (context.semanticModel().symbol((Node)namedArgument.expression()).isEmpty()) {
                return;
            }
            Symbol argumentNodeSymbol = (Symbol)context.semanticModel().symbol((Node)namedArgument.expression()).get();
            this.validateListenerArgSymbol(context, argumentNodeSymbol, (Location)namedArgument.location());
        }
    }

    private void validateListenerArgSymbol(SyntaxNodeAnalysisContext context, Symbol argumentNodeSymbol, Location location) {
        VariableSymbol variableSymbol;
        if (argumentNodeSymbol.kind() == SymbolKind.VARIABLE && (variableSymbol = (VariableSymbol)argumentNodeSymbol).typeDescriptor().typeKind() != TypeDescKind.INT) {
            ValidatorUtils.updateContext(context, CompilationDiagnostic.INVALID_LISTENER_INIT, location);
        }
    }
}

