/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.compiler.service.validator;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.RecordFieldWithDefaultValueNode;
import java.util.Optional;

public class RecordFieldWithDefaultValueVisitor
extends NodeVisitor {
    private final SemanticModel semanticModel;
    private final String fieldName;
    private RecordFieldWithDefaultValueNode recordFieldNode;

    public RecordFieldWithDefaultValueVisitor(SemanticModel semanticModel, String fieldName) {
        this.semanticModel = semanticModel;
        this.fieldName = fieldName;
    }

    public void visit(RecordFieldWithDefaultValueNode recordFieldNode) {
        if (this.recordFieldNode != null) {
            return;
        }
        Optional symbol = this.semanticModel.symbol((Node)recordFieldNode);
        if (symbol.isPresent() && this.fieldName.equals(((Symbol)symbol.get()).getName().orElse(null))) {
            this.recordFieldNode = recordFieldNode;
        }
    }

    public Optional<RecordFieldWithDefaultValueNode> getRecordFieldNode() {
        return Optional.ofNullable(this.recordFieldNode);
    }
}

