/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.configurable.providers.toml;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.internal.configurable.providers.toml.ConfigToml;
import io.ballerina.runtime.internal.configurable.providers.toml.TomlProvider;
import java.util.Set;
import java.util.regex.Pattern;

public class TomlContentProvider
extends TomlProvider {
    private final String configContent;
    private static final Pattern UNESCAPED_NEWLINE_CHAR = Pattern.compile("\\\\n(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)");
    private static final Pattern UNESCAPED_CARRIAGE_CHAR = Pattern.compile("(\\\\r|\\\\t)(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)");

    public TomlContentProvider(Module rootModule, String configContent, Set<Module> moduleSet) {
        super(rootModule, moduleSet);
        this.configContent = this.cleanContent(configContent);
    }

    private String cleanContent(String configContent) {
        String content = UNESCAPED_NEWLINE_CHAR.matcher(configContent).replaceAll(System.lineSeparator());
        return UNESCAPED_CARRIAGE_CHAR.matcher(content).replaceAll("");
    }

    @Override
    public void initialize() {
        if (this.configContent.isEmpty()) {
            return;
        }
        this.tomlNode = new ConfigToml(this.configContent).tomlAstNode();
        super.initialize();
    }
}

