/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.diagnostics;

import io.ballerina.runtime.internal.diagnostics.RuntimeDiagnostic;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class RuntimeDiagnosticLog {
    private final List<RuntimeDiagnostic> diagnosticList = new LinkedList<RuntimeDiagnostic>();
    private int errorCount = 0;
    private int warnCount = 0;

    public void error(ErrorCodes errorCode, String location, Object ... args) {
        ++this.errorCount;
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(errorCode.diagnosticId(), errorCode.messageKey(), DiagnosticSeverity.ERROR);
        this.diagnosticList.add(new RuntimeDiagnostic(diagnosticInfo, location, args));
    }

    public void warn(ErrorCodes errorCode, String location, Object ... args) {
        ++this.warnCount;
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(errorCode.diagnosticId(), errorCode.messageKey(), DiagnosticSeverity.WARNING);
        this.diagnosticList.add(new RuntimeDiagnostic(diagnosticInfo, location, args));
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getWarningCount() {
        return this.warnCount;
    }

    public List<RuntimeDiagnostic> getDiagnosticList() {
        return new ArrayList<RuntimeDiagnostic>(this.diagnosticList);
    }
}

