/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.errors;

import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BString;

public final class ErrorReasons {
    private static final String BALLERINA_PREFIX = "{ballerina}";
    private static final String BALLERINA_ORG_PREFIX = "{ballerina/";
    private static final String CLOSING_CURLY_BRACE = "}";
    public static final BString TYPE_CAST_ERROR = StringUtils.fromString("{ballerina}".concat("TypeCastError"));
    public static final BString NUMBER_CONVERSION_ERROR = StringUtils.fromString("{ballerina}".concat("NumberConversionError"));
    public static final BString JSON_OPERATION_ERROR = StringUtils.fromString("{ballerina}".concat("JSONOperationError"));
    public static final BString DIVISION_BY_ZERO_ERROR = StringUtils.fromString("{ballerina}".concat("DivisionByZero"));
    public static final String NUMBER_OVERFLOW_ERROR_IDENTIFIER = "NumberOverflow";
    public static final String CYCLIC_VALUE_REFERENCE_ERROR = "CyclicValueReferenceError";
    public static final BString NUMBER_OVERFLOW = StringUtils.fromString("{ballerina}".concat("NumberOverflow"));
    public static final BString LARGE_EXPONENT_ERROR = StringUtils.fromString("{ballerina}".concat("DecimalExponentError"));
    public static final BString ARITHMETIC_OPERATION_ERROR = StringUtils.fromString("{ballerina}".concat("ArithmeticOperationError"));
    public static final BString QUANTIZE_ERROR = ErrorReasons.getModulePrefixedReason("lang.decimal", "QuantizeError");
    public static final BString JAVA_NULL_REFERENCE_ERROR = StringUtils.fromString("{ballerina}".concat("JavaNullReferenceError"));
    public static final String JAVA_CLASS_NOT_FOUND_ERROR = "{ballerina}".concat("JavaClassNotFoundError");
    public static final BString JAVA_OUT_OF_MEMORY_ERROR = StringUtils.fromString("{ballerina}".concat("OutOfMemoryError"));
    public static final BString BALLERINA_PREFIXED_CONVERSION_ERROR = StringUtils.fromString("{ballerina}".concat("ConversionError"));
    public static final BString BALLERINA_PREFIXED_CYCLIC_VALUE_REFERENCE_ERROR = StringUtils.fromString("{ballerina}".concat("CyclicValueReferenceError"));
    public static final BString ITERATOR_MUTABILITY_ERROR = StringUtils.fromString("{ballerina}".concat("IteratorMutabilityError"));
    public static final String NUMBER_PARSING_ERROR_IDENTIFIER = "NumberParsingError";
    public static final String BOOLEAN_PARSING_ERROR_IDENTIFIER = "BooleanParsingError";
    public static final String INVALID_UPDATE_ERROR_IDENTIFIER = "InvalidUpdate";
    public static final String INDEX_OUT_OF_RANGE_ERROR_IDENTIFIER = "IndexOutOfRange";
    public static final String INHERENT_TYPE_VIOLATION_ERROR_IDENTIFIER = "InherentTypeViolation";
    public static final String INCOMPATIBLE_ARGUMENTS = "IncompatibleArguments";
    public static final String OPERATION_NOT_SUPPORTED_IDENTIFIER = "OperationNotSupported";
    public static final String KEY_NOT_FOUND_ERROR_IDENTIFIER = "KeyNotFound";
    public static final String INVALID_TYPE_TO_SORT = "SortOperationError";
    public static final String UNORDERED_TYPES = "UnorderedTypesError";
    public static final String LENGTH_GREATER_THAT_2147483647_NOT_YET_SUPPORTED = "length greater that '2147483647' not yet supported";
    public static final BString INDEX_OUT_OF_RANGE_ERROR = StringUtils.fromString("IndexOutOfRange");
    public static final BString OPERATION_NOT_SUPPORTED_ERROR = StringUtils.fromString("OperationNotSupported");
    public static final BString JSON_CONVERSION_ERROR = StringUtils.fromString("{ballerina}".concat("JSONConversionError"));
    public static final BString STACK_OVERFLOW_ERROR = StringUtils.fromString("{ballerina}".concat("StackOverflow"));
    public static final BString VALUE_LANG_LIB_CONVERSION_ERROR = ErrorReasons.getModulePrefixedReason("lang.value", "ConversionError");
    public static final BString VALUE_LANG_LIB_CYCLIC_VALUE_REFERENCE_ERROR = ErrorReasons.getModulePrefixedReason("lang.value", "CyclicValueReferenceError");
    public static final BString MERGE_JSON_ERROR = ErrorReasons.getModulePrefixedReason("lang.value", "MergeJsonError");
    public static final BString FROM_BAL_STRING_ERROR = ErrorReasons.getModulePrefixedReason("lang.value", "FromBalStringError");
    public static final BString STRING_OPERATION_ERROR = ErrorReasons.getModulePrefixedReason("lang.string", "StringOperationError");
    public static final BString XML_OPERATION_ERROR = ErrorReasons.getModulePrefixedReason("lang.xml", "XMLOperationError");
    public static final BString MAP_KEY_NOT_FOUND_ERROR = ErrorReasons.getModulePrefixedReason("lang.map", "KeyNotFound");
    public static final BString TABLE_KEY_NOT_FOUND_ERROR = ErrorReasons.getModulePrefixedReason("lang.table", "KeyNotFound");
    public static final BString TABLE_KEY_CYCLIC_VALUE_REFERENCE_ERROR = ErrorReasons.getModulePrefixedReason("lang.table", "CyclicValueReferenceError");
    public static final BString TABLE_HAS_A_VALUE_FOR_KEY_ERROR = ErrorReasons.getModulePrefixedReason("lang.table", "KeyConstraintViolation");
    public static final BString ILLEGAL_LIST_INSERTION_ERROR = ErrorReasons.getModulePrefixedReason("lang.array", "IllegalListInsertion");
    public static final BString FUTURE_CANCELLED = ErrorReasons.getModulePrefixedReason("lang.future", "FutureAlreadyCancelled");
    public static final BString ASYNC_CALL_INSIDE_LOCK = StringUtils.fromString("{ballerina}".concat("AsyncCallInsideLockError"));
    public static final BString UNORDERED_TYPES_ERROR = StringUtils.fromString("UnorderedTypesError");
    public static final BString UNSUPPORTED_DECIMAL_ERROR = StringUtils.fromString("{ballerina}".concat("UnsupportedDecimalError"));
    public static final String INVALID_FRACTION_DIGITS_ERROR = "InvalidFractionDigits";
    public static final BString FAILED_TO_DECODE_BYTES = StringUtils.fromString("FailedToDecodeBytes");
    public static final String REG_EXP_PARSING_ERROR_IDENTIFIER = "RegularExpressionParsingError";
    public static final BString REG_EXP_PARSING_ERROR = StringUtils.fromString("{ballerina}".concat("RegularExpressionParsingError"));
    public static final BString REGEXP_OPERATION_ERROR = ErrorReasons.getModulePrefixedReason("lang.regexp", "RegularExpressionOperationError");
    public static final BString NO_MESSAGE_ERROR = StringUtils.fromString("NoMessage");

    private ErrorReasons() {
    }

    public static BString getModulePrefixedReason(String moduleName, String identifier) {
        return StringUtils.fromString(BALLERINA_ORG_PREFIX.concat(moduleName).concat(CLOSING_CURLY_BRACE).concat(identifier));
    }
}

