/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.json;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.TableType;
import io.ballerina.runtime.api.types.TupleType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.JsonUtils;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BListInitialValueEntry;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.TypeConverter;
import io.ballerina.runtime.internal.commons.TypeValuePair;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import io.ballerina.runtime.internal.errors.ErrorReasons;
import io.ballerina.runtime.internal.json.ParserException;
import io.ballerina.runtime.internal.json.StateMachine;
import io.ballerina.runtime.internal.regexp.RegExpFactory;
import io.ballerina.runtime.internal.types.BArrayType;
import io.ballerina.runtime.internal.types.BIntersectionType;
import io.ballerina.runtime.internal.types.BMapType;
import io.ballerina.runtime.internal.types.BRecordType;
import io.ballerina.runtime.internal.utils.CloneUtils;
import io.ballerina.runtime.internal.utils.ErrorUtils;
import io.ballerina.runtime.internal.utils.ValueConverter;
import io.ballerina.runtime.internal.utils.ValueUtils;
import io.ballerina.runtime.internal.values.ArrayValue;
import io.ballerina.runtime.internal.values.ArrayValueImpl;
import io.ballerina.runtime.internal.values.DecimalValue;
import io.ballerina.runtime.internal.values.MapValueImpl;
import io.ballerina.runtime.internal.values.ReadOnlyUtils;
import io.ballerina.runtime.internal.values.TableValueImpl;
import io.ballerina.runtime.internal.values.TupleValueImpl;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class JsonParser {
    private static final ThreadLocal<JsonStateMachine> tlStateMachine = ThreadLocal.withInitial(JsonStateMachine::new);

    private JsonParser() {
    }

    public static Object parse(InputStream in, Type targetType) throws BError {
        return JsonParser.parse(in, Charset.defaultCharset().name(), targetType);
    }

    public static Object parse(InputStream in, String charsetName, Type targetType) throws BError {
        try {
            return JsonParser.parse((Reader)new InputStreamReader((InputStream)new BufferedInputStream(in), charsetName), targetType);
        }
        catch (IOException e) {
            throw ErrorCreator.createError(StringUtils.fromString("error in parsing input stream: " + e.getMessage()));
        }
    }

    public static Object parse(String jsonStr) throws BError {
        return JsonParser.parse(jsonStr, (Type)PredefinedTypes.TYPE_JSON);
    }

    public static Object parse(String str, Type targetType) throws BError {
        return JsonParser.parse((Reader)new StringReader(str), targetType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object parse(Reader reader, Type targetType, JsonUtils.NonStringValueProcessingMode mode) throws BError {
        JsonStateMachine sm = tlStateMachine.get();
        try {
            sm.addTargetType(targetType);
            JsonStateMachine.mode = mode;
            Object object = sm.execute(reader);
            return object;
        }
        finally {
            sm.reset();
            tlStateMachine.remove();
        }
    }

    public static Object parse(Reader reader, JsonUtils.NonStringValueProcessingMode mode) {
        return JsonParser.parse(reader, JsonParser.getTargetType(mode), mode);
    }

    public static Object parse(Reader reader, Type targetType) throws BError {
        return JsonParser.parse(reader, targetType, JsonUtils.NonStringValueProcessingMode.FROM_JSON_STRING);
    }

    private static Type getTargetType(JsonUtils.NonStringValueProcessingMode mode) {
        Type targetType = mode == JsonUtils.NonStringValueProcessingMode.FROM_JSON_DECIMAL_STRING ? PredefinedTypes.TYPE_JSON_DECIMAL : (mode == JsonUtils.NonStringValueProcessingMode.FROM_JSON_FLOAT_STRING ? PredefinedTypes.TYPE_JSON_FLOAT : PredefinedTypes.TYPE_JSON);
        return targetType;
    }

    private static class JsonStateMachine
    extends StateMachine {
        private static final String UNSUPPORTED_TYPE = "unsupported type: ";
        private static final String ARRAY_SIZE_MISMATCH = "array size is not enough for the provided values";
        private static final String TUPLE_SIZE_MISMATCH = "tuple size is not enough for the provided values";
        private static final String UNEXPECTED_END_OF_THE_INPUT_STREAM = "unexpected end of the input stream";
        private static final String UNRECOGNIZED_TOKEN = "unrecognized token '";
        List<Type> targetTypes = new ArrayList<Type>();
        List<Integer> listIndices = new ArrayList<Integer>();
        private int nodesStackSizeWhenUnionStarts = -1;
        private static JsonUtils.NonStringValueProcessingMode mode = JsonUtils.NonStringValueProcessingMode.FROM_JSON_STRING;

        JsonStateMachine() {
            super("input stream", new FieldNameState(), new StringValueState(), new StringFieldValueState(), new StringArrayElementState());
        }

        @Override
        public void reset() {
            super.reset();
            this.targetTypes.clear();
            this.nodesStackSizeWhenUnionStarts = -1;
            this.listIndices.clear();
        }

        private void addTargetType(Type type) {
            this.targetTypes.add(TypeUtils.getImpliedType(type));
        }

        private static ParserException getConversionError(Type targetType, String inputValue) {
            return new ParserException("value '" + inputValue + "' cannot be converted to '" + String.valueOf(targetType) + "'");
        }

        private static Object convertValues(Type targetType, String inputValue) throws ParserException {
            return switch (targetType.getTag()) {
                case 1, 7, 8, 9, 10, 11, 12 -> JsonStateMachine.convertToInt(targetType, inputValue);
                case 4 -> JsonStateMachine.convertToDecimal(targetType, inputValue);
                case 3 -> JsonStateMachine.convertToFloat(targetType, inputValue);
                case 6 -> JsonStateMachine.convertToBoolean(targetType, inputValue);
                case 14 -> JsonStateMachine.convertToNull(targetType, inputValue);
                case 2 -> JsonStateMachine.convertToByte(targetType, inputValue);
                case 33, 46 -> {
                    Object jsonVal = JsonStateMachine.getNonStringValueAsJson(inputValue);
                    yield JsonStateMachine.convert(jsonVal, targetType);
                }
                case 15, 23 -> JsonStateMachine.getNonStringValueAsJson(inputValue);
                default -> throw JsonStateMachine.getConversionError(targetType, inputValue);
            };
        }

        private static int convertToByte(Type targetType, String inputValue) throws ParserException {
            try {
                int parsedInt = Integer.parseInt(inputValue);
                if (!TypeChecker.isByteLiteral(parsedInt)) {
                    throw JsonStateMachine.getConversionError(targetType, inputValue);
                }
                return parsedInt;
            }
            catch (NumberFormatException e) {
                throw JsonStateMachine.getConversionError(targetType, inputValue);
            }
        }

        private static Object convertToNull(Type targetType, String inputValue) throws ParserException {
            if (inputValue.charAt(0) == 'n' && "null".equals(inputValue)) {
                return null;
            }
            throw JsonStateMachine.getConversionError(targetType, inputValue);
        }

        private static Boolean convertToBoolean(Type targetType, String inputValue) throws ParserException {
            char ch = inputValue.charAt(0);
            if (ch == 't' && "true".equals(inputValue)) {
                return Boolean.TRUE;
            }
            if (ch == 'f' && "false".equals(inputValue)) {
                return Boolean.FALSE;
            }
            throw JsonStateMachine.getConversionError(targetType, inputValue);
        }

        private static double convertToFloat(Type targetType, String inputValue) throws ParserException {
            try {
                return Double.parseDouble(inputValue);
            }
            catch (NumberFormatException e) {
                throw JsonStateMachine.getConversionError(targetType, inputValue);
            }
        }

        private static DecimalValue convertToDecimal(Type targetType, String inputValue) throws ParserException {
            try {
                return new DecimalValue(inputValue);
            }
            catch (NumberFormatException e) {
                throw JsonStateMachine.getConversionError(targetType, inputValue);
            }
        }

        private static long convertToInt(Type targetType, String inputValue) throws ParserException {
            try {
                long parsedLong = Long.parseLong(inputValue);
                if (!TypeConverter.isConvertibleToIntRange(targetType, parsedLong)) {
                    throw JsonStateMachine.getConversionError(targetType, inputValue);
                }
                return parsedLong;
            }
            catch (NumberFormatException e) {
                throw JsonStateMachine.getConversionError(targetType, inputValue);
            }
        }

        @Override
        protected StateMachine.State finalizeObject() throws ParserException {
            Type targetType = this.targetTypes.get(this.targetTypes.size() - 1);
            switch (targetType.getTag()) {
                case 17: 
                case 33: 
                case 46: {
                    this.processUnionTableFiniteType(targetType);
                    break;
                }
                case 15: 
                case 23: {
                    this.processJsonAnydataType();
                    break;
                }
                case 27: {
                    this.targetTypes.remove(this.targetTypes.size() - 1);
                    break;
                }
                case 24: {
                    this.targetTypes.remove(this.targetTypes.size() - 1);
                    this.processRecordType(targetType);
                    break;
                }
                case 32: {
                    this.targetTypes.remove(this.targetTypes.size() - 1);
                    this.processArrayType((ArrayType)targetType);
                    break;
                }
                default: {
                    this.processTupleType((TupleType)targetType);
                }
            }
            if (this.nodesStack.isEmpty()) {
                return DOC_END_STATE;
            }
            Object parentNode = this.nodesStack.pop();
            Type parentTargetType = this.targetTypes.get(this.targetTypes.size() - 1);
            return switch (parentTargetType.getTag()) {
                case 24, 27 -> {
                    ((MapValueImpl)parentNode).putForcefully(StringUtils.fromString((String)this.fieldNames.pop()), this.currentJsonNode);
                    this.currentJsonNode = parentNode;
                    yield FIELD_END_STATE;
                }
                case 32 -> {
                    int listIndex = this.listIndices.get(this.listIndices.size() - 1);
                    ((ArrayValueImpl)parentNode).addRefValue(listIndex, this.currentJsonNode);
                    this.listIndices.set(this.listIndices.size() - 1, listIndex + 1);
                    this.currentJsonNode = parentNode;
                    yield ARRAY_ELEMENT_END_STATE;
                }
                case 15, 17, 23, 33, 46 -> {
                    if (TypeUtils.getImpliedType(TypeChecker.getType(parentNode)).getTag() == 27) {
                        ((MapValueImpl)parentNode).putForcefully(StringUtils.fromString((String)this.fieldNames.pop()), this.currentJsonNode);
                        this.currentJsonNode = parentNode;
                        yield FIELD_END_STATE;
                    }
                    ArrayValueImpl arrayValue = (ArrayValueImpl)parentNode;
                    arrayValue.addRefValueForcefully(arrayValue.size(), this.currentJsonNode);
                    this.currentJsonNode = parentNode;
                    yield ARRAY_ELEMENT_END_STATE;
                }
                default -> {
                    int tupleListIndex = this.listIndices.get(this.listIndices.size() - 1);
                    ((TupleValueImpl)parentNode).addRefValue(tupleListIndex, this.currentJsonNode);
                    this.listIndices.set(this.listIndices.size() - 1, tupleListIndex + 1);
                    this.currentJsonNode = parentNode;
                    yield ARRAY_ELEMENT_END_STATE;
                }
            };
        }

        private void processTupleType(TupleType targetType) throws ParserException {
            this.targetTypes.remove(this.targetTypes.size() - 1);
            int tupleListIndex = this.listIndices.remove(this.listIndices.size() - 1);
            int targetTupleSize = targetType.getTupleTypes().size();
            if (targetTupleSize > tupleListIndex) {
                throw new ParserException("missing required number of values for the '" + String.valueOf(targetType) + "' tuple");
            }
        }

        private void processArrayType(ArrayType targetType) throws ParserException {
            int listIndex = this.listIndices.remove(this.listIndices.size() - 1);
            int targetSize = targetType.getSize();
            if (targetType.getState() == ArrayType.ArrayState.CLOSED && targetSize > listIndex && !targetType.hasFillerValue()) {
                throw new ParserException("missing required number of values for the '" + String.valueOf(targetType) + "' array which does not have a filler value");
            }
        }

        private void processRecordType(Type targetType) throws ParserException {
            BRecordType recordType = (BRecordType)targetType;
            BMap constructedMap = (BMap)this.currentJsonNode;
            ArrayList<String> notProvidedFields = new ArrayList<String>();
            for (Map.Entry<String, Field> stringFieldEntry : recordType.getFields().entrySet()) {
                String fieldName = stringFieldEntry.getKey();
                BString bFieldName = StringUtils.fromString(fieldName);
                if (constructedMap.containsKey(bFieldName)) continue;
                long fieldFlags = stringFieldEntry.getValue().getFlags();
                if (SymbolFlags.isFlagOn(fieldFlags, 256L)) {
                    throw new ParserException("missing required field '" + fieldName + "' of type '" + stringFieldEntry.getValue().getFieldType().toString() + "' in record '" + String.valueOf(targetType) + "'");
                }
                if (SymbolFlags.isFlagOn(fieldFlags, 4096L)) continue;
                notProvidedFields.add(fieldName);
            }
            BMap<BString, Object> recordValue = ValueUtils.createRecordValueWithDefaultValues(recordType.getPackage(), recordType.getName(), notProvidedFields);
            for (Map.Entry fieldEntry : constructedMap.entrySet()) {
                recordValue.populateInitialValue((BString)fieldEntry.getKey(), fieldEntry.getValue());
            }
            if (recordType.isReadOnly()) {
                recordValue.freezeDirect();
            }
            this.currentJsonNode = recordValue;
        }

        private void processJsonAnydataType() {
            if (this.nodesStackSizeWhenUnionStarts == this.nodesStack.size()) {
                this.targetTypes.remove(this.targetTypes.size() - 1);
                this.nodesStackSizeWhenUnionStarts = -1;
            }
        }

        private void processUnionTableFiniteType(Type targetType) {
            if (this.nodesStackSizeWhenUnionStarts == this.nodesStack.size()) {
                this.targetTypes.remove(this.targetTypes.size() - 1);
                this.currentJsonNode = JsonStateMachine.convert(this.currentJsonNode, targetType);
                this.nodesStackSizeWhenUnionStarts = -1;
            }
        }

        @Override
        protected StateMachine.State initNewObject() throws ParserException {
            if (this.charBuffIndex != 0) {
                throw new ParserException("unrecognized token '{'");
            }
            if (this.currentJsonNode != null) {
                this.handleCurrentJsonNodeForObject();
            }
            Type targetType = this.targetTypes.get(this.targetTypes.size() - 1);
            this.initializeCurrentJsonNodeForObject(targetType);
            return FIRST_FIELD_READY_STATE;
        }

        private void initializeCurrentJsonNodeForObject(Type targetType) throws ParserException {
            int targetTypeTag = targetType.getTag();
            switch (targetTypeTag) {
                case 24: 
                case 27: {
                    this.currentJsonNode = new MapValueImpl(targetType);
                    break;
                }
                case 15: 
                case 17: 
                case 23: 
                case 33: 
                case 46: {
                    this.currentJsonNode = targetType.isReadOnly() && (targetTypeTag == 15 || targetTypeTag == 23) ? new MapValueImpl(new BMapType(PredefinedTypes.TYPE_READONLY_JSON, true)) : new MapValueImpl(new BMapType(PredefinedTypes.TYPE_JSON));
                    if (this.nodesStackSizeWhenUnionStarts != -1) break;
                    this.nodesStackSizeWhenUnionStarts = this.nodesStack.size();
                    break;
                }
                default: {
                    throw new ParserException(UNSUPPORTED_TYPE + String.valueOf(targetType) + "'");
                }
            }
        }

        private void handleCurrentJsonNodeForObject() throws ParserException {
            this.nodesStack.push(this.currentJsonNode);
            Type lastTargetType = this.targetTypes.get(this.targetTypes.size() - 1);
            switch (lastTargetType.getTag()) {
                case 32: {
                    int listIndex = this.listIndices.get(this.listIndices.size() - 1);
                    ArrayType arrayType = (ArrayType)lastTargetType;
                    int targetSize = arrayType.getSize();
                    if (arrayType.getState() == ArrayType.ArrayState.CLOSED && targetSize <= listIndex) {
                        throw new ParserException("'" + String.valueOf(arrayType) + "' array size is not enough for the provided values");
                    }
                    Type elementType = TypeUtils.getImpliedType(arrayType.getElementType());
                    this.addTargetType(elementType);
                    break;
                }
                case 44: {
                    Type tupleElementType;
                    boolean noRestType;
                    int tupleListIndex = this.listIndices.get(this.listIndices.size() - 1);
                    TupleType tupleType = (TupleType)lastTargetType;
                    List<Type> tupleTypes = tupleType.getTupleTypes();
                    int targetTupleSize = tupleTypes.size();
                    Type tupleRestType = tupleType.getRestType();
                    boolean bl = noRestType = tupleRestType == null;
                    if (targetTupleSize <= tupleListIndex) {
                        if (noRestType) {
                            throw new ParserException("'" + String.valueOf(tupleType) + "' tuple tuple size is not enough for the provided values");
                        }
                        tupleElementType = TypeUtils.getImpliedType(tupleRestType);
                    } else {
                        tupleElementType = TypeUtils.getImpliedType(tupleTypes.get(tupleListIndex));
                    }
                    this.addTargetType(tupleElementType);
                    break;
                }
                case 27: {
                    this.addTargetType(((MapType)lastTargetType).getConstrainedType());
                    break;
                }
                case 24: {
                    BRecordType recordType = (BRecordType)lastTargetType;
                    String fieldName = (String)this.fieldNames.getFirst();
                    Map<String, Field> fields = recordType.getFields();
                    Field field = fields.get(fieldName);
                    if (field == null) {
                        this.addTargetType(recordType.restFieldType);
                        break;
                    }
                    this.addTargetType(field.getFieldType());
                    break;
                }
                case 15: 
                case 17: 
                case 23: 
                case 33: 
                case 46: {
                    break;
                }
                default: {
                    throw new ParserException(UNSUPPORTED_TYPE + String.valueOf(lastTargetType) + "'");
                }
            }
        }

        @Override
        protected StateMachine.State initNewArray() throws ParserException {
            if (this.charBuffIndex != 0) {
                throw new ParserException("unrecognized token '['");
            }
            if (this.currentJsonNode != null) {
                this.handleCurrentJsonNodeForArray();
            }
            Type targetType = this.targetTypes.get(this.targetTypes.size() - 1);
            this.initializeCurrentJsonNodeForArray(targetType);
            return FIRST_ARRAY_ELEMENT_READY_STATE;
        }

        private void initializeCurrentJsonNodeForArray(Type targetType) throws ParserException {
            int targetTypeTag = targetType.getTag();
            switch (targetTypeTag) {
                case 32: {
                    this.currentJsonNode = new ArrayValueImpl((ArrayType)targetType);
                    this.listIndices.add(0);
                    break;
                }
                case 44: {
                    this.currentJsonNode = new TupleValueImpl((TupleType)targetType);
                    this.listIndices.add(0);
                    break;
                }
                case 15: 
                case 17: 
                case 23: 
                case 33: 
                case 46: {
                    this.currentJsonNode = targetType.isReadOnly() && (targetTypeTag == 15 || targetTypeTag == 23) ? new ArrayValueImpl(new BArrayType((Type)PredefinedTypes.TYPE_READONLY_JSON, true)) : new ArrayValueImpl(new BArrayType(PredefinedTypes.TYPE_JSON));
                    if (this.nodesStackSizeWhenUnionStarts != -1) break;
                    this.nodesStackSizeWhenUnionStarts = this.nodesStack.size();
                    break;
                }
                default: {
                    throw new ParserException("target type is not array type");
                }
            }
        }

        private void handleCurrentJsonNodeForArray() throws ParserException {
            this.nodesStack.push(this.currentJsonNode);
            Type lastTargetType = this.targetTypes.get(this.targetTypes.size() - 1);
            switch (lastTargetType.getTag()) {
                case 32: {
                    int listIndex = this.listIndices.get(this.listIndices.size() - 1);
                    ArrayType arrayType = (ArrayType)lastTargetType;
                    int targetSize = arrayType.getSize();
                    if (arrayType.getState() == ArrayType.ArrayState.CLOSED && targetSize <= listIndex) {
                        throw new ParserException("'" + String.valueOf(arrayType) + "' array size is not enough for the provided values");
                    }
                    Type elementType = TypeUtils.getImpliedType(arrayType.getElementType());
                    this.addTargetType(elementType);
                    break;
                }
                case 44: {
                    Type tupleElementType;
                    boolean noRestType;
                    int tupleListIndex = this.listIndices.get(this.listIndices.size() - 1);
                    TupleType tupleType = (TupleType)lastTargetType;
                    List<Type> tupleTypes = tupleType.getTupleTypes();
                    int targetTupleSize = tupleTypes.size();
                    Type tupleRestType = tupleType.getRestType();
                    boolean bl = noRestType = tupleRestType == null;
                    if (targetTupleSize <= tupleListIndex) {
                        if (noRestType) {
                            throw new ParserException("'" + String.valueOf(tupleType) + "' tuple size is not enough for the provided values");
                        }
                        tupleElementType = TypeUtils.getImpliedType(tupleRestType);
                    } else {
                        tupleElementType = TypeUtils.getImpliedType(tupleTypes.get(tupleListIndex));
                    }
                    this.addTargetType(tupleElementType);
                    break;
                }
                case 27: {
                    this.addTargetType(((MapType)lastTargetType).getConstrainedType());
                    break;
                }
                case 24: {
                    BRecordType recordType = (BRecordType)lastTargetType;
                    String fieldName = (String)this.fieldNames.getFirst();
                    Map<String, Field> fields = recordType.getFields();
                    Field field = fields.get(fieldName);
                    if (field == null) {
                        this.addTargetType(recordType.restFieldType);
                        break;
                    }
                    this.addTargetType(field.getFieldType());
                    break;
                }
                case 15: 
                case 17: 
                case 23: 
                case 33: 
                case 46: {
                    break;
                }
                default: {
                    throw new ParserException(UNSUPPORTED_TYPE + String.valueOf(lastTargetType) + "'");
                }
            }
        }

        private static Object getNonStringValueAsJson(String str) throws ParserException {
            if (str.indexOf(46) >= 0) {
                return JsonStateMachine.getFloatingPointValue(str);
            }
            char ch = str.charAt(0);
            if (ch == 't' && "true".equals(str)) {
                return Boolean.TRUE;
            }
            if (ch == 'f' && "false".equals(str)) {
                return Boolean.FALSE;
            }
            if (ch == 'n' && "null".equals(str)) {
                return null;
            }
            return JsonStateMachine.getNumericValue(str);
        }

        private static Object getNumericValue(String str) throws ParserException {
            try {
                if (JsonStateMachine.isNegativeZero(str) || mode == JsonUtils.NonStringValueProcessingMode.FROM_JSON_FLOAT_STRING) {
                    return Double.parseDouble(str);
                }
                if (JsonStateMachine.isExponential(str) || mode == JsonUtils.NonStringValueProcessingMode.FROM_JSON_DECIMAL_STRING) {
                    return new DecimalValue(str);
                }
                return Long.parseLong(str);
            }
            catch (NumberFormatException ignore) {
                throw new ParserException(UNRECOGNIZED_TOKEN + str + "'");
            }
        }

        private static Object getFloatingPointValue(String str) throws ParserException {
            try {
                if (JsonStateMachine.isNegativeZero(str) || mode == JsonUtils.NonStringValueProcessingMode.FROM_JSON_FLOAT_STRING) {
                    return Double.parseDouble(str);
                }
                return new DecimalValue(str);
            }
            catch (NumberFormatException ignore) {
                throw new ParserException(UNRECOGNIZED_TOKEN + str + "'");
            }
        }

        private void processNonStringValueAsJson(String str, StateMachine.ValueType type) throws ParserException {
            this.setValueToJsonType(type, JsonStateMachine.getNonStringValueAsJson(str));
        }

        @Override
        void processNonStringValue(StateMachine.ValueType type) throws ParserException {
            String str = this.value();
            Type targetType = this.targetTypes.get(this.targetTypes.size() - 1);
            Type referredType = TypeUtils.getImpliedType(targetType);
            switch (referredType.getTag()) {
                case 33: 
                case 46: {
                    this.processNonStringValueAsJson(str, type);
                    if (this.nodesStackSizeWhenUnionStarts != -1) break;
                    this.currentJsonNode = JsonStateMachine.convert(this.currentJsonNode, targetType);
                    break;
                }
                case 15: 
                case 17: 
                case 23: {
                    this.processNonStringValueAsJson(str, type);
                    break;
                }
                case 32: {
                    this.processArrayType(str, (ArrayType)referredType);
                    break;
                }
                case 44: {
                    this.processTupleType(str, (TupleType)referredType);
                    break;
                }
                case 27: {
                    this.processMapType(str, (MapType)referredType);
                    break;
                }
                case 24: {
                    this.processRecordType(str, (BRecordType)referredType);
                    break;
                }
                default: {
                    this.currentJsonNode = JsonStateMachine.convertValues(referredType, str);
                }
            }
        }

        private void processRecordType(String str, BRecordType referredType) throws ParserException {
            if (this.currentJsonNode == null) {
                throw new ParserException(UNRECOGNIZED_TOKEN + str + "'");
            }
            String fieldName = (String)this.fieldNames.pop();
            Map<String, Field> fields = referredType.getFields();
            Field field = fields.get(fieldName);
            Type fieldType = field == null ? referredType.restFieldType : field.getFieldType();
            ((MapValueImpl)this.currentJsonNode).putForcefully(StringUtils.fromString(fieldName), JsonStateMachine.convertValues(TypeUtils.getImpliedType(fieldType), str));
        }

        private void processMapType(String str, MapType referredType) throws ParserException {
            if (this.currentJsonNode == null) {
                throw new ParserException(UNRECOGNIZED_TOKEN + str + "'");
            }
            Type constrainedType = TypeUtils.getImpliedType(referredType.getConstrainedType());
            ((MapValueImpl)this.currentJsonNode).putForcefully(StringUtils.fromString((String)this.fieldNames.pop()), JsonStateMachine.convertValues(constrainedType, str));
        }

        private void processTupleType(String str, TupleType referredType) throws ParserException {
            Type tupleElementType;
            boolean noRestType;
            if (this.currentJsonNode == null) {
                throw new ParserException(UNRECOGNIZED_TOKEN + str + "'");
            }
            int tupleListIndex = this.listIndices.get(this.listIndices.size() - 1);
            List<Type> tupleTypes = referredType.getTupleTypes();
            int targetTupleSize = tupleTypes.size();
            Type tupleRestType = referredType.getRestType();
            boolean bl = noRestType = tupleRestType == null;
            if (targetTupleSize <= tupleListIndex) {
                if (noRestType) {
                    throw new ParserException("'" + String.valueOf(referredType) + "' tuple size is not enough for the provided values");
                }
                tupleElementType = TypeUtils.getImpliedType(tupleRestType);
            } else {
                tupleElementType = TypeUtils.getImpliedType(tupleTypes.get(tupleListIndex));
            }
            ((TupleValueImpl)this.currentJsonNode).addRefValueForcefully(tupleListIndex, JsonStateMachine.convertValues(tupleElementType, str));
            this.listIndices.set(this.listIndices.size() - 1, tupleListIndex + 1);
        }

        private void processArrayType(String str, ArrayType referredType) throws ParserException {
            if (this.currentJsonNode == null) {
                throw new ParserException(UNRECOGNIZED_TOKEN + str + "'");
            }
            int listIndex = this.listIndices.get(this.listIndices.size() - 1);
            Type elementType = TypeUtils.getImpliedType(referredType.getElementType());
            ((ArrayValueImpl)this.currentJsonNode).addRefValue(listIndex, JsonStateMachine.convertValues(elementType, str));
            this.listIndices.set(this.listIndices.size() - 1, listIndex + 1);
        }

        @Override
        void setValueToJsonType(StateMachine.ValueType type, Object value) {
            switch (type) {
                case ARRAY_ELEMENT: {
                    ArrayValueImpl arrayValue = (ArrayValueImpl)this.currentJsonNode;
                    arrayValue.addRefValueForcefully(arrayValue.size(), value);
                    break;
                }
                case FIELD: {
                    ((MapValueImpl)this.currentJsonNode).putForcefully(StringUtils.fromString((String)this.fieldNames.pop()), value);
                    break;
                }
                default: {
                    this.currentJsonNode = value;
                }
            }
        }

        private static Object convert(Object value, Type targetType) {
            return JsonStateMachine.convert(value, targetType, new HashSet<TypeValuePair>());
        }

        private static Object convert(Object value, Type targetType, Set<TypeValuePair> unresolvedValues) {
            if (value == null) {
                return JsonStateMachine.handleNullConversion(targetType);
            }
            Type sourceType = TypeUtils.getImpliedType(TypeChecker.getType(value));
            TypeValuePair typeValuePair = new TypeValuePair(value, targetType);
            if (unresolvedValues.contains(typeValuePair)) {
                throw ErrorCreator.createError(ErrorReasons.BALLERINA_PREFIXED_CYCLIC_VALUE_REFERENCE_ERROR, ErrorHelper.getErrorMessage(ErrorCodes.CYCLIC_VALUE_REFERENCE, sourceType));
            }
            unresolvedValues.add(typeValuePair);
            ArrayList<String> errors = new ArrayList<String>();
            Type convertibleType = TypeConverter.getConvertibleType(value, targetType, null, new HashSet<TypeValuePair>(), errors, true);
            if (convertibleType == null) {
                throw CloneUtils.createConversionError(value, targetType, errors);
            }
            Object newValue = JsonStateMachine.handleConversion(value, targetType, unresolvedValues, convertibleType, sourceType);
            unresolvedValues.remove(typeValuePair);
            return newValue;
        }

        private static Object handleConversion(Object value, Type targetType, Set<TypeValuePair> unresolvedValues, Type convertibleType, Type sourceType) {
            Type matchingType = TypeUtils.getImpliedType(convertibleType);
            return switch (sourceType.getTag()) {
                case 27 -> JsonStateMachine.convertMap((MapValueImpl)value, matchingType, convertibleType, unresolvedValues);
                case 32 -> JsonStateMachine.convertArray((ArrayValueImpl)value, matchingType, convertibleType, unresolvedValues);
                case 17, 24, 44 -> throw ErrorUtils.createConversionError(value, targetType);
                default -> JsonStateMachine.handleDefaultConversion(value, targetType, sourceType, matchingType);
            };
        }

        private static Object handleDefaultConversion(Object value, Type targetType, Type sourceType, Type matchingType) {
            if (TypeChecker.isRegExpType(targetType) && matchingType.getTag() == 5) {
                try {
                    return RegExpFactory.parse(((BString)value).getValue());
                }
                catch (BError e) {
                    throw ErrorUtils.createConversionError(value, targetType, e.getMessage());
                }
            }
            if (TypeChecker.checkIsType(value, matchingType)) {
                return value;
            }
            if (sourceType.getTag() <= 6) {
                return TypeConverter.convertValues(matchingType, value);
            }
            throw ErrorUtils.createConversionError(value, targetType);
        }

        private static Object handleNullConversion(Type targetType) {
            if (TypeUtils.getImpliedType(targetType).isNilable()) {
                return null;
            }
            throw ErrorCreator.createError(ErrorReasons.BALLERINA_PREFIXED_CONVERSION_ERROR, ErrorHelper.getErrorDetails(ErrorCodes.CANNOT_CONVERT_NIL, targetType));
        }

        private static Object convertArray(ArrayValueImpl array, Type targetType, Type targetRefType, Set<TypeValuePair> unresolvedValues) {
            switch (targetType.getTag()) {
                case 32: {
                    ArrayType arrayType = (ArrayType)targetType;
                    ArrayValueImpl newArray = new ArrayValueImpl(targetRefType, (long)arrayType.getSize());
                    for (int i = 0; i < array.size(); ++i) {
                        newArray.addRefValueForcefully(i, JsonStateMachine.convert(array.getRefValue(i), arrayType.getElementType(), unresolvedValues));
                    }
                    return newArray;
                }
                case 44: {
                    TupleType tupleType = (TupleType)targetType;
                    int minLen = tupleType.getTupleTypes().size();
                    BListInitialValueEntry[] tupleValues = new BListInitialValueEntry[array.size()];
                    for (int i = 0; i < array.size(); ++i) {
                        Type elementType = i < minLen ? tupleType.getTupleTypes().get(i) : tupleType.getRestType();
                        tupleValues[i] = ValueCreator.createListInitialValueEntry(JsonStateMachine.convert(array.getRefValue(i), elementType, unresolvedValues));
                    }
                    return new TupleValueImpl(targetRefType, tupleValues);
                }
                case 17: {
                    TableType tableType = (TableType)targetType;
                    for (int i = 0; i < array.size(); ++i) {
                        Object bMap = JsonStateMachine.convert(array.get(i), tableType.getConstrainedType(), unresolvedValues);
                        array.setRefValueForcefully(i, bMap);
                    }
                    array.setArrayRefTypeForcefully(TypeCreator.createArrayType(tableType.getConstrainedType()), array.size());
                    BArray fieldNames = StringUtils.fromStringArray(tableType.getFieldNames());
                    return new TableValueImpl(targetRefType, (ArrayValue)array, (ArrayValue)fieldNames);
                }
            }
            throw ErrorUtils.createConversionError(array, targetType);
        }

        private static Object convertMap(MapValueImpl<BString, Object> map, Type targetType, Type targetRefType, Set<TypeValuePair> unresolvedValues) {
            Set mapEntrySet = map.entrySet();
            switch (targetType.getTag()) {
                case 27: {
                    Type constraintType = ((MapType)targetType).getConstrainedType();
                    for (Map.Entry entry : mapEntrySet) {
                        Object newValue = JsonStateMachine.convert(entry.getValue(), constraintType, unresolvedValues);
                        map.putForcefully((BString)entry.getKey(), newValue);
                    }
                    map.setTypeForcefully(targetRefType);
                    return map;
                }
                case 24: {
                    RecordType recordType = (RecordType)targetType;
                    Type restFieldType = recordType.getRestFieldType();
                    HashMap<String, Type> targetTypeField = new HashMap<String, Type>();
                    for (Field field : recordType.getFields().values()) {
                        targetTypeField.put(field.getFieldName(), field.getFieldType());
                    }
                    for (Map.Entry entry : mapEntrySet) {
                        Type fieldType = targetTypeField.getOrDefault(((BString)entry.getKey()).toString(), restFieldType);
                        Object newValue = JsonStateMachine.convert(entry.getValue(), fieldType, unresolvedValues);
                        map.putForcefully((BString)entry.getKey(), newValue);
                    }
                    Optional<IntersectionType> intersectionType = ((BRecordType)TypeUtils.getImpliedType(targetRefType)).getIntersectionType();
                    if (targetRefType.isReadOnly() && intersectionType.isPresent() && !map.getType().isReadOnly()) {
                        Type type = ReadOnlyUtils.getMutableType((BIntersectionType)intersectionType.get());
                        MapValueImpl bMapValue = (MapValueImpl)ValueUtils.createRecordValue(type.getPackage(), type.getName(), map);
                        bMapValue.freezeDirect();
                        return bMapValue;
                    }
                    return ValueUtils.createRecordValue(targetRefType.getPackage(), targetRefType.getName(), map);
                }
            }
            throw ErrorUtils.createConversionError(map, targetType);
        }

        protected static class FieldNameState
        implements StateMachine.State {
            protected FieldNameState() {
            }

            @Override
            public StateMachine.State transition(StateMachine sm, char[] buff, int i, int count) throws ParserException {
                StateMachine.State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (ch == sm.currentQuoteChar) {
                        sm.processFieldName();
                        FieldNameState.processFieldNameValue(sm);
                        state = StateMachine.END_FIELD_NAME_STATE;
                    } else if (ch == '\\') {
                        state = StateMachine.FIELD_NAME_ESC_CHAR_PROCESSING_STATE;
                    } else {
                        if (ch == '\uffff') {
                            throw new ParserException(JsonStateMachine.UNEXPECTED_END_OF_THE_INPUT_STREAM);
                        }
                        sm.append(ch);
                        state = this;
                    }
                    if (ch == sm.currentQuoteChar || ch == '\\') break;
                    ++i;
                }
                sm.index = i + 1;
                return state;
            }

            private static void processFieldNameValue(StateMachine sm) throws ParserException {
                JsonStateMachine ssm = (JsonStateMachine)sm;
                Type parentTargetType = ssm.targetTypes.get(ssm.targetTypes.size() - 1);
                if (parentTargetType.getTag() == 24) {
                    BRecordType recordType = (BRecordType)parentTargetType;
                    String fieldName = sm.fieldNames.getFirst();
                    Map<String, Field> fields = recordType.getFields();
                    Field field = fields.get(fieldName);
                    if (field == null && recordType.sealed) {
                        throw new ParserException("field '" + fieldName + "' cannot be added to the closed record '" + String.valueOf(recordType) + "'");
                    }
                }
            }
        }

        protected static class StringValueState
        implements StateMachine.State {
            protected StringValueState() {
            }

            @Override
            public StateMachine.State transition(StateMachine sm, char[] buff, int i, int count) throws ParserException {
                StateMachine.State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (ch == sm.currentQuoteChar) {
                        StringValueState.processStringValue(sm);
                        state = StateMachine.DOC_END_STATE;
                    } else if (ch == '\\') {
                        state = StateMachine.STRING_VAL_ESC_CHAR_PROCESSING_STATE;
                    } else {
                        if (ch == '\uffff') {
                            throw new ParserException(JsonStateMachine.UNEXPECTED_END_OF_THE_INPUT_STREAM);
                        }
                        sm.append(ch);
                        state = this;
                    }
                    if (ch == sm.currentQuoteChar || ch == '\\') break;
                    ++i;
                }
                sm.index = i + 1;
                return state;
            }

            private static void processStringValue(StateMachine sm) throws ParserException {
                JsonStateMachine ssm = (JsonStateMachine)sm;
                Type targetType = ssm.targetTypes.get(ssm.targetTypes.size() - 1);
                BString bString = StringUtils.fromString(sm.value());
                if (ssm.nodesStackSizeWhenUnionStarts == -1) {
                    try {
                        sm.currentJsonNode = ValueConverter.getConvertedStringValue(bString, targetType);
                    }
                    catch (BError e) {
                        throw new ParserException(e.getMessage());
                    }
                } else {
                    sm.currentJsonNode = bString;
                }
            }
        }

        protected static class StringFieldValueState
        implements StateMachine.State {
            protected StringFieldValueState() {
            }

            @Override
            public StateMachine.State transition(StateMachine sm, char[] buff, int i, int count) throws ParserException {
                StateMachine.State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (ch == sm.currentQuoteChar) {
                        StringFieldValueState.processQuoteCharacter(sm);
                        state = StateMachine.FIELD_END_STATE;
                    } else if (ch == '\\') {
                        state = StateMachine.STRING_FIELD_ESC_CHAR_PROCESSING_STATE;
                    } else {
                        if (ch == '\uffff') {
                            throw new ParserException(JsonStateMachine.UNEXPECTED_END_OF_THE_INPUT_STREAM);
                        }
                        sm.append(ch);
                        state = this;
                    }
                    if (ch == sm.currentQuoteChar || ch == '\\') break;
                    ++i;
                }
                sm.index = i + 1;
                return state;
            }

            private static void processQuoteCharacter(StateMachine sm) throws ParserException {
                JsonStateMachine ssm = (JsonStateMachine)sm;
                Type targetType = ssm.targetTypes.get(ssm.targetTypes.size() - 1);
                Object bString = StringUtils.fromString(sm.value());
                switch (targetType.getTag()) {
                    case 27: {
                        try {
                            bString = ValueConverter.getConvertedStringValue((BString)bString, ((MapType)targetType).getConstrainedType());
                            break;
                        }
                        catch (BError e) {
                            throw new ParserException(e.getMessage());
                        }
                    }
                    case 24: {
                        Type fieldType = StringFieldValueState.getFieldType(sm, (BRecordType)targetType);
                        try {
                            bString = ValueConverter.getConvertedStringValue((BString)bString, fieldType);
                            break;
                        }
                        catch (BError e) {
                            throw new ParserException(e.getMessage());
                        }
                    }
                    case 15: 
                    case 17: 
                    case 23: 
                    case 33: 
                    case 46: {
                        break;
                    }
                    default: {
                        throw new ParserException(JsonStateMachine.UNSUPPORTED_TYPE + String.valueOf(targetType) + "'");
                    }
                }
                ((MapValueImpl)sm.currentJsonNode).putForcefully(StringUtils.fromString(sm.fieldNames.pop()), bString);
            }

            private static Type getFieldType(StateMachine sm, BRecordType targetType) {
                String fieldName = sm.fieldNames.getFirst();
                Map<String, Field> fields = targetType.getFields();
                Field field = fields.get(fieldName);
                return field == null ? targetType.restFieldType : field.getFieldType();
            }
        }

        protected static class StringArrayElementState
        implements StateMachine.State {
            protected StringArrayElementState() {
            }

            @Override
            public StateMachine.State transition(StateMachine sm, char[] buff, int i, int count) throws ParserException {
                StateMachine.State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (ch == sm.currentQuoteChar) {
                        StringArrayElementState.processQuoteCharacter(sm);
                        state = StateMachine.ARRAY_ELEMENT_END_STATE;
                    } else if (ch == '\\') {
                        state = StateMachine.STRING_AE_ESC_CHAR_PROCESSING_STATE;
                    } else {
                        if (ch == '\uffff') {
                            throw new ParserException(JsonStateMachine.UNEXPECTED_END_OF_THE_INPUT_STREAM);
                        }
                        sm.append(ch);
                        state = this;
                    }
                    if (ch == sm.currentQuoteChar || ch == '\\') break;
                    ++i;
                }
                sm.index = i + 1;
                return state;
            }

            private static void processQuoteCharacter(StateMachine sm) throws ParserException {
                JsonStateMachine ssm = (JsonStateMachine)sm;
                Type targetType = ssm.targetTypes.get(ssm.targetTypes.size() - 1);
                BString bString = StringUtils.fromString(sm.value());
                switch (targetType.getTag()) {
                    case 32: {
                        int listIndex = ssm.listIndices.get(ssm.listIndices.size() - 1);
                        try {
                            ((ArrayValueImpl)sm.currentJsonNode).convertStringAndAddRefValue(listIndex, bString);
                        }
                        catch (BError e) {
                            throw new ParserException(e.getMessage());
                        }
                        ssm.listIndices.set(ssm.listIndices.size() - 1, listIndex + 1);
                        break;
                    }
                    case 44: {
                        int listIndex = ssm.listIndices.get(ssm.listIndices.size() - 1);
                        try {
                            ((TupleValueImpl)sm.currentJsonNode).convertStringAndAddRefValue(listIndex, bString);
                        }
                        catch (BError e) {
                            throw new ParserException(e.getMessage());
                        }
                        ssm.listIndices.set(ssm.listIndices.size() - 1, listIndex + 1);
                        break;
                    }
                    case 15: 
                    case 23: 
                    case 33: 
                    case 46: {
                        ArrayValueImpl arrayValue = (ArrayValueImpl)sm.currentJsonNode;
                        arrayValue.addRefValueForcefully(arrayValue.size(), bString);
                        break;
                    }
                    default: {
                        throw new ParserException(JsonStateMachine.UNSUPPORTED_TYPE + String.valueOf(targetType) + "'");
                    }
                }
            }
        }
    }
}

