/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.identifier.Utils;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.flags.TypeFlags;
import io.ballerina.runtime.api.types.IntersectableReferenceType;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.CacheableTypeDescriptor;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.types.semtype.ShapeAnalyzer;
import io.ballerina.runtime.internal.types.BAnnotatableType;
import io.ballerina.runtime.internal.types.MayBeDependentType;
import io.ballerina.runtime.internal.types.ShapeSupplier;
import io.ballerina.runtime.internal.types.TypeWithShape;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class BTypeReferenceType
extends BAnnotatableType
implements IntersectableReferenceType,
TypeWithShape {
    private final int typeFlags;
    private final boolean readOnly;
    private Type referredType;
    private IntersectionType intersectionType;

    public BTypeReferenceType(String typeName, Module pkg, int typeFlags, boolean readOnly) {
        super(typeName, pkg, Object.class);
        this.typeFlags = typeFlags;
        this.readOnly = readOnly;
    }

    public void setReferredType(Type referredType) {
        this.referredType = referredType;
    }

    @Override
    public Type getReferredType() {
        return this.referredType;
    }

    public int getTypeFlags() {
        return this.typeFlags;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BTypeReferenceType) {
            BTypeReferenceType typeReferenceType = (BTypeReferenceType)obj;
            return this.referredType.equals(typeReferenceType.getReferredType());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.referredType);
    }

    @Override
    public String getAnnotationKey() {
        return Utils.decodeIdentifier((String)this.typeName);
    }

    @Override
    public <V> V getZeroValue() {
        return this.referredType.getZeroValue();
    }

    @Override
    public <V> V getEmptyValue() {
        return this.referredType.getEmptyValue();
    }

    @Override
    public int getTag() {
        return 53;
    }

    @Override
    public boolean isNilable() {
        return TypeFlags.isFlagOn(this.typeFlags, 1);
    }

    @Override
    public boolean isAnydata() {
        return TypeFlags.isFlagOn(this.typeFlags, 2);
    }

    @Override
    public boolean isPureType() {
        return TypeFlags.isFlagOn(this.typeFlags, 4);
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        return this.referredType.getBasicType();
    }

    @Override
    public int typeId() {
        Type type = this.referredType;
        if (type instanceof CacheableTypeDescriptor) {
            CacheableTypeDescriptor cacheableTypeDescriptor = (CacheableTypeDescriptor)type;
            return cacheableTypeDescriptor.typeId();
        }
        return super.typeId();
    }

    @Override
    public Optional<IntersectionType> getIntersectionType() {
        return this.intersectionType == null ? Optional.empty() : Optional.of(this.intersectionType);
    }

    @Override
    public void setIntersectionType(IntersectionType intersectionType) {
        this.intersectionType = intersectionType;
    }

    @Override
    public SemType createSemType(Context cx) {
        Type referredType = this.getReferredType();
        return BTypeReferenceType.tryInto(cx, referredType);
    }

    @Override
    protected boolean isDependentlyTypedInner(Set<MayBeDependentType> visited) {
        MayBeDependentType refType;
        Type type = this.getReferredType();
        return type instanceof MayBeDependentType && (refType = (MayBeDependentType)((Object)type)).isDependentlyTyped(visited);
    }

    @Override
    public Optional<SemType> inherentTypeOf(Context cx, ShapeSupplier shapeSupplier, Object object) {
        if (!this.couldInherentTypeBeDifferent()) {
            return Optional.of(this.getSemType(cx));
        }
        Type referredType = this.getReferredType();
        if (referredType instanceof TypeWithShape) {
            TypeWithShape typeWithShape = (TypeWithShape)((Object)referredType);
            return typeWithShape.inherentTypeOf(cx, shapeSupplier, object);
        }
        return Optional.empty();
    }

    @Override
    public boolean couldInherentTypeBeDifferent() {
        TypeWithShape typeWithShape;
        Type type = this.referredType;
        return type instanceof TypeWithShape && (typeWithShape = (TypeWithShape)((Object)type)).couldInherentTypeBeDifferent();
    }

    @Override
    public Optional<SemType> shapeOf(Context cx, ShapeSupplier shapeSupplierFn, Object object) {
        Type referredType = this.getReferredType();
        if (referredType instanceof TypeWithShape) {
            TypeWithShape typeWithShape = (TypeWithShape)((Object)referredType);
            return typeWithShape.shapeOf(cx, shapeSupplierFn, object);
        }
        return ShapeAnalyzer.shapeOf(cx, referredType);
    }

    @Override
    public SemType acceptedTypeOf(Context cx) {
        Type referredType = this.getReferredType();
        if (referredType instanceof TypeWithShape) {
            TypeWithShape typeWithShape = (TypeWithShape)((Object)referredType);
            return typeWithShape.acceptedTypeOf(cx);
        }
        return ShapeAnalyzer.acceptedTypeOf(cx, referredType);
    }
}

