/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.ParameterizedType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.XmlType;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.types.semtype.TypeCheckCache;
import io.ballerina.runtime.api.types.semtype.TypeCheckCacheFactory;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.runtime.internal.types.BType;
import io.ballerina.runtime.internal.types.BTypeReferenceType;
import io.ballerina.runtime.internal.types.ShapeSupplier;
import io.ballerina.runtime.internal.types.TypeIdSupplier;
import io.ballerina.runtime.internal.types.TypeWithShape;
import io.ballerina.runtime.internal.types.semtype.XmlUtils;
import io.ballerina.runtime.internal.values.ReadOnlyUtils;
import io.ballerina.runtime.internal.values.XmlComment;
import io.ballerina.runtime.internal.values.XmlItem;
import io.ballerina.runtime.internal.values.XmlPi;
import io.ballerina.runtime.internal.values.XmlSequence;
import io.ballerina.runtime.internal.values.XmlText;
import io.ballerina.runtime.internal.values.XmlValue;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class BXmlType
extends BType
implements XmlType,
TypeWithShape {
    private static final BasicTypeBitSet BASIC_TYPE = Builder.getXmlType();
    private final int tag;
    public final Type constraint;
    private final boolean readonly;
    private IntersectionType immutableType;
    private IntersectionType intersectionType = null;

    public BXmlType(String typeName, Type constraint, Module pkg) {
        super(typeName, pkg, XmlValue.class, false);
        this.constraint = constraint;
        this.tag = 16;
        this.readonly = false;
        this.initializeCache();
    }

    public BXmlType(String typeName, Module pkg, int tag, boolean readonly) {
        super(typeName, pkg, XmlValue.class, false);
        this.tag = tag;
        this.readonly = readonly;
        this.constraint = null;
        this.initializeCache();
    }

    public BXmlType(String typeName, Type constraint, Module pkg, int tag, boolean readonly) {
        super(typeName, pkg, XmlValue.class, false);
        this.tag = tag;
        this.readonly = readonly;
        this.constraint = constraint;
        this.initializeCache();
    }

    public BXmlType(String typeName, Type constraint, Module pkg, boolean readonly) {
        super(typeName, pkg, XmlValue.class, false);
        this.tag = 16;
        this.readonly = readonly;
        this.constraint = constraint;
        this.initializeCache();
    }

    public BXmlType(Type constraint, boolean readonly) {
        super("xml", null, XmlValue.class, false);
        this.tag = 16;
        this.constraint = readonly ? ReadOnlyUtils.getReadOnlyType(constraint) : constraint;
        this.readonly = readonly;
        this.initializeCache();
    }

    @Override
    protected void initializeCache() {
        TypeCheckFlyweightCache.TypeCheckFlyweight init = BXmlType.initCachedValues(this);
        this.typeCheckCache = init.typeCheckCache;
        this.typeId = init.typeId;
    }

    private static TypeCheckFlyweightCache.TypeCheckFlyweight initCachedValues(BXmlType xmlType) {
        if (xmlType.constraint != null) {
            if (xmlType.readonly) {
                return TypeCheckFlyweightCache.getRO(xmlType.constraint);
            }
            return TypeCheckFlyweightCache.getRW(xmlType.constraint);
        }
        if (xmlType.readonly) {
            return switch (xmlType.tag) {
                case 16 -> TypeCheckFlyweightCache.XML;
                case 18 -> TypeCheckFlyweightCache.XML_ELEMENT_RO;
                case 20 -> TypeCheckFlyweightCache.XML_COMMENT_RO;
                case 19 -> TypeCheckFlyweightCache.XML_PI_RO;
                case 21 -> TypeCheckFlyweightCache.XML_TEXT_RO;
                default -> throw new IllegalStateException("Unexpected value: " + xmlType.tag);
            };
        }
        return switch (xmlType.tag) {
            case 16 -> TypeCheckFlyweightCache.XML;
            case 18 -> TypeCheckFlyweightCache.XML_ELEMENT_RW;
            case 20 -> TypeCheckFlyweightCache.XML_COMMENT_RW;
            case 19 -> TypeCheckFlyweightCache.XML_PI_RW;
            case 21 -> TypeCheckFlyweightCache.XML_TEXT_RW;
            default -> throw new IllegalStateException("Unexpected value: " + xmlType.tag);
        };
    }

    @Override
    public <V> V getZeroValue() {
        return (V)new XmlSequence();
    }

    @Override
    public <V> V getEmptyValue() {
        return (V)new XmlSequence();
    }

    @Override
    public int getTag() {
        return this.tag;
    }

    @Override
    public boolean isAnydata() {
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (this != obj || !(obj instanceof BXmlType)) {
            return false;
        }
        BXmlType other = (BXmlType)obj;
        if (this.constraint == other.constraint) {
            return true;
        }
        return this.readonly == other.readonly && this.constraint.equals(other.constraint);
    }

    @Override
    public String toString() {
        if (this.constraint != null) {
            return "xml<" + String.valueOf(this.constraint) + ">";
        }
        return super.toString();
    }

    @Override
    public boolean isReadOnly() {
        return this.readonly;
    }

    @Override
    public IntersectionType getImmutableType() {
        return this.immutableType;
    }

    @Override
    public void setImmutableType(IntersectionType immutableType) {
        this.immutableType = immutableType;
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        return BASIC_TYPE;
    }

    @Override
    public Optional<IntersectionType> getIntersectionType() {
        return this.intersectionType == null ? Optional.empty() : Optional.of(this.intersectionType);
    }

    @Override
    public SemType createSemType(Context cx) {
        SemType semType;
        if (this.constraint == null) {
            semType = this.pickTopType();
        } else {
            SemType contraintSemtype;
            Type type = this.constraint;
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                contraintSemtype = BXmlType.tryInto(cx, parameterizedType.getParamValueType());
            } else {
                contraintSemtype = BXmlType.tryInto(cx, this.constraint);
            }
            semType = XmlUtils.xmlSequence(contraintSemtype);
        }
        return this.isReadOnly() ? Core.intersect(Builder.getReadonlyType(), semType) : semType;
    }

    private SemType pickTopType() {
        return switch (this.tag) {
            case 16 -> Builder.getXmlType();
            case 18 -> Builder.getXmlElementType();
            case 20 -> Builder.getXmlCommentType();
            case 19 -> Builder.getXmlPIType();
            case 21 -> Builder.getXmlTextType();
            default -> throw new IllegalStateException("Unexpected value: " + this.tag);
        };
    }

    @Override
    public void setIntersectionType(IntersectionType intersectionType) {
        this.intersectionType = intersectionType;
    }

    @Override
    public Optional<SemType> inherentTypeOf(Context cx, ShapeSupplier shapeSupplier, Object object) {
        XmlValue xmlValue = (XmlValue)object;
        if (!BXmlType.isReadOnly(xmlValue)) {
            return Optional.of(this.getSemType(cx));
        }
        return this.readonlyShapeOf(object);
    }

    @Override
    public boolean couldInherentTypeBeDifferent() {
        return true;
    }

    @Override
    public Optional<SemType> shapeOf(Context cx, ShapeSupplier shapeSupplierFn, Object object) {
        return this.readonlyShapeOf(object).map(semType -> Core.intersect(semType, Builder.getReadonlyType()));
    }

    @Override
    public SemType acceptedTypeOf(Context cx) {
        return this.getSemType(cx);
    }

    private Optional<SemType> readonlyShapeOf(Object object) {
        if (object instanceof XmlSequence) {
            XmlSequence xmlSequence = (XmlSequence)object;
            List<BXml> children = xmlSequence.getChildrenList();
            if (children.isEmpty()) {
                return Optional.of(XmlUtils.xmlSingleton(1));
            }
            if (children.size() == 1) {
                return this.readonlyShapeOf(children.get(0));
            }
            return children.stream().map(this::readonlyShapeOf).filter(Optional::isPresent).map(Optional::get).reduce(Core::union).map(XmlUtils::xmlSequence);
        }
        if (object instanceof XmlText) {
            return Optional.of(Builder.getXmlTextType());
        }
        if (object instanceof XmlItem) {
            XmlItem xml = (XmlItem)object;
            return BXmlType.getSemType(xml, Builder.getXmlElementType());
        }
        if (object instanceof XmlComment) {
            XmlComment xml = (XmlComment)object;
            return BXmlType.getSemType(xml, Builder.getXmlCommentType());
        }
        if (object instanceof XmlPi) {
            XmlPi xml = (XmlPi)object;
            return BXmlType.getSemType(xml, Builder.getXmlPIType());
        }
        throw new IllegalArgumentException("Unexpected xml value: " + String.valueOf(object));
    }

    private static Optional<SemType> getSemType(XmlValue xml, SemType baseType) {
        if (BXmlType.isReadOnly(xml)) {
            return Optional.of(Core.intersect(baseType, Builder.getReadonlyType()));
        }
        return Optional.of(baseType);
    }

    private static boolean isReadOnly(XmlValue xmlValue) {
        if (xmlValue instanceof XmlSequence || xmlValue instanceof XmlText) {
            return true;
        }
        return xmlValue.getType().isReadOnly();
    }

    private static class TypeCheckFlyweightCache {
        private static final Map<Type, TypeCheckFlyweight> cacheRO = new IdentityHashMap<Type, TypeCheckFlyweight>();
        private static final Map<Type, TypeCheckFlyweight> cacheRW = new IdentityHashMap<Type, TypeCheckFlyweight>();
        private static final TypeCheckFlyweight XML = TypeCheckFlyweightCache.initReserved();
        private static final TypeCheckFlyweight XML_ELEMENT_RW = TypeCheckFlyweightCache.initReserved();
        private static final TypeCheckFlyweight XML_COMMENT_RW = TypeCheckFlyweightCache.initReserved();
        private static final TypeCheckFlyweight XML_PI_RW = TypeCheckFlyweightCache.initReserved();
        private static final TypeCheckFlyweight XML_TEXT_RW = TypeCheckFlyweightCache.initReserved();
        private static final TypeCheckFlyweight XML_ELEMENT_RO = TypeCheckFlyweightCache.initReserved();
        private static final TypeCheckFlyweight XML_COMMENT_RO = TypeCheckFlyweightCache.initReserved();
        private static final TypeCheckFlyweight XML_PI_RO = TypeCheckFlyweightCache.initReserved();
        private static final TypeCheckFlyweight XML_TEXT_RO = TypeCheckFlyweightCache.initReserved();

        private TypeCheckFlyweightCache() {
        }

        private static TypeCheckFlyweight initReserved() {
            return new TypeCheckFlyweight(TypeIdSupplier.getReservedId(), TypeCheckCacheFactory.create());
        }

        private static TypeCheckFlyweight init() {
            return new TypeCheckFlyweight(TypeIdSupplier.getNamedId(), TypeCheckCacheFactory.create());
        }

        private static TypeCheckFlyweight getRO(Type constraint) {
            if (constraint instanceof BTypeReferenceType) {
                return TypeCheckFlyweightCache.getRO(TypeUtils.getReferredType(constraint));
            }
            return cacheRO.computeIfAbsent(constraint, ignored -> TypeCheckFlyweightCache.init());
        }

        private static TypeCheckFlyweight getRW(Type constraint) {
            if (constraint instanceof BTypeReferenceType) {
                return TypeCheckFlyweightCache.getRW(TypeUtils.getReferredType(constraint));
            }
            return cacheRW.computeIfAbsent(constraint, ignored -> TypeCheckFlyweightCache.init());
        }

        private record TypeCheckFlyweight(int typeId, TypeCheckCache typeCheckCache) {
        }
    }
}

