/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types.semtype;

import io.ballerina.runtime.api.types.semtype.Atom;
import io.ballerina.runtime.api.types.semtype.Bdd;
import io.ballerina.runtime.api.types.semtype.BddNode;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.types.semtype.SubType;
import io.ballerina.runtime.api.types.semtype.TypeAtom;
import io.ballerina.runtime.internal.types.semtype.BCellSubTypeImpl;
import io.ballerina.runtime.internal.types.semtype.BCellSubTypeSimple;
import io.ballerina.runtime.internal.types.semtype.CellAtomicType;
import io.ballerina.runtime.internal.types.semtype.DelegatedSubType;

public abstract sealed class BCellSubType
extends SubType
implements DelegatedSubType
permits BCellSubTypeImpl, BCellSubTypeSimple {
    public BCellSubType(boolean all, boolean nothing) {
        super(all, nothing);
    }

    public static BCellSubType createDelegate(SubType inner) {
        BddNode bddNode;
        Bdd bdd;
        if (inner instanceof Bdd) {
            Bdd b;
            bdd = b = (Bdd)inner;
        } else if (inner instanceof BCellSubTypeImpl) {
            BCellSubTypeImpl bCellImpl = (BCellSubTypeImpl)inner;
            bdd = bCellImpl.inner();
        } else {
            if (inner instanceof BCellSubTypeSimple) {
                BCellSubTypeSimple simple = (BCellSubTypeSimple)inner;
                return simple;
            }
            throw new IllegalArgumentException("Unexpected inner type");
        }
        if (!(bdd instanceof BddNode) || !(bddNode = (BddNode)bdd).isSimple()) {
            return new BCellSubTypeImpl(bdd);
        }
        Atom atom = bddNode.atom();
        if (!(atom instanceof TypeAtom)) {
            return new BCellSubTypeImpl(bdd);
        }
        TypeAtom typeAtom = (TypeAtom)atom;
        CellAtomicType atomicType = (CellAtomicType)typeAtom.atomicType();
        SemType ty = atomicType.ty();
        if (Core.containsBasicType(ty, Builder.getUndefType()) || ty.some() != 0 || atomicType.mut() != CellAtomicType.CellMutability.CELL_MUT_LIMITED) {
            return new BCellSubTypeImpl(bdd);
        }
        return new BCellSubTypeSimple(ty, bddNode);
    }
}

