/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types.semtype;

import io.ballerina.runtime.api.types.semtype.Bdd;
import io.ballerina.runtime.api.types.semtype.BddAllOrNothing;
import io.ballerina.runtime.api.types.semtype.BddNode;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.Env;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.types.semtype.SubType;
import io.ballerina.runtime.api.types.semtype.TypeAtom;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.types.semtype.BCellSubType;
import io.ballerina.runtime.internal.types.semtype.BCellSubTypeImpl;
import io.ballerina.runtime.internal.types.semtype.CellAtomicType;
import io.ballerina.runtime.internal.types.semtype.DelegatedSubType;
import io.ballerina.runtime.internal.types.semtype.SubTypeData;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

final class BCellSubTypeSimple
extends BCellSubType
implements DelegatedSubType {
    private final List<SemType> pos;
    private final List<SemType> neg;
    private BddNode inner;

    BCellSubTypeSimple(SemType type) {
        super(type.all() == 262143, type.all() == 0);
        assert (type.some() == 0);
        this.pos = List.of(type);
        this.neg = List.of();
    }

    BCellSubTypeSimple(SemType type, BddNode bddNode) {
        this(type);
        this.inner = bddNode;
    }

    private BCellSubTypeSimple(List<SemType> pos, List<SemType> neg) {
        super(false, false);
        this.pos = pos;
        this.neg = neg;
    }

    @Override
    public SubType union(SubType other) {
        if (other instanceof BCellSubTypeSimple) {
            BCellSubTypeSimple simple = (BCellSubTypeSimple)other;
            List<SemType> combinedPos = Stream.concat(this.pos.stream(), simple.pos.stream()).toList();
            List<SemType> combinedNeg = Stream.concat(this.neg.stream(), simple.neg.stream()).toList();
            return new BCellSubTypeSimple(combinedPos, combinedNeg);
        }
        if (other instanceof BCellSubTypeImpl) {
            BCellSubTypeImpl complex = (BCellSubTypeImpl)other;
            return BCellSubTypeSimple.createDelegate(this.inner().union(complex.inner()));
        }
        throw new IllegalArgumentException("union of different subtypes");
    }

    @Override
    public SubType intersect(SubType other) {
        if (other instanceof BCellSubTypeSimple) {
            BCellSubTypeSimple simple = (BCellSubTypeSimple)other;
            SemType pos = Stream.concat(this.pos.stream(), simple.pos.stream()).reduce(Builder.getValType(), Core::intersect);
            List<SemType> neg = Stream.concat(this.neg.stream(), simple.neg.stream()).toList();
            return new BCellSubTypeSimple(List.of(pos), neg);
        }
        if (other instanceof BCellSubTypeImpl) {
            BCellSubTypeImpl complex = (BCellSubTypeImpl)other;
            return BCellSubTypeSimple.createDelegate(this.inner().intersect(complex.inner()));
        }
        throw new IllegalArgumentException("intersection of different subtypes");
    }

    @Override
    public SubType complement() {
        return new BCellSubTypeSimple(this.neg, this.pos);
    }

    @Override
    public boolean isEmpty(Context cx) {
        if (this.pos.isEmpty()) {
            return true;
        }
        SemType posUnion = this.pos.stream().reduce(Builder.getNeverType(), Core::union);
        if (this.neg.isEmpty()) {
            return Core.isEmpty(cx, posUnion);
        }
        return this.neg.stream().anyMatch(neg -> Core.isEmpty(cx, Core.diff(posUnion, neg)));
    }

    @Override
    public SubTypeData data() {
        throw new IllegalStateException("unimplemented");
    }

    @Override
    public SubType inner() {
        if (this.inner != null) {
            return this.inner;
        }
        Env env = TypeChecker.getEnv();
        Optional<Bdd> posBdd = this.pos.stream().map(semType -> BCellSubTypeSimple.fromSemType(env, semType)).reduce((acum, bdd) -> (Bdd)acum.union((SubType)bdd));
        if (posBdd.isEmpty()) {
            return BddAllOrNothing.NOTHING;
        }
        Optional<Bdd> negBdd = this.neg.stream().map(semType -> BCellSubTypeSimple.fromSemType(env, semType)).reduce((acum, bdd) -> (Bdd)acum.union((SubType)bdd));
        if (negBdd.isEmpty()) {
            return posBdd.get();
        }
        return posBdd.get().diff(negBdd.get());
    }

    private static Bdd fromSemType(Env env, SemType type) {
        CellAtomicType atomicCell = CellAtomicType.from(type, CellAtomicType.CellMutability.CELL_MUT_LIMITED);
        TypeAtom atom = env.cellAtom(atomicCell);
        return BddNode.bddAtom(atom);
    }

    @Override
    public int hashCode() {
        return Stream.concat(this.pos.stream(), this.neg.stream()).map(Object::hashCode).reduce(0, Integer::sum);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BCellSubTypeSimple)) {
            return false;
        }
        BCellSubTypeSimple other = (BCellSubTypeSimple)o;
        return this.pos.equals(other.pos) && this.neg.equals(other.neg);
    }
}

