/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.utils;

import com.github.benmanes.caffeine.cache.LoadingCache;
import io.ballerina.runtime.api.flags.TypeFlags;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.internal.types.BField;
import io.ballerina.runtime.internal.types.BRecordType;
import io.ballerina.runtime.internal.types.semtype.CacheFactory;
import java.util.Map;

public final class IteratorUtils {
    private static final LoadingCache<Type, BRecordType> iteratorNextReturnTypeCache = CacheFactory.createCache(IteratorUtils::createIteratorNextReturnTypeInner);

    private IteratorUtils() {
    }

    public static int getTypeFlags(Type type) {
        if (type.isAnydata()) {
            return TypeFlags.asMask(4, 2);
        }
        if (type.isPureType()) {
            return 4;
        }
        return 0;
    }

    public static BRecordType createIteratorNextReturnType(Type type) {
        return (BRecordType)iteratorNextReturnTypeCache.get((Object)type);
    }

    private static BRecordType createIteratorNextReturnTypeInner(Type type) {
        Map<String, Field> fields = Map.of("value", new BField(type, "value", 257L));
        return new BRecordType("$$returnType$$", null, 0L, fields, null, true, IteratorUtils.getTypeFlags(type));
    }
}

